/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.text.split;

import cn.hutool.core.collection.ComputeIter;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.finder.TextFinder;
import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class SplitIter
extends ComputeIter<String>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String text;
    private final TextFinder finder;
    private final int limit;
    private final boolean ignoreEmpty;
    private int offset;
    private int count;

    public SplitIter(CharSequence text2, TextFinder separatorFinder, int limit, boolean ignoreEmpty) {
        Assert.notNull(text2, "Text must be not null!", new Object[0]);
        this.text = text2.toString();
        this.finder = separatorFinder.setText(text2);
        this.limit = limit > 0 ? limit : Integer.MAX_VALUE;
        this.ignoreEmpty = ignoreEmpty;
    }

    @Override
    protected String computeNext() {
        if (this.count >= this.limit || this.offset > this.text.length()) {
            return null;
        }
        if (this.count == this.limit - 1) {
            if (this.ignoreEmpty && this.offset == this.text.length()) {
                return null;
            }
            ++this.count;
            return this.text.substring(this.offset);
        }
        int start2 = this.finder.start(this.offset);
        if (start2 < 0) {
            if (this.offset <= this.text.length()) {
                String result2 = this.text.substring(this.offset);
                if (!this.ignoreEmpty || !result2.isEmpty()) {
                    this.offset = Integer.MAX_VALUE;
                    return result2;
                }
            }
            return null;
        }
        String result3 = this.text.substring(this.offset, start2);
        this.offset = this.finder.end(start2);
        if (this.ignoreEmpty && result3.isEmpty()) {
            return this.computeNext();
        }
        ++this.count;
        return result3;
    }

    public void reset() {
        this.finder.reset();
        this.offset = 0;
        this.count = 0;
    }

    public String[] toArray(boolean trim) {
        return this.toList(trim).toArray(new String[0]);
    }

    public List<String> toList(boolean trim) {
        return this.toList(str -> trim ? StrUtil.trim(str) : str);
    }

    public <T> List<T> toList(Function<String, T> mapping) {
        ArrayList<T> result2 = new ArrayList<T>();
        while (this.hasNext()) {
            T apply2 = mapping.apply((String)this.next());
            if (this.ignoreEmpty && StrUtil.isEmptyIfStr(apply2)) continue;
            result2.add(apply2);
        }
        if (result2.isEmpty()) {
            return new ArrayList(0);
        }
        return result2;
    }
}

