/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.util.StrUtil;

public class DesensitizedUtil {
    public static String desensitized(CharSequence str, DesensitizedType desensitizedType) {
        if (StrUtil.isBlank(str)) {
            return "";
        }
        String newStr = String.valueOf(str);
        switch (desensitizedType) {
            case USER_ID: {
                newStr = String.valueOf(DesensitizedUtil.userId());
                break;
            }
            case CHINESE_NAME: {
                newStr = DesensitizedUtil.chineseName(String.valueOf(str));
                break;
            }
            case ID_CARD: {
                newStr = DesensitizedUtil.idCardNum(String.valueOf(str), 1, 2);
                break;
            }
            case FIXED_PHONE: {
                newStr = DesensitizedUtil.fixedPhone(String.valueOf(str));
                break;
            }
            case MOBILE_PHONE: {
                newStr = DesensitizedUtil.mobilePhone(String.valueOf(str));
                break;
            }
            case ADDRESS: {
                newStr = DesensitizedUtil.address(String.valueOf(str), 8);
                break;
            }
            case EMAIL: {
                newStr = DesensitizedUtil.email(String.valueOf(str));
                break;
            }
            case PASSWORD: {
                newStr = DesensitizedUtil.password(String.valueOf(str));
                break;
            }
            case CAR_LICENSE: {
                newStr = DesensitizedUtil.carLicense(String.valueOf(str));
                break;
            }
            case BANK_CARD: {
                newStr = DesensitizedUtil.bankCard(String.valueOf(str));
                break;
            }
            case IPV4: {
                newStr = DesensitizedUtil.ipv4(String.valueOf(str));
                break;
            }
            case IPV6: {
                newStr = DesensitizedUtil.ipv6(String.valueOf(str));
                break;
            }
            case FIRST_MASK: {
                newStr = DesensitizedUtil.firstMask(String.valueOf(str));
                break;
            }
        }
        return newStr;
    }

    public static Long userId() {
        return 0L;
    }

    public static String firstMask(String str) {
        if (StrUtil.isBlank(str)) {
            return "";
        }
        return StrUtil.hide(str, 1, str.length());
    }

    public static String chineseName(String fullName) {
        return DesensitizedUtil.firstMask(fullName);
    }

    public static String idCardNum(String idCardNum, int front, int end) {
        if (StrUtil.isBlank(idCardNum)) {
            return "";
        }
        if (front + end > idCardNum.length()) {
            return "";
        }
        if (front < 0 || end < 0) {
            return "";
        }
        return StrUtil.hide(idCardNum, front, idCardNum.length() - end);
    }

    public static String fixedPhone(String num) {
        if (StrUtil.isBlank(num)) {
            return "";
        }
        return StrUtil.hide(num, 4, num.length() - 2);
    }

    public static String mobilePhone(String num) {
        if (StrUtil.isBlank(num)) {
            return "";
        }
        return StrUtil.hide(num, 3, num.length() - 4);
    }

    public static String address(String address, int sensitiveSize) {
        if (StrUtil.isBlank(address)) {
            return "";
        }
        int length = address.length();
        return StrUtil.hide(address, length - sensitiveSize, length);
    }

    public static String email(String email) {
        if (StrUtil.isBlank(email)) {
            return "";
        }
        int index = StrUtil.indexOf(email, '@');
        if (index <= 1) {
            return email;
        }
        return StrUtil.hide(email, 1, index);
    }

    public static String password(String password) {
        if (StrUtil.isBlank(password)) {
            return "";
        }
        return StrUtil.repeat('*', password.length());
    }

    public static String carLicense(String carLicense) {
        if (StrUtil.isBlank(carLicense)) {
            return "";
        }
        if (carLicense.length() == 7) {
            carLicense = StrUtil.hide(carLicense, 3, 6);
        } else if (carLicense.length() == 8) {
            carLicense = StrUtil.hide(carLicense, 3, 7);
        }
        return carLicense;
    }

    public static String bankCard(String bankCardNo) {
        if (StrUtil.isBlank(bankCardNo)) {
            return bankCardNo;
        }
        if ((bankCardNo = StrUtil.trim(bankCardNo)).length() < 9) {
            return bankCardNo;
        }
        int length = bankCardNo.length();
        int midLength = length - 8;
        StringBuilder buf = new StringBuilder();
        buf.append(bankCardNo, 0, 4);
        for (int i2 = 0; i2 < midLength; ++i2) {
            if (i2 % 4 == 0) {
                buf.append(' ');
            }
            buf.append('*');
        }
        buf.append(' ').append(bankCardNo, length - 4, length);
        return buf.toString();
    }

    public static String ipv4(String ipv4) {
        return StrUtil.subBefore((CharSequence)ipv4, '.', false) + ".*.*.*";
    }

    public static String ipv6(String ipv6) {
        return StrUtil.subBefore((CharSequence)ipv6, ':', false) + ":*:*:*:*:*:*:*";
    }

    public static enum DesensitizedType {
        USER_ID,
        CHINESE_NAME,
        ID_CARD,
        FIXED_PHONE,
        MOBILE_PHONE,
        ADDRESS,
        EMAIL,
        PASSWORD,
        CAR_LICENSE,
        BANK_CARD,
        IPV4,
        IPV6,
        FIRST_MASK;

    }
}

