/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ModifierUtil {
    public static boolean hasModifier(Class<?> clazz, ModifierType ... modifierTypes) {
        if (null == clazz || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (clazz.getModifiers() & ModifierUtil.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Constructor<?> constructor, ModifierType ... modifierTypes) {
        if (null == constructor || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (constructor.getModifiers() & ModifierUtil.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Method method, ModifierType ... modifierTypes) {
        if (null == method || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (method.getModifiers() & ModifierUtil.modifiersToInt(modifierTypes));
    }

    public static boolean hasModifier(Field field2, ModifierType ... modifierTypes) {
        if (null == field2 || ArrayUtil.isEmpty(modifierTypes)) {
            return false;
        }
        return 0 != (field2.getModifiers() & ModifierUtil.modifiersToInt(modifierTypes));
    }

    public static boolean isPublic(Field field2) {
        return ModifierUtil.hasModifier(field2, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Method method) {
        return ModifierUtil.hasModifier(method, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Class<?> clazz) {
        return ModifierUtil.hasModifier(clazz, ModifierType.PUBLIC);
    }

    public static boolean isPublic(Constructor<?> constructor) {
        return ModifierUtil.hasModifier(constructor, ModifierType.PUBLIC);
    }

    public static boolean isStatic(Field field2) {
        return ModifierUtil.hasModifier(field2, ModifierType.STATIC);
    }

    public static boolean isStatic(Method method) {
        return ModifierUtil.hasModifier(method, ModifierType.STATIC);
    }

    public static boolean isStatic(Class<?> clazz) {
        return ModifierUtil.hasModifier(clazz, ModifierType.STATIC);
    }

    public static boolean isSynthetic(Field field2) {
        return field2.isSynthetic();
    }

    public static boolean isSynthetic(Method method) {
        return method.isSynthetic();
    }

    public static boolean isSynthetic(Class<?> clazz) {
        return clazz.isSynthetic();
    }

    public static boolean isAbstract(Method method) {
        return ModifierUtil.hasModifier(method, ModifierType.ABSTRACT);
    }

    public static void removeFinalModify(Field field2) {
        if (field2 != null && ModifierUtil.hasModifier(field2, ModifierType.FINAL)) {
            if (!field2.isAccessible()) {
                field2.setAccessible(true);
            }
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field2, field2.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new UtilException(e, "IllegalAccess for {}.{}", field2.getDeclaringClass(), field2.getName());
            }
        }
    }

    private static int modifiersToInt(ModifierType ... modifierTypes) {
        int modifier = modifierTypes[0].getValue();
        for (int i2 = 1; i2 < modifierTypes.length; ++i2) {
            modifier |= modifierTypes[i2].getValue();
        }
        return modifier;
    }

    public static enum ModifierType {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        STATIC(8),
        FINAL(16),
        SYNCHRONIZED(32),
        VOLATILE(64),
        TRANSIENT(128),
        NATIVE(256),
        ABSTRACT(1024),
        STRICT(2048);

        private final int value;

        private ModifierType(int modifier) {
            this.value = modifier;
        }

        public int getValue() {
            return this.value;
        }
    }
}

