/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.math.Calculator;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;

public class NumberUtil {
    private static final int DEFAULT_DIV_SCALE = 10;
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    public static double add(float v1, float v2) {
        return NumberUtil.add(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(float v1, double v2) {
        return NumberUtil.add(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(double v1, float v2) {
        return NumberUtil.add(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double add(double v1, double v2) {
        return NumberUtil.add(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double add(Double v1, Double v2) {
        return NumberUtil.add((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal add(Number v1, Number v2) {
        return NumberUtil.add(new Number[]{v1, v2});
    }

    public static BigDecimal add(Number ... values2) {
        if (ArrayUtil.isEmpty(values2)) {
            return BigDecimal.ZERO;
        }
        Number value = values2[0];
        BigDecimal result2 = NumberUtil.toBigDecimal(value);
        for (int i2 = 1; i2 < values2.length; ++i2) {
            value = values2[i2];
            if (null == value) continue;
            result2 = result2.add(NumberUtil.toBigDecimal(value));
        }
        return result2;
    }

    public static BigDecimal add(String ... values2) {
        if (ArrayUtil.isEmpty(values2)) {
            return BigDecimal.ZERO;
        }
        String value = values2[0];
        BigDecimal result2 = NumberUtil.toBigDecimal(value);
        for (int i2 = 1; i2 < values2.length; ++i2) {
            value = values2[i2];
            if (!StrUtil.isNotBlank(value)) continue;
            result2 = result2.add(NumberUtil.toBigDecimal(value));
        }
        return result2;
    }

    public static BigDecimal add(BigDecimal ... values2) {
        if (ArrayUtil.isEmpty(values2)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values2[0];
        BigDecimal result2 = NumberUtil.toBigDecimal(value);
        for (int i2 = 1; i2 < values2.length; ++i2) {
            value = values2[i2];
            if (null == value) continue;
            result2 = result2.add(value);
        }
        return result2;
    }

    public static double sub(float v1, float v2) {
        return NumberUtil.sub(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(float v1, double v2) {
        return NumberUtil.sub(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(double v1, float v2) {
        return NumberUtil.sub(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double sub(double v1, double v2) {
        return NumberUtil.sub(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double sub(Double v1, Double v2) {
        return NumberUtil.sub((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal sub(Number v1, Number v2) {
        return NumberUtil.sub(new Number[]{v1, v2});
    }

    public static BigDecimal sub(Number ... values2) {
        if (ArrayUtil.isEmpty(values2)) {
            return BigDecimal.ZERO;
        }
        Number value = values2[0];
        BigDecimal result2 = NumberUtil.toBigDecimal(value);
        for (int i2 = 1; i2 < values2.length; ++i2) {
            value = values2[i2];
            if (null == value) continue;
            result2 = result2.subtract(NumberUtil.toBigDecimal(value));
        }
        return result2;
    }

    public static BigDecimal sub(String ... values2) {
        if (ArrayUtil.isEmpty(values2)) {
            return BigDecimal.ZERO;
        }
        String value = values2[0];
        BigDecimal result2 = NumberUtil.toBigDecimal(value);
        for (int i2 = 1; i2 < values2.length; ++i2) {
            value = values2[i2];
            if (!StrUtil.isNotBlank(value)) continue;
            result2 = result2.subtract(NumberUtil.toBigDecimal(value));
        }
        return result2;
    }

    public static BigDecimal sub(BigDecimal ... values2) {
        if (ArrayUtil.isEmpty(values2)) {
            return BigDecimal.ZERO;
        }
        BigDecimal value = values2[0];
        BigDecimal result2 = NumberUtil.toBigDecimal(value);
        for (int i2 = 1; i2 < values2.length; ++i2) {
            value = values2[i2];
            if (null == value) continue;
            result2 = result2.subtract(value);
        }
        return result2;
    }

    public static double mul(float v1, float v2) {
        return NumberUtil.mul(Float.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(float v1, double v2) {
        return NumberUtil.mul(Float.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(double v1, float v2) {
        return NumberUtil.mul(Double.toString(v1), Float.toString(v2)).doubleValue();
    }

    public static double mul(double v1, double v2) {
        return NumberUtil.mul(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public static double mul(Double v1, Double v2) {
        return NumberUtil.mul((Number)v1, (Number)v2).doubleValue();
    }

    public static BigDecimal mul(Number v1, Number v2) {
        return NumberUtil.mul(new Number[]{v1, v2});
    }

    public static BigDecimal mul(Number ... values2) {
        if (ArrayUtil.isEmpty(values2) || ArrayUtil.hasNull(values2)) {
            return BigDecimal.ZERO;
        }
        Number value = values2[0];
        BigDecimal result2 = new BigDecimal(value.toString());
        for (int i2 = 1; i2 < values2.length; ++i2) {
            value = values2[i2];
            result2 = result2.multiply(new BigDecimal(value.toString()));
        }
        return result2;
    }

    public static BigDecimal mul(String v1, String v2) {
        return NumberUtil.mul((Number)new BigDecimal(v1), (Number)new BigDecimal(v2));
    }

    public static BigDecimal mul(String ... values2) {
        if (ArrayUtil.isEmpty(values2) || ArrayUtil.hasNull(values2)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result2 = new BigDecimal(values2[0]);
        for (int i2 = 1; i2 < values2.length; ++i2) {
            result2 = result2.multiply(new BigDecimal(values2[i2]));
        }
        return result2;
    }

    public static BigDecimal mul(BigDecimal ... values2) {
        if (ArrayUtil.isEmpty(values2) || ArrayUtil.hasNull(values2)) {
            return BigDecimal.ZERO;
        }
        BigDecimal result2 = values2[0];
        for (int i2 = 1; i2 < values2.length; ++i2) {
            result2 = result2.multiply(values2[i2]);
        }
        return result2;
    }

    public static double div(float v1, float v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static double div(float v1, double v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static double div(double v1, float v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static double div(double v1, double v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static double div(Double v1, Double v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static BigDecimal div(Number v1, Number v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static BigDecimal div(String v1, String v2) {
        return NumberUtil.div(v1, v2, 10);
    }

    public static double div(float v1, float v2, int scale2) {
        return NumberUtil.div(v1, v2, scale2, RoundingMode.HALF_UP);
    }

    public static double div(float v1, double v2, int scale2) {
        return NumberUtil.div(v1, v2, scale2, RoundingMode.HALF_UP);
    }

    public static double div(double v1, float v2, int scale2) {
        return NumberUtil.div(v1, v2, scale2, RoundingMode.HALF_UP);
    }

    public static double div(double v1, double v2, int scale2) {
        return NumberUtil.div(v1, v2, scale2, RoundingMode.HALF_UP);
    }

    public static double div(Double v1, Double v2, int scale2) {
        return NumberUtil.div(v1, v2, scale2, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(Number v1, Number v2, int scale2) {
        return NumberUtil.div(v1, v2, scale2, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String v1, String v2, int scale2) {
        return NumberUtil.div(v1, v2, scale2, RoundingMode.HALF_UP);
    }

    public static double div(float v1, float v2, int scale2, RoundingMode roundingMode) {
        return NumberUtil.div(Float.toString(v1), Float.toString(v2), scale2, roundingMode).doubleValue();
    }

    public static double div(float v1, double v2, int scale2, RoundingMode roundingMode) {
        return NumberUtil.div(Float.toString(v1), Double.toString(v2), scale2, roundingMode).doubleValue();
    }

    public static double div(double v1, float v2, int scale2, RoundingMode roundingMode) {
        return NumberUtil.div(Double.toString(v1), Float.toString(v2), scale2, roundingMode).doubleValue();
    }

    public static double div(double v1, double v2, int scale2, RoundingMode roundingMode) {
        return NumberUtil.div(Double.toString(v1), Double.toString(v2), scale2, roundingMode).doubleValue();
    }

    public static double div(Double v1, Double v2, int scale2, RoundingMode roundingMode) {
        return NumberUtil.div((Number)v1, (Number)v2, scale2, roundingMode).doubleValue();
    }

    public static BigDecimal div(Number v1, Number v2, int scale2, RoundingMode roundingMode) {
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return NumberUtil.div((BigDecimal)v1, (BigDecimal)v2, scale2, roundingMode);
        }
        return NumberUtil.div(StrUtil.toStringOrNull(v1), StrUtil.toStringOrNull(v2), scale2, roundingMode);
    }

    public static BigDecimal div(String v1, String v2, int scale2, RoundingMode roundingMode) {
        return NumberUtil.div(NumberUtil.toBigDecimal(v1), NumberUtil.toBigDecimal(v2), scale2, roundingMode);
    }

    public static BigDecimal div(BigDecimal v1, BigDecimal v2, int scale2, RoundingMode roundingMode) {
        Assert.notNull(v2, "Divisor must be not null !", new Object[0]);
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (scale2 < 0) {
            scale2 = -scale2;
        }
        return v1.divide(v2, scale2, roundingMode);
    }

    public static int ceilDiv(int v1, int v2) {
        return (int)Math.ceil((double)v1 / (double)v2);
    }

    public static BigDecimal round(double v, int scale2) {
        return NumberUtil.round(v, scale2, RoundingMode.HALF_UP);
    }

    public static String roundStr(double v, int scale2) {
        return NumberUtil.round(v, scale2).toPlainString();
    }

    public static BigDecimal round(String numberStr, int scale2) {
        return NumberUtil.round(numberStr, scale2, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal number, int scale2) {
        return NumberUtil.round(number, scale2, RoundingMode.HALF_UP);
    }

    public static String roundStr(String numberStr, int scale2) {
        return NumberUtil.round(numberStr, scale2).toPlainString();
    }

    public static BigDecimal round(double v, int scale2, RoundingMode roundingMode) {
        return NumberUtil.round(Double.toString(v), scale2, roundingMode);
    }

    public static String roundStr(double v, int scale2, RoundingMode roundingMode) {
        return NumberUtil.round(v, scale2, roundingMode).toPlainString();
    }

    public static BigDecimal round(String numberStr, int scale2, RoundingMode roundingMode) {
        Assert.notBlank(numberStr);
        if (scale2 < 0) {
            scale2 = 0;
        }
        return NumberUtil.round(NumberUtil.toBigDecimal(numberStr), scale2, roundingMode);
    }

    public static BigDecimal round(BigDecimal number, int scale2, RoundingMode roundingMode) {
        if (null == number) {
            number = BigDecimal.ZERO;
        }
        if (scale2 < 0) {
            scale2 = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return number.setScale(scale2, roundingMode);
    }

    public static String roundStr(String numberStr, int scale2, RoundingMode roundingMode) {
        return NumberUtil.round(numberStr, scale2, roundingMode).toPlainString();
    }

    public static BigDecimal roundHalfEven(Number number, int scale2) {
        return NumberUtil.roundHalfEven(NumberUtil.toBigDecimal(number), scale2);
    }

    public static BigDecimal roundHalfEven(BigDecimal value, int scale2) {
        return NumberUtil.round(value, scale2, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int scale2) {
        return NumberUtil.roundDown(NumberUtil.toBigDecimal(number), scale2);
    }

    public static BigDecimal roundDown(BigDecimal value, int scale2) {
        return NumberUtil.round(value, scale2, RoundingMode.DOWN);
    }

    public static String decimalFormat(String pattern, double value) {
        Assert.isTrue(NumberUtil.isValid(value), "value is NaN or Infinite!", new Object[0]);
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, long value) {
        return new DecimalFormat(pattern).format(value);
    }

    public static String decimalFormat(String pattern, Object value) {
        return NumberUtil.decimalFormat(pattern, value, null);
    }

    public static String decimalFormat(String pattern, Object value, RoundingMode roundingMode) {
        if (value instanceof Number) {
            Assert.isTrue(NumberUtil.isValidNumber((Number)value), "value is NaN or Infinite!", new Object[0]);
        }
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        if (null != roundingMode) {
            decimalFormat.setRoundingMode(roundingMode);
        }
        return decimalFormat.format(value);
    }

    public static String decimalFormatMoney(double value) {
        return NumberUtil.decimalFormat(",##0.00", value);
    }

    public static String formatPercent(double number, int scale2) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setMaximumFractionDigits(scale2);
        return format.format(number);
    }

    public static boolean isNumber(CharSequence str) {
        int i2;
        int start2;
        if (StrUtil.isBlank(str)) {
            return false;
        }
        char[] chars = str.toString().toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start2 = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start2 + 1 && chars[start2] == '0' && (chars[start2 + 1] == 'x' || chars[start2 + 1] == 'X')) {
            int i3 = start2 + 2;
            if (i3 == sz) {
                return false;
            }
            while (i3 < chars.length) {
                if (!(chars[i3] >= '0' && chars[i3] <= '9' || chars[i3] >= 'a' && chars[i3] <= 'f' || chars[i3] >= 'A' && chars[i3] <= 'F')) {
                    return false;
                }
                ++i3;
            }
            return true;
        }
        --sz;
        for (i2 = start2; i2 < sz || i2 < sz + 1 && allowSigns && !foundDigit; ++i2) {
            if (chars[i2] >= '0' && chars[i2] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i2] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i2] == 'e' || chars[i2] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i2] == '+' || chars[i2] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i2 < chars.length) {
            if (chars[i2] >= '0' && chars[i2] <= '9') {
                return true;
            }
            if (chars[i2] == 'e' || chars[i2] == 'E') {
                return false;
            }
            if (chars[i2] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i2] != 'd' && chars[i2] != 'D' && chars[i2] != 'f' && chars[i2] != 'F')) {
                return foundDigit;
            }
            if (chars[i2] == 'l' || chars[i2] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return false == allowSigns && foundDigit;
    }

    public static boolean isInteger(String s) {
        if (StrUtil.isBlank(s)) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String s) {
        if (StrUtil.isBlank(s)) {
            return false;
        }
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String s) {
        if (StrUtil.isBlank(s)) {
            return false;
        }
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException ignore) {
            return false;
        }
        return s.contains(".");
    }

    public static boolean isPrimes(int n) {
        Assert.isTrue(n > 1, "The number must be > 1", new Object[0]);
        int i2 = 2;
        while ((double)i2 <= Math.sqrt(n)) {
            if (n % i2 == 0) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static int[] generateRandomNumber(int begin, int end, int size) {
        int[] seed = ArrayUtil.range(begin, end);
        return NumberUtil.generateRandomNumber(begin, end, size, seed);
    }

    public static int[] generateRandomNumber(int begin, int end, int size, int[] seed) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        Assert.isTrue(end - begin >= size, "Size is larger than range between begin and end!", new Object[0]);
        Assert.isTrue(seed.length >= size, "Size is larger than seed size!", new Object[0]);
        int[] ranArr = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            int j = RandomUtil.randomInt(seed.length - i2);
            ranArr[i2] = seed[j];
            seed[j] = seed[seed.length - 1 - i2];
        }
        return ranArr;
    }

    public static Integer[] generateBySet(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new UtilException("Size is larger than range between begin and end!");
        }
        HashSet<Integer> set2 = new HashSet<Integer>(size, 1.0f);
        while (set2.size() < size) {
            set2.add(begin + RandomUtil.randomInt(end - begin));
        }
        return set2.toArray(new Integer[0]);
    }

    public static int[] range(int stop2) {
        return NumberUtil.range(0, stop2);
    }

    public static int[] range(int start2, int stop2) {
        return NumberUtil.range(start2, stop2, 1);
    }

    public static int[] range(int start2, int stop2, int step) {
        if (start2 < stop2) {
            step = Math.abs(step);
        } else if (start2 > stop2) {
            step = -Math.abs(step);
        } else {
            return new int[]{start2};
        }
        int size = Math.abs((stop2 - start2) / step) + 1;
        int[] values2 = new int[size];
        int index = 0;
        int i2 = start2;
        while (step > 0 ? i2 <= stop2 : i2 >= stop2) {
            values2[index] = i2;
            ++index;
            i2 += step;
        }
        return values2;
    }

    public static Collection<Integer> appendRange(int start2, int stop2, Collection<Integer> values2) {
        return NumberUtil.appendRange(start2, stop2, 1, values2);
    }

    public static Collection<Integer> appendRange(int start2, int stop2, int step, Collection<Integer> values2) {
        if (start2 < stop2) {
            step = Math.abs(step);
        } else if (start2 > stop2) {
            step = -Math.abs(step);
        } else {
            values2.add(start2);
            return values2;
        }
        int i2 = start2;
        while (step > 0 ? i2 <= stop2 : i2 >= stop2) {
            values2.add(i2);
            i2 += step;
        }
        return values2;
    }

    public static BigInteger factorial(BigInteger n) {
        if (n.equals(BigInteger.ZERO)) {
            return BigInteger.ONE;
        }
        return NumberUtil.factorial(n, BigInteger.ZERO);
    }

    public static BigInteger factorial(BigInteger start2, BigInteger end) {
        Assert.notNull(start2, "Factorial start must be not null!", new Object[0]);
        Assert.notNull(end, "Factorial end must be not null!", new Object[0]);
        if (start2.compareTo(BigInteger.ZERO) < 0 || end.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException(StrUtil.format("Factorial start and end both must be > 0, but got start={}, end={}", start2, end));
        }
        if (start2.equals(BigInteger.ZERO)) {
            start2 = BigInteger.ONE;
        }
        if (end.compareTo(BigInteger.ONE) < 0) {
            end = BigInteger.ONE;
        }
        BigInteger result2 = start2;
        end = end.add(BigInteger.ONE);
        while (start2.compareTo(end) > 0) {
            start2 = start2.subtract(BigInteger.ONE);
            result2 = result2.multiply(start2);
        }
        return result2;
    }

    public static long factorial(long start2, long end) {
        if (start2 < 0L || end < 0L) {
            throw new IllegalArgumentException(StrUtil.format("Factorial start and end both must be >= 0, but got start={}, end={}", start2, end));
        }
        if (0L == start2 || start2 == end) {
            return 1L;
        }
        if (start2 < end) {
            return 0L;
        }
        return NumberUtil.factorialMultiplyAndCheck(start2, NumberUtil.factorial(start2 - 1L, end));
    }

    private static long factorialMultiplyAndCheck(long a, long b) {
        if (a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        throw new IllegalArgumentException(StrUtil.format("Overflow in multiplication: {} * {}", a, b));
    }

    public static long factorial(long n) {
        if (n < 0L || n > 20L) {
            throw new IllegalArgumentException(StrUtil.format("Factorial must have n >= 0 and n <= 20 for n!, but got n = {}", n));
        }
        return FACTORIALS[(int)n];
    }

    public static long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public static int processMultiple(int selectNum, int minNum) {
        int result2 = NumberUtil.mathSubNode(selectNum, minNum) / NumberUtil.mathNode(selectNum - minNum);
        return result2;
    }

    public static int divisor(int m, int n) {
        while (m % n != 0) {
            int temp = m % n;
            m = n;
            n = temp;
        }
        return n;
    }

    public static int multiple(int m, int n) {
        return m * n / NumberUtil.divisor(m, n);
    }

    public static String getBinaryStr(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public static int binaryToInt(String binaryStr) {
        return Integer.parseInt(binaryStr, 2);
    }

    public static long binaryToLong(String binaryStr) {
        return Long.parseLong(binaryStr, 2);
    }

    public static int compare(char x, char y) {
        return Character.compare(x, y);
    }

    public static int compare(double x, double y) {
        return Double.compare(x, y);
    }

    public static int compare(int x, int y) {
        return Integer.compare(x, y);
    }

    public static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    public static int compare(short x, short y) {
        return Short.compare(x, y);
    }

    public static int compare(byte x, byte y) {
        return Byte.compare(x, y);
    }

    public static boolean isGreater(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigNum1.compareTo(bigNum2) > 0;
    }

    public static boolean isGreaterOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigNum1.compareTo(bigNum2) >= 0;
    }

    public static boolean isLess(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigNum1.compareTo(bigNum2) < 0;
    }

    public static boolean isLessOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        Assert.notNull(bigNum1);
        Assert.notNull(bigNum2);
        return bigNum1.compareTo(bigNum2) <= 0;
    }

    public static boolean isIn(BigDecimal value, BigDecimal minInclude, BigDecimal maxInclude) {
        Assert.notNull(value);
        Assert.notNull(minInclude);
        Assert.notNull(maxInclude);
        return NumberUtil.isGreaterOrEqual(value, minInclude) && NumberUtil.isLessOrEqual(value, maxInclude);
    }

    public static boolean equals(double num1, double num2) {
        return Double.doubleToLongBits(num1) == Double.doubleToLongBits(num2);
    }

    public static boolean equals(float num1, float num2) {
        return Float.floatToIntBits(num1) == Float.floatToIntBits(num2);
    }

    public static boolean equals(long num1, long num2) {
        return num1 == num2;
    }

    public static boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 == bigNum2) {
            return true;
        }
        if (bigNum1 == null || bigNum2 == null) {
            return false;
        }
        return 0 == bigNum1.compareTo(bigNum2);
    }

    public static boolean equals(char c1, char c2, boolean ignoreCase) {
        return CharUtil.equals(c1, c2, ignoreCase);
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        return (T)ArrayUtil.min(numberArray);
    }

    public static long min(long ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static int min(int ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static short min(short ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static double min(double ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static float min(float ... numberArray) {
        return ArrayUtil.min(numberArray);
    }

    public static BigDecimal min(BigDecimal ... numberArray) {
        return (BigDecimal)ArrayUtil.min((Comparable[])numberArray);
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        return (T)ArrayUtil.max(numberArray);
    }

    public static long max(long ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static int max(int ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static short max(short ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static double max(double ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static float max(float ... numberArray) {
        return ArrayUtil.max(numberArray);
    }

    public static BigDecimal max(BigDecimal ... numberArray) {
        return (BigDecimal)ArrayUtil.max((Comparable[])numberArray);
    }

    public static String toStr(Number number, String defaultValue) {
        return null == number ? defaultValue : NumberUtil.toStr(number);
    }

    public static String toStr(Number number) {
        return NumberUtil.toStr(number, true);
    }

    public static String toStr(Number number, boolean isStripTrailingZeros) {
        Assert.notNull(number, "Number is null !", new Object[0]);
        if (number instanceof BigDecimal) {
            return NumberUtil.toStr((BigDecimal)number, isStripTrailingZeros);
        }
        Assert.isTrue(NumberUtil.isValidNumber(number), "Number is non-finite!", new Object[0]);
        String string2 = number.toString();
        if (isStripTrailingZeros && string2.indexOf(46) > 0 && string2.indexOf(101) < 0 && string2.indexOf(69) < 0) {
            while (string2.endsWith("0")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    public static String toStr(BigDecimal bigDecimal) {
        return NumberUtil.toStr(bigDecimal, true);
    }

    public static String toStr(BigDecimal bigDecimal, boolean isStripTrailingZeros) {
        Assert.notNull(bigDecimal, "BigDecimal is null !", new Object[0]);
        if (isStripTrailingZeros) {
            bigDecimal = bigDecimal.stripTrailingZeros();
        }
        return bigDecimal.toPlainString();
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return NumberUtil.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String numberStr) {
        if (StrUtil.isBlank(numberStr)) {
            return BigDecimal.ZERO;
        }
        try {
            Number number = NumberUtil.parseNumber(numberStr);
            if (number instanceof BigDecimal) {
                return (BigDecimal)number;
            }
            return new BigDecimal(number.toString());
        }
        catch (Exception exception) {
            return new BigDecimal(numberStr);
        }
    }

    public static BigInteger toBigInteger(Number number) {
        if (null == number) {
            return BigInteger.ZERO;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf((Long)number);
        }
        return NumberUtil.toBigInteger(number.longValue());
    }

    public static BigInteger toBigInteger(String number) {
        return StrUtil.isBlank(number) ? BigInteger.ZERO : new BigInteger(number);
    }

    public static int count(int total, int part) {
        return total % part == 0 ? total / part : total / part + 1;
    }

    public static BigDecimal null2Zero(BigDecimal decimal) {
        return decimal == null ? BigDecimal.ZERO : decimal;
    }

    public static int zero2One(int value) {
        return 0 == value ? 1 : value;
    }

    public static BigInteger newBigInteger(String str) {
        if (null == (str = StrUtil.trimToNull(str))) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        if (pos > 0) {
            str = str.substring(pos);
        }
        BigInteger value = new BigInteger(str, radix);
        return negate ? value.negate() : value;
    }

    public static boolean isBeside(long number1, long number2) {
        return Math.abs(number1 - number2) == 1L;
    }

    public static boolean isBeside(int number1, int number2) {
        return Math.abs(number1 - number2) == 1;
    }

    public static int partValue(int total, int partCount) {
        return NumberUtil.partValue(total, partCount, true);
    }

    public static int partValue(int total, int partCount, boolean isPlusOneWhenHasRem) {
        int partValue = total / partCount;
        if (isPlusOneWhenHasRem && total % partCount > 0) {
            ++partValue;
        }
        return partValue;
    }

    public static BigDecimal pow(Number number, int n) {
        return NumberUtil.pow(NumberUtil.toBigDecimal(number), n);
    }

    public static BigDecimal pow(BigDecimal number, int n) {
        return number.pow(n);
    }

    public static boolean isPowerOfTwo(long n) {
        return n > 0L && (n & n - 1L) == 0L;
    }

    public static int parseInt(String number) throws NumberFormatException {
        if (StrUtil.isBlank(number)) {
            return 0;
        }
        if (StrUtil.containsIgnoreCase(number, "E")) {
            throw new NumberFormatException(StrUtil.format("Unsupported int format: [{}]", number));
        }
        if (StrUtil.startWithIgnoreCase(number, "0x")) {
            return Integer.parseInt(number.substring(2), 16);
        }
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return NumberUtil.parseNumber(number).intValue();
        }
    }

    public static long parseLong(String number) {
        if (StrUtil.isBlank(number)) {
            return 0L;
        }
        if (number.startsWith("0x")) {
            return Long.parseLong(number.substring(2), 16);
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return NumberUtil.parseNumber(number).longValue();
        }
    }

    public static float parseFloat(String number) {
        if (StrUtil.isBlank(number)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(number);
        }
        catch (NumberFormatException e) {
            return NumberUtil.parseNumber(number).floatValue();
        }
    }

    public static double parseDouble(String number) {
        if (StrUtil.isBlank(number)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(number);
        }
        catch (NumberFormatException e) {
            return NumberUtil.parseNumber(number).doubleValue();
        }
    }

    public static Number parseNumber(String numberStr) throws NumberFormatException {
        if (StrUtil.startWithIgnoreCase(numberStr, "0x")) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        try {
            NumberFormat format = NumberFormat.getInstance();
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }

    public static Integer parseInt(String numberStr, Integer defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return NumberUtil.parseInt(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Long parseLong(String numberStr, Long defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return NumberUtil.parseLong(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Float parseFloat(String numberStr, Float defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(NumberUtil.parseFloat(numberStr));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Double parseDouble(String numberStr, Double defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return NumberUtil.parseDouble(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static Number parseNumber(String numberStr, Number defaultValue) {
        if (CharSequenceUtil.isBlank(numberStr)) {
            return defaultValue;
        }
        try {
            return NumberUtil.parseNumber(numberStr);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static byte[] toBytes(int value) {
        byte[] result2 = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return result2;
    }

    public static int toInt(byte[] bytes) {
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static byte[] toUnsignedByteArray(BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes[0] == 0) {
            byte[] tmp = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, tmp, 0, tmp.length);
            return tmp;
        }
        return bytes;
    }

    public static byte[] toUnsignedByteArray(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            return bytes;
        }
        int start2 = bytes[0] == 0 ? 1 : 0;
        int count = bytes.length - start2;
        if (count > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] tmp = new byte[length];
        System.arraycopy(bytes, start2, tmp, tmp.length - count, count);
        return tmp;
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        return new BigInteger(1, buf);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        byte[] mag = buf;
        if (off != 0 || length != buf.length) {
            mag = new byte[length];
            System.arraycopy(buf, off, mag, 0, length);
        }
        return new BigInteger(1, mag);
    }

    public static boolean isValidNumber(Number number) {
        if (null == number) {
            return false;
        }
        if (number instanceof Double) {
            return false == ((Double)number).isInfinite() && false == ((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return false == ((Float)number).isInfinite() && false == ((Float)number).isNaN();
        }
        return true;
    }

    public static boolean isValid(double number) {
        return false == (Double.isNaN(number) || Double.isInfinite(number));
    }

    public static boolean isValid(float number) {
        return false == (Float.isNaN(number) || Float.isInfinite(number));
    }

    public static double calculate(String expression) {
        return Calculator.conversion(expression);
    }

    public static double toDouble(Number value) {
        if (value instanceof Float) {
            return Double.parseDouble(value.toString());
        }
        return value.doubleValue();
    }

    public static boolean isOdd(int num) {
        return (num & 1) == 1;
    }

    public static boolean isEven(int num) {
        return false == NumberUtil.isOdd(num);
    }

    private static int mathSubNode(int selectNum, int minNum) {
        if (selectNum == minNum) {
            return 1;
        }
        return selectNum * NumberUtil.mathSubNode(selectNum - 1, minNum);
    }

    private static int mathNode(int selectNum) {
        if (selectNum == 0) {
            return 1;
        }
        return selectNum * NumberUtil.mathNode(selectNum - 1);
    }
}

