/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.annotation.Alias;
import cn.hutool.core.bean.NullWrapperBean;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.UniqueKeySet;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.exceptions.InvocationTargetRuntimeException;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Filter;
import cn.hutool.core.lang.reflect.MethodHandleUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.map.WeakConcurrentMap;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectUtil {
    private static final WeakConcurrentMap<Class<?>, Constructor<?>[]> CONSTRUCTORS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Field[]> FIELDS_CACHE = new WeakConcurrentMap();
    private static final WeakConcurrentMap<Class<?>, Method[]> METHODS_CACHE = new WeakConcurrentMap();

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T>[] constructors2;
        if (null == clazz) {
            return null;
        }
        for (Constructor<T> constructor : constructors2 = ReflectUtil.getConstructors(clazz)) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassUtil.isAllAssignableFrom(pts, parameterTypes)) continue;
            ReflectUtil.setAccessible(constructor);
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T>[] getConstructors(Class<T> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return CONSTRUCTORS_CACHE.computeIfAbsent(beanClass, () -> ReflectUtil.getConstructorsDirectly(beanClass));
    }

    public static Constructor<?>[] getConstructorsDirectly(Class<?> beanClass) throws SecurityException {
        return beanClass.getDeclaredConstructors();
    }

    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        return null != ReflectUtil.getField(beanClass, name);
    }

    public static String getFieldName(Field field2) {
        if (null == field2) {
            return null;
        }
        Alias alias = field2.getAnnotation(Alias.class);
        if (null != alias) {
            return alias.value();
        }
        return field2.getName();
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields2 = ReflectUtil.getFields(beanClass);
        return ArrayUtil.firstMatch(field2 -> name.equals(ReflectUtil.getFieldName(field2)), fields2);
    }

    public static Map<String, Field> getFieldMap(Class<?> beanClass) {
        Field[] fields2 = ReflectUtil.getFields(beanClass);
        HashMap<String, Field> map2 = MapUtil.newHashMap(fields2.length, true);
        for (Field field2 : fields2) {
            map2.put(field2.getName(), field2);
        }
        return map2;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, () -> ReflectUtil.getFieldsDirectly(beanClass, true));
    }

    public static Field[] getFields(Class<?> beanClass, Filter<Field> fieldFilter) throws SecurityException {
        return ArrayUtil.filter(ReflectUtil.getFields(beanClass), fieldFilter);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        Assert.notNull(beanClass);
        Field[] allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            allFields = null == allFields ? declaredFields : ArrayUtil.append(allFields, declaredFields);
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static Object getFieldValue(Object obj, String fieldName) throws UtilException {
        if (null == obj || StrUtil.isBlank(fieldName)) {
            return null;
        }
        return ReflectUtil.getFieldValue(obj, ReflectUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName));
    }

    public static Object getStaticFieldValue(Field field2) throws UtilException {
        return ReflectUtil.getFieldValue(null, field2);
    }

    public static Object getFieldValue(Object obj, Field field2) throws UtilException {
        Object result2;
        if (null == field2) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectUtil.setAccessible(field2);
        try {
            result2 = field2.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e, "IllegalAccess for {}.{}", field2.getDeclaringClass(), field2.getName());
        }
        return result2;
    }

    public static Object[] getFieldsValue(Object obj) {
        Field[] fields2;
        if (null != obj && null != (fields2 = ReflectUtil.getFields(obj instanceof Class ? (Class<?>)obj : obj.getClass()))) {
            Object[] values2 = new Object[fields2.length];
            for (int i2 = 0; i2 < fields2.length; ++i2) {
                values2[i2] = ReflectUtil.getFieldValue(obj, fields2[i2]);
            }
            return values2;
        }
        return null;
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) throws UtilException {
        Assert.notNull(obj);
        Assert.notBlank(fieldName);
        Field field2 = ReflectUtil.getField(obj instanceof Class ? (Class<?>)obj : obj.getClass(), fieldName);
        Assert.notNull(field2, "Field [{}] is not exist in [{}]", fieldName, obj.getClass().getName());
        ReflectUtil.setFieldValue(obj, field2, value);
    }

    public static void setFieldValue(Object obj, Field field2, Object value) throws UtilException {
        Assert.notNull(field2, "Field in [{}] not exist !", obj);
        Class<?> fieldType = field2.getType();
        if (null != value) {
            Object targetValue;
            if (!fieldType.isAssignableFrom(value.getClass()) && null != (targetValue = Convert.convert(fieldType, value))) {
                value = targetValue;
            }
        } else {
            value = ClassUtil.getDefaultValue(fieldType);
        }
        ReflectUtil.setAccessible(field2);
        try {
            field2.set(obj instanceof Class ? null : obj, value);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e, "IllegalAccess for {}.{}", obj, field2.getName());
        }
    }

    public static boolean isOuterClassField(Field field2) {
        return "this$0".equals(field2.getName());
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        HashSet<String> methodSet = new HashSet<String>();
        Method[] methodArray = ReflectUtil.getPublicMethods(clazz);
        if (ArrayUtil.isNotEmpty(methodArray)) {
            for (Method method : methodArray) {
                methodSet.add(method.getName());
            }
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return null == clazz ? null : clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter2) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods2 = ReflectUtil.getPublicMethods(clazz);
        if (null != filter2) {
            methodList = new ArrayList();
            for (Method method : methods2) {
                if (!filter2.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollUtil.newArrayList(methods2);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        HashSet<Method> excludeMethodSet = CollUtil.newHashSet(excludeMethods);
        return ReflectUtil.getPublicMethods(clazz, (Method method) -> false == excludeMethodSet.contains(method));
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        HashSet<String> excludeMethodNameSet = CollUtil.newHashSet(excludeMethodNames);
        return ReflectUtil.getPublicMethods(clazz, (Method method) -> false == excludeMethodNameSet.contains(method.getName()));
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getMethodOfObj(Object obj, String methodName, Object ... args) throws SecurityException {
        if (null == obj || StrUtil.isBlank(methodName)) {
            return null;
        }
        return ReflectUtil.getMethod(obj.getClass(), methodName, ClassUtil.getClasses(args));
    }

    public static Method getMethodIgnoreCase(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, true, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        return ReflectUtil.getMethod(clazz, false, methodName, paramTypes);
    }

    public static Method getMethod(Class<?> clazz, boolean ignoreCase, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        Method[] methods2 = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods2)) {
            for (Method method : methods2) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || !ClassUtil.isAllAssignableFrom(method.getParameterTypes(), paramTypes) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, false, methodName);
    }

    public static Method getMethodByNameIgnoreCase(Class<?> clazz, String methodName) throws SecurityException {
        return ReflectUtil.getMethodByName(clazz, true, methodName);
    }

    public static Method getMethodByName(Class<?> clazz, boolean ignoreCase, String methodName) throws SecurityException {
        if (null == clazz || StrUtil.isBlank(methodName)) {
            return null;
        }
        Method res = null;
        Method[] methods2 = ReflectUtil.getMethods(clazz);
        if (ArrayUtil.isNotEmpty(methods2)) {
            for (Method method : methods2) {
                if (!StrUtil.equals(methodName, method.getName(), ignoreCase) || res != null && !res.getReturnType().isAssignableFrom(method.getReturnType())) continue;
                res = method;
            }
        }
        return res;
    }

    public static Set<String> getMethodNames(Class<?> clazz) throws SecurityException {
        Method[] methods2;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methods2 = ReflectUtil.getMethods(clazz)) {
            methodSet.add(method.getName());
        }
        return methodSet;
    }

    public static Method[] getMethods(Class<?> clazz, Filter<Method> filter2) throws SecurityException {
        if (null == clazz) {
            return null;
        }
        return ArrayUtil.filter(ReflectUtil.getMethods(clazz), filter2);
    }

    public static Method[] getMethods(Class<?> beanClass) throws SecurityException {
        Assert.notNull(beanClass);
        return METHODS_CACHE.computeIfAbsent(beanClass, () -> ReflectUtil.getMethodsDirectly(beanClass, true, true));
    }

    public static Method[] getMethodsDirectly(Class<?> beanClass, boolean withSupers, boolean withMethodFromObject) throws SecurityException {
        Assert.notNull(beanClass);
        if (beanClass.isInterface()) {
            return withSupers ? beanClass.getMethods() : beanClass.getDeclaredMethods();
        }
        UniqueKeySet<String, Method> result2 = new UniqueKeySet<String, Method>(true, ReflectUtil::getUniqueKey);
        Class<?> searchType = beanClass;
        while (searchType != null && (withMethodFromObject || Object.class != searchType)) {
            result2.addAllIfAbsent(Arrays.asList(searchType.getDeclaredMethods()));
            result2.addAllIfAbsent(ReflectUtil.getDefaultMethodsFromInterface(searchType));
            searchType = withSupers && false == searchType.isInterface() ? searchType.getSuperclass() : null;
        }
        return result2.toArray(new Method[0]);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || 1 != method.getParameterCount() || !"equals".equals(method.getName())) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && ReflectUtil.isEmptyParam(method);
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && ReflectUtil.isEmptyParam(method);
    }

    public static boolean isEmptyParam(Method method) {
        return method.getParameterCount() == 0;
    }

    public static boolean isGetterOrSetterIgnoreCase(Method method) {
        return ReflectUtil.isGetterOrSetter(method, true);
    }

    public static boolean isGetterOrSetter(Method method, boolean ignoreCase) {
        if (null == method) {
            return false;
        }
        int parameterCount = method.getParameterCount();
        if (parameterCount > 1) {
            return false;
        }
        String name = method.getName();
        if ("getClass".equals(name)) {
            return false;
        }
        if (ignoreCase) {
            name = name.toLowerCase();
        }
        switch (parameterCount) {
            case 0: {
                return name.startsWith("get") || name.startsWith("is");
            }
            case 1: {
                return name.startsWith("set");
            }
        }
        return false;
    }

    public static <T> T newInstance(String clazz) throws UtilException {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new UtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) throws UtilException {
        if (ArrayUtil.isEmpty(params)) {
            Constructor<T> constructor = ReflectUtil.getConstructor(clazz, new Class[0]);
            if (null == constructor) {
                throw new UtilException("No constructor for [{}]", clazz);
            }
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new UtilException(e, "Instance class [{}] error!", clazz);
            }
        }
        Class<?>[] paramTypes = ClassUtil.getClasses(params);
        Constructor<T> constructor = ReflectUtil.getConstructor(clazz, paramTypes);
        if (null == constructor) {
            throw new UtilException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return constructor.newInstance(params);
        }
        catch (Exception e) {
            throw new UtilException(e, "Instance class [{}] error!", clazz);
        }
    }

    public static <T> T newInstanceIfPossible(Class<T> type2) {
        Assert.notNull(type2);
        if (type2.isPrimitive()) {
            return (T)ClassUtil.getPrimitiveDefaultValue(type2);
        }
        if (type2.isAssignableFrom(AbstractMap.class)) {
            type2 = HashMap.class;
        } else if (type2.isAssignableFrom(List.class)) {
            type2 = ArrayList.class;
        } else if (type2.isAssignableFrom(Set.class)) {
            type2 = HashSet.class;
        }
        try {
            return (T)ReflectUtil.newInstance(type2, new Object[0]);
        }
        catch (Exception exception) {
            Constructor<Object>[] constructors2;
            if (type2.isEnum()) {
                return (T)type2.getEnumConstants()[0];
            }
            if (type2.isArray()) {
                return (T)Array.newInstance(type2.getComponentType(), 0);
            }
            for (Constructor<Object> constructor : constructors2 = ReflectUtil.getConstructors(type2)) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (0 == parameterTypes.length) continue;
                ReflectUtil.setAccessible(constructor);
                try {
                    return (T)constructor.newInstance(ClassUtil.getDefaultValues(parameterTypes));
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) throws UtilException {
        return ReflectUtil.invoke(null, method, args);
    }

    public static <T> T invokeWithCheck(Object obj, Method method, Object ... args) throws UtilException {
        Class<?>[] types = method.getParameterTypes();
        if (null != args) {
            Assert.isTrue(args.length == types.length, "Params length [{}] is not fit for param length [{}] of method !", args.length, types.length);
            for (int i2 = 0; i2 < args.length; ++i2) {
                Class<?> type2 = types[i2];
                if (!type2.isPrimitive() || null != args[i2]) continue;
                args[i2] = ClassUtil.getDefaultValue(type2);
            }
        }
        return ReflectUtil.invoke(obj, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object ... args) throws InvocationTargetRuntimeException, UtilException {
        try {
            return ReflectUtil.invokeRaw(obj, method, args);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invokeRaw(Object obj, Method method, Object ... args) throws InvocationTargetException, IllegalAccessException {
        ReflectUtil.setAccessible(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] actualArgs = new Object[parameterTypes.length];
        if (null != args) {
            for (int i2 = 0; i2 < actualArgs.length; ++i2) {
                if (i2 >= args.length || null == args[i2]) {
                    actualArgs[i2] = ClassUtil.getDefaultValue(parameterTypes[i2]);
                    continue;
                }
                if (args[i2] instanceof NullWrapperBean) {
                    actualArgs[i2] = null;
                    continue;
                }
                if (!parameterTypes[i2].isAssignableFrom(args[i2].getClass())) {
                    Object targetValue = Convert.convertWithCheck(parameterTypes[i2], args[i2], null, true);
                    if (null != targetValue) {
                        actualArgs[i2] = targetValue;
                        continue;
                    }
                    actualArgs[i2] = args[i2];
                    continue;
                }
                actualArgs[i2] = args[i2];
            }
        }
        if (method.isDefault()) {
            return MethodHandleUtil.invokeSpecial(obj, method, args);
        }
        return (T)method.invoke(ClassUtil.isStatic(method) ? null : obj, actualArgs);
    }

    public static <T> T invoke(Object obj, String methodName, Object ... args) throws UtilException {
        Assert.notNull(obj, "Object to get method must be not null!", new Object[0]);
        Assert.notBlank(methodName, "Method name must be not blank!", new Object[0]);
        Method method = ReflectUtil.getMethodOfObj(obj, methodName, args);
        if (null == method) {
            throw new UtilException("No such method: [{}] from [{}]", methodName, obj.getClass());
        }
        return ReflectUtil.invoke(obj, method, args);
    }

    public static <T extends AccessibleObject> T setAccessible(T accessibleObject) {
        if (null != accessibleObject && !accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
        return accessibleObject;
    }

    public static void removeFinalModify(Field field2) {
        ModifierUtil.removeFinalModify(field2);
    }

    private static String getUniqueKey(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getReturnType().getName()).append('#');
        sb.append(method.getName());
        Class<?>[] parameters2 = method.getParameterTypes();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            if (i2 == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters2[i2].getName());
        }
        return sb.toString();
    }

    private static List<Method> getDefaultMethodsFromInterface(Class<?> clazz) {
        ArrayList<Method> result2 = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method m : ifc.getMethods()) {
                if (ModifierUtil.isAbstract(m)) continue;
                result2.add(m);
            }
        }
        return result2;
    }
}

