/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ClassLoaderUtil;
import cn.hutool.core.util.ObjectUtil;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class ServiceLoaderUtil {
    public static <T> T loadFirstAvailable(Class<T> clazz) {
        Iterator<T> iterator2 = ServiceLoaderUtil.load(clazz).iterator();
        while (iterator2.hasNext()) {
            try {
                return iterator2.next();
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
        return null;
    }

    public static <T> T loadFirst(Class<T> clazz) {
        Iterator<T> iterator2 = ServiceLoaderUtil.load(clazz).iterator();
        if (iterator2.hasNext()) {
            return iterator2.next();
        }
        return null;
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz) {
        return ServiceLoaderUtil.load(clazz, null);
    }

    public static <T> ServiceLoader<T> load(Class<T> clazz, ClassLoader loader2) {
        return ServiceLoader.load(clazz, ObjectUtil.defaultIfNull(loader2, ClassLoaderUtil::getClassLoader));
    }

    public static <T> List<T> loadList(Class<T> clazz) {
        return ServiceLoaderUtil.loadList(clazz, null);
    }

    public static <T> List<T> loadList(Class<T> clazz, ClassLoader loader2) {
        return ListUtil.list(false, ServiceLoaderUtil.load(clazz, loader2));
    }
}

