/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.common;

import java.awt.color.ColorSpace;

public class BogusColorSpace
extends ColorSpace {
    private static int getType(int numComponents) {
        int type2;
        if (numComponents < 1) {
            throw new IllegalArgumentException("numComponents < 1!");
        }
        switch (numComponents) {
            case 1: {
                type2 = 6;
                break;
            }
            default: {
                type2 = numComponents + 10;
            }
        }
        return type2;
    }

    public BogusColorSpace(int numComponents) {
        super(BogusColorSpace.getType(numComponents), numComponents);
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        if (colorvalue.length < this.getNumComponents()) {
            throw new ArrayIndexOutOfBoundsException("colorvalue.length < getNumComponents()");
        }
        float[] rgbvalue = new float[3];
        System.arraycopy(colorvalue, 0, rgbvalue, 0, Math.min(3, this.getNumComponents()));
        return colorvalue;
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        if (rgbvalue.length < 3) {
            throw new ArrayIndexOutOfBoundsException("rgbvalue.length < 3");
        }
        float[] colorvalue = new float[this.getNumComponents()];
        System.arraycopy(rgbvalue, 0, colorvalue, 0, Math.min(3, colorvalue.length));
        return rgbvalue;
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        if (colorvalue.length < this.getNumComponents()) {
            throw new ArrayIndexOutOfBoundsException("colorvalue.length < getNumComponents()");
        }
        float[] xyzvalue = new float[3];
        System.arraycopy(colorvalue, 0, xyzvalue, 0, Math.min(3, this.getNumComponents()));
        return colorvalue;
    }

    @Override
    public float[] fromCIEXYZ(float[] xyzvalue) {
        if (xyzvalue.length < 3) {
            throw new ArrayIndexOutOfBoundsException("xyzvalue.length < 3");
        }
        float[] colorvalue = new float[this.getNumComponents()];
        System.arraycopy(xyzvalue, 0, colorvalue, 0, Math.min(3, colorvalue.length));
        return xyzvalue;
    }
}

