/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.plugins.gif;

import com.github.jaiimageio.impl.plugins.gif.GIFMetadata;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class GIFImageMetadata
extends GIFMetadata {
    static final String nativeMetadataFormatName = "javax_imageio_gif_image_1.0";
    static final String[] disposalMethodNames = new String[]{"none", "doNotDispose", "restoreToBackgroundColor", "restoreToPrevious", "undefinedDisposalMethod4", "undefinedDisposalMethod5", "undefinedDisposalMethod6", "undefinedDisposalMethod7"};
    public int imageLeftPosition;
    public int imageTopPosition;
    public int imageWidth;
    public int imageHeight;
    public boolean interlaceFlag = false;
    public boolean sortFlag = false;
    public byte[] localColorTable = null;
    public int disposalMethod = 0;
    public boolean userInputFlag = false;
    public boolean transparentColorFlag = false;
    public int delayTime = 0;
    public int transparentColorIndex = 0;
    public boolean hasPlainTextExtension = false;
    public int textGridLeft;
    public int textGridTop;
    public int textGridWidth;
    public int textGridHeight;
    public int characterCellWidth;
    public int characterCellHeight;
    public int textForegroundColor;
    public int textBackgroundColor;
    public byte[] text;
    public List applicationIDs = null;
    public List authenticationCodes = null;
    public List applicationData = null;
    public List comments = null;

    protected GIFImageMetadata(boolean standardMetadataFormatSupported, String nativeMetadataFormatName, String nativeMetadataFormatClassName, String[] extraMetadataFormatNames, String[] extraMetadataFormatClassNames) {
        super(standardMetadataFormatSupported, nativeMetadataFormatName, nativeMetadataFormatClassName, extraMetadataFormatNames, extraMetadataFormatClassNames);
    }

    public GIFImageMetadata() {
        this(true, nativeMetadataFormatName, "com.github.jaiimageio.impl.plugins.gif.GIFImageMetadataFormat", null, null);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private String toISO8859(byte[] data2) {
        try {
            return new String(data2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private Node getNativeTree() {
        int numComments;
        int numAppExtensions;
        int i2;
        IIOMetadataNode root2 = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode node2 = new IIOMetadataNode("ImageDescriptor");
        node2.setAttribute("imageLeftPosition", Integer.toString(this.imageLeftPosition));
        node2.setAttribute("imageTopPosition", Integer.toString(this.imageTopPosition));
        node2.setAttribute("imageWidth", Integer.toString(this.imageWidth));
        node2.setAttribute("imageHeight", Integer.toString(this.imageHeight));
        node2.setAttribute("interlaceFlag", this.interlaceFlag ? "true" : "false");
        root2.appendChild(node2);
        if (this.localColorTable != null) {
            node2 = new IIOMetadataNode("LocalColorTable");
            int numEntries = this.localColorTable.length / 3;
            node2.setAttribute("sizeOfLocalColorTable", Integer.toString(numEntries));
            node2.setAttribute("sortFlag", this.sortFlag ? "TRUE" : "FALSE");
            for (i2 = 0; i2 < numEntries; ++i2) {
                IIOMetadataNode entry = new IIOMetadataNode("ColorTableEntry");
                entry.setAttribute("index", Integer.toString(i2));
                int r = this.localColorTable[3 * i2] & 0xFF;
                int g = this.localColorTable[3 * i2 + 1] & 0xFF;
                int b = this.localColorTable[3 * i2 + 2] & 0xFF;
                entry.setAttribute("red", Integer.toString(r));
                entry.setAttribute("green", Integer.toString(g));
                entry.setAttribute("blue", Integer.toString(b));
                node2.appendChild(entry);
            }
            root2.appendChild(node2);
        }
        node2 = new IIOMetadataNode("GraphicControlExtension");
        node2.setAttribute("disposalMethod", disposalMethodNames[this.disposalMethod]);
        node2.setAttribute("userInputFlag", this.userInputFlag ? "true" : "false");
        node2.setAttribute("transparentColorFlag", this.transparentColorFlag ? "true" : "false");
        node2.setAttribute("delayTime", Integer.toString(this.delayTime));
        node2.setAttribute("transparentColorIndex", Integer.toString(this.transparentColorIndex));
        root2.appendChild(node2);
        if (this.hasPlainTextExtension) {
            node2 = new IIOMetadataNode("PlainTextExtension");
            node2.setAttribute("textGridLeft", Integer.toString(this.textGridLeft));
            node2.setAttribute("textGridTop", Integer.toString(this.textGridTop));
            node2.setAttribute("textGridWidth", Integer.toString(this.textGridWidth));
            node2.setAttribute("textGridHeight", Integer.toString(this.textGridHeight));
            node2.setAttribute("characterCellWidth", Integer.toString(this.characterCellWidth));
            node2.setAttribute("characterCellHeight", Integer.toString(this.characterCellHeight));
            node2.setAttribute("textForegroundColor", Integer.toString(this.textForegroundColor));
            node2.setAttribute("textBackgroundColor", Integer.toString(this.textBackgroundColor));
            node2.setAttribute("text", this.toISO8859(this.text));
            root2.appendChild(node2);
        }
        int n = numAppExtensions = this.applicationIDs == null ? 0 : this.applicationIDs.size();
        if (numAppExtensions > 0) {
            node2 = new IIOMetadataNode("ApplicationExtensions");
            for (i2 = 0; i2 < numAppExtensions; ++i2) {
                IIOMetadataNode appExtNode = new IIOMetadataNode("ApplicationExtension");
                byte[] applicationID = (byte[])this.applicationIDs.get(i2);
                appExtNode.setAttribute("applicationID", this.toISO8859(applicationID));
                byte[] authenticationCode = (byte[])this.authenticationCodes.get(i2);
                appExtNode.setAttribute("authenticationCode", this.toISO8859(authenticationCode));
                byte[] appData = (byte[])this.applicationData.get(i2);
                appExtNode.setUserObject((byte[])appData.clone());
                node2.appendChild(appExtNode);
            }
            root2.appendChild(node2);
        }
        int n2 = numComments = this.comments == null ? 0 : this.comments.size();
        if (numComments > 0) {
            node2 = new IIOMetadataNode("CommentExtensions");
            for (int i3 = 0; i3 < numComments; ++i3) {
                IIOMetadataNode commentNode = new IIOMetadataNode("CommentExtension");
                byte[] comment = (byte[])this.comments.get(i3);
                commentNode.setAttribute("value", this.toISO8859(comment));
                node2.appendChild(commentNode);
            }
            root2.appendChild(node2);
        }
        return root2;
    }

    @Override
    public IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode chroma_node = new IIOMetadataNode("Chroma");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("ColorSpaceType");
        node2.setAttribute("name", "RGB");
        chroma_node.appendChild(node2);
        node2 = new IIOMetadataNode("NumChannels");
        node2.setAttribute("value", this.transparentColorFlag ? "4" : "3");
        chroma_node.appendChild(node2);
        node2 = new IIOMetadataNode("BlackIsZero");
        node2.setAttribute("value", "TRUE");
        chroma_node.appendChild(node2);
        if (this.localColorTable != null) {
            node2 = new IIOMetadataNode("Palette");
            int numEntries = this.localColorTable.length / 3;
            for (int i2 = 0; i2 < numEntries; ++i2) {
                IIOMetadataNode entry = new IIOMetadataNode("PaletteEntry");
                entry.setAttribute("index", Integer.toString(i2));
                entry.setAttribute("red", Integer.toString(this.localColorTable[3 * i2] & 0xFF));
                entry.setAttribute("green", Integer.toString(this.localColorTable[3 * i2 + 1] & 0xFF));
                entry.setAttribute("blue", Integer.toString(this.localColorTable[3 * i2 + 2] & 0xFF));
                node2.appendChild(entry);
            }
            chroma_node.appendChild(node2);
        }
        return chroma_node;
    }

    @Override
    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode compression_node = new IIOMetadataNode("Compression");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("CompressionTypeName");
        node2.setAttribute("value", "lzw");
        compression_node.appendChild(node2);
        node2 = new IIOMetadataNode("Lossless");
        node2.setAttribute("value", "TRUE");
        compression_node.appendChild(node2);
        node2 = new IIOMetadataNode("NumProgressiveScans");
        node2.setAttribute("value", this.interlaceFlag ? "4" : "1");
        compression_node.appendChild(node2);
        return compression_node;
    }

    @Override
    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode data_node = new IIOMetadataNode("Data");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("SampleFormat");
        node2.setAttribute("value", "Index");
        data_node.appendChild(node2);
        return data_node;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dimension_node = new IIOMetadataNode("Dimension");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("ImageOrientation");
        node2.setAttribute("value", "Normal");
        dimension_node.appendChild(node2);
        node2 = new IIOMetadataNode("HorizontalPixelOffset");
        node2.setAttribute("value", Integer.toString(this.imageLeftPosition));
        dimension_node.appendChild(node2);
        node2 = new IIOMetadataNode("VerticalPixelOffset");
        node2.setAttribute("value", Integer.toString(this.imageTopPosition));
        dimension_node.appendChild(node2);
        return dimension_node;
    }

    @Override
    public IIOMetadataNode getStandardTextNode() {
        if (this.comments == null) {
            return null;
        }
        Iterator commentIter = this.comments.iterator();
        if (!commentIter.hasNext()) {
            return null;
        }
        IIOMetadataNode text_node = new IIOMetadataNode("Text");
        IIOMetadataNode node2 = null;
        while (commentIter.hasNext()) {
            byte[] comment = (byte[])commentIter.next();
            String s = null;
            try {
                s = new String(comment, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding ISO-8859-1 unknown!");
            }
            node2 = new IIOMetadataNode("TextEntry");
            node2.setAttribute("value", s);
            node2.setAttribute("encoding", "ISO-8859-1");
            node2.setAttribute("compression", "none");
            text_node.appendChild(node2);
        }
        return text_node;
    }

    @Override
    public IIOMetadataNode getStandardTransparencyNode() {
        if (!this.transparentColorFlag) {
            return null;
        }
        IIOMetadataNode transparency_node = new IIOMetadataNode("Transparency");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("TransparentIndex");
        node2.setAttribute("value", Integer.toString(this.transparentColorIndex));
        transparency_node.appendChild(node2);
        return transparency_node;
    }

    @Override
    public void setFromTree(String formatName, Node root2) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    protected void mergeNativeTree(Node root2) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    protected void mergeStandardTree(Node root2) throws IIOInvalidTreeException {
        throw new IllegalStateException("Metadata is read-only!");
    }

    @Override
    public void reset() {
        throw new IllegalStateException("Metadata is read-only!");
    }
}

