/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.plugins.pcx;

import com.github.jaiimageio.impl.plugins.pcx.PCXConstants;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PCXMetadata
extends IIOMetadata
implements Cloneable,
PCXConstants {
    short version;
    byte bitsPerPixel;
    boolean gotxmin;
    boolean gotymin;
    short xmin;
    short ymin;
    int vdpi;
    int hdpi;
    int hsize;
    int vsize;

    PCXMetadata() {
        super(true, null, null, null, null);
        this.reset();
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String formatName, Node root2) throws IIOInvalidTreeException {
        if (formatName.equals("javax_imageio_1.0")) {
            if (root2 == null) {
                throw new IllegalArgumentException("root == null!");
            }
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
        this.mergeStandardTree(root2);
    }

    @Override
    public void reset() {
        this.version = (short)5;
        this.bitsPerPixel = 0;
        this.gotxmin = false;
        this.gotymin = false;
        this.xmin = 0;
        this.ymin = 0;
        this.vdpi = 72;
        this.hdpi = 72;
        this.hsize = 0;
        this.vsize = 0;
    }

    @Override
    public IIOMetadataNode getStandardDocumentNode() {
        String versionString;
        switch (this.version) {
            case 0: {
                versionString = "2.5";
                break;
            }
            case 2: {
                versionString = "2.8 with palette";
                break;
            }
            case 3: {
                versionString = "2.8 without palette";
                break;
            }
            case 4: {
                versionString = "PC Paintbrush for Windows";
                break;
            }
            case 5: {
                versionString = "3.0";
                break;
            }
            default: {
                versionString = null;
            }
        }
        IIOMetadataNode documentNode = null;
        if (versionString != null) {
            documentNode = new IIOMetadataNode("Document");
            IIOMetadataNode node2 = new IIOMetadataNode("FormatVersion");
            node2.setAttribute("value", versionString);
            documentNode.appendChild(node2);
        }
        return documentNode;
    }

    @Override
    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode dimensionNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode node2 = null;
        node2 = new IIOMetadataNode("HorizontalPixelOffset");
        node2.setAttribute("value", String.valueOf(this.xmin));
        dimensionNode.appendChild(node2);
        node2 = new IIOMetadataNode("VerticalPixelOffset");
        node2.setAttribute("value", String.valueOf(this.ymin));
        dimensionNode.appendChild(node2);
        node2 = new IIOMetadataNode("HorizontalPixelSize");
        node2.setAttribute("value", String.valueOf(254.0 / (double)this.hdpi));
        dimensionNode.appendChild(node2);
        node2 = new IIOMetadataNode("VerticalPixelSize");
        node2.setAttribute("value", String.valueOf(254.0 / (double)this.vdpi));
        dimensionNode.appendChild(node2);
        if (this.hsize != 0) {
            node2 = new IIOMetadataNode("HorizontalScreenSize");
            node2.setAttribute("value", String.valueOf(this.hsize));
            dimensionNode.appendChild(node2);
        }
        if (this.vsize != 0) {
            node2 = new IIOMetadataNode("VerticalScreenSize");
            node2.setAttribute("value", String.valueOf(this.vsize));
            dimensionNode.appendChild(node2);
        }
        return dimensionNode;
    }

    private void mergeStandardTree(Node root2) throws IIOInvalidTreeException {
        Node node2 = root2;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            throw new IIOInvalidTreeException("Root must be javax_imageio_1.0", node2);
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            String name = node2.getNodeName();
            if (!name.equals("Dimension")) continue;
            for (Node child = node2.getFirstChild(); child != null; child = child.getNextSibling()) {
                String childName = child.getNodeName();
                if (childName.equals("HorizontalPixelOffset")) {
                    String hpo = PCXMetadata.getAttribute(child, "value");
                    this.xmin = Short.valueOf(hpo);
                    this.gotxmin = true;
                    continue;
                }
                if (childName.equals("VerticalPixelOffset")) {
                    String vpo = PCXMetadata.getAttribute(child, "value");
                    this.ymin = Short.valueOf(vpo);
                    this.gotymin = true;
                    continue;
                }
                if (childName.equals("HorizontalPixelSize")) {
                    String hps = PCXMetadata.getAttribute(child, "value");
                    this.hdpi = (int)(254.0f / Float.parseFloat(hps) + 0.5f);
                    continue;
                }
                if (childName.equals("VerticalPixelSize")) {
                    String vps = PCXMetadata.getAttribute(child, "value");
                    this.vdpi = (int)(254.0f / Float.parseFloat(vps) + 0.5f);
                    continue;
                }
                if (childName.equals("HorizontalScreenSize")) {
                    String hss = PCXMetadata.getAttribute(child, "value");
                    this.hsize = Integer.valueOf(hss);
                    continue;
                }
                if (!childName.equals("VerticalScreenSize")) continue;
                String vss = PCXMetadata.getAttribute(child, "value");
                this.vsize = Integer.valueOf(vss);
            }
        }
    }

    private static String getAttribute(Node node2, String attrName) {
        NamedNodeMap attrs = node2.getAttributes();
        Node attr = attrs.getNamedItem(attrName);
        return attr != null ? attr.getNodeValue() : null;
    }
}

