/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.plugins.pnm;

import com.github.jaiimageio.impl.common.ImageUtil;
import com.github.jaiimageio.impl.plugins.pnm.I18N;
import com.github.jaiimageio.plugins.pnm.PNMImageWriteParam;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PNMMetadata
extends IIOMetadata
implements Cloneable {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_pnm_image_1.0";
    private int maxSample;
    private int width;
    private int height;
    private int variant;
    private ArrayList comments;
    private int maxSampleSize;

    PNMMetadata() {
        super(true, nativeMetadataFormatName, "com.github.jaiimageio.impl.plugins.pnm.PNMMetadataFormat", null, null);
    }

    public PNMMetadata(IIOMetadata metadata2) throws IIOInvalidTreeException {
        this();
        if (metadata2 != null) {
            List<String> formats = Arrays.asList(metadata2.getMetadataFormatNames());
            if (formats.contains(nativeMetadataFormatName)) {
                this.setFromTree(nativeMetadataFormatName, metadata2.getAsTree(nativeMetadataFormatName));
            } else if (metadata2.isStandardMetadataFormatSupported()) {
                String format = "javax_imageio_1.0";
                this.setFromTree(format, metadata2.getAsTree(format));
            }
        }
    }

    PNMMetadata(ImageTypeSpecifier imageType, ImageWriteParam param2) {
        this();
        this.initialize(imageType, param2);
    }

    void initialize(ImageTypeSpecifier imageType, ImageWriteParam param2) {
        ImageTypeSpecifier destType = null;
        if (param2 != null) {
            destType = param2.getDestinationType();
            if (destType == null) {
                destType = imageType;
            }
        } else {
            destType = imageType;
        }
        if (destType != null) {
            SampleModel sm = destType.getSampleModel();
            int[] sampleSize = sm.getSampleSize();
            this.width = sm.getWidth();
            this.height = sm.getHeight();
            for (int i2 = 0; i2 < sampleSize.length; ++i2) {
                if (sampleSize[i2] <= this.maxSampleSize) continue;
                this.maxSampleSize = sampleSize[i2];
            }
            this.maxSample = (1 << this.maxSampleSize) - 1;
            boolean isRaw = true;
            if (param2 instanceof PNMImageWriteParam) {
                isRaw = ((PNMImageWriteParam)param2).getRaw();
            }
            if (this.maxSampleSize == 1) {
                this.variant = 49;
            } else if (sm.getNumBands() == 1) {
                this.variant = 50;
            } else if (sm.getNumBands() == 3) {
                this.variant = 51;
            }
            if (this.variant <= 51 && isRaw && this.maxSampleSize <= 8) {
                this.variant += 3;
            }
        }
    }

    protected Object clone() {
        PNMMetadata theClone = null;
        try {
            theClone = (PNMMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.comments != null) {
            int numComments = this.comments.size();
            for (int i2 = 0; i2 < numComments; ++i2) {
                theClone.addComment((String)this.comments.get(i2));
            }
        }
        return theClone;
    }

    @Override
    public Node getAsTree(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (formatName.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (formatName.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("PNMMetadata1") + " " + formatName);
    }

    IIOMetadataNode getNativeTree() {
        IIOMetadataNode root2 = new IIOMetadataNode(nativeMetadataFormatName);
        IIOMetadataNode child = new IIOMetadataNode("FormatName");
        child.setUserObject(this.getFormatName());
        child.setNodeValue(this.getFormatName());
        root2.appendChild(child);
        child = new IIOMetadataNode("Variant");
        child.setUserObject(this.getVariant());
        child.setNodeValue(this.getVariant());
        root2.appendChild(child);
        child = new IIOMetadataNode("Width");
        Number tmp = new Integer(this.width);
        child.setUserObject(tmp);
        child.setNodeValue(ImageUtil.convertObjectToString(tmp));
        root2.appendChild(child);
        child = new IIOMetadataNode("Height");
        tmp = new Integer(this.height);
        child.setUserObject(tmp);
        child.setNodeValue(ImageUtil.convertObjectToString(tmp));
        root2.appendChild(child);
        child = new IIOMetadataNode("MaximumSample");
        tmp = new Byte((byte)this.maxSample);
        child.setUserObject(tmp);
        child.setNodeValue(ImageUtil.convertObjectToString(new Integer(this.maxSample)));
        root2.appendChild(child);
        if (this.comments != null) {
            for (int i2 = 0; i2 < this.comments.size(); ++i2) {
                child = new IIOMetadataNode("Comment");
                tmp = this.comments.get(i2);
                child.setUserObject(tmp);
                child.setNodeValue(ImageUtil.convertObjectToString(tmp));
                root2.appendChild(child);
            }
        }
        return root2;
    }

    @Override
    protected IIOMetadataNode getStandardChromaNode() {
        IIOMetadataNode node2 = new IIOMetadataNode("Chroma");
        int temp = (this.variant - 49) % 3 + 1;
        IIOMetadataNode subNode = new IIOMetadataNode("ColorSpaceType");
        if (temp == 3) {
            subNode.setAttribute("name", "RGB");
        } else {
            subNode.setAttribute("name", "GRAY");
        }
        node2.appendChild(subNode);
        subNode = new IIOMetadataNode("NumChannels");
        subNode.setAttribute("value", "" + (temp == 3 ? 3 : 1));
        node2.appendChild(subNode);
        if (temp != 3) {
            subNode = new IIOMetadataNode("BlackIsZero");
            subNode.setAttribute("value", "TRUE");
            node2.appendChild(subNode);
        }
        return node2;
    }

    @Override
    protected IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode node2 = new IIOMetadataNode("Data");
        IIOMetadataNode subNode = new IIOMetadataNode("SampleFormat");
        subNode.setAttribute("value", "UnsignedIntegral");
        node2.appendChild(subNode);
        int temp = (this.variant - 49) % 3 + 1;
        subNode = new IIOMetadataNode("BitsPerSample");
        if (temp == 1) {
            subNode.setAttribute("value", "1");
        } else if (temp == 2) {
            subNode.setAttribute("value", "8");
        } else {
            subNode.setAttribute("value", "8 8 8");
        }
        node2.appendChild(subNode);
        subNode = new IIOMetadataNode("SignificantBitsPerSample");
        if (temp == 1 || temp == 2) {
            subNode.setAttribute("value", "" + this.maxSampleSize);
        } else {
            subNode.setAttribute("value", this.maxSampleSize + " " + this.maxSampleSize + " " + this.maxSampleSize);
        }
        node2.appendChild(subNode);
        return node2;
    }

    @Override
    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode node2 = new IIOMetadataNode("Dimension");
        IIOMetadataNode subNode = new IIOMetadataNode("ImageOrientation");
        subNode.setAttribute("value", "Normal");
        node2.appendChild(subNode);
        return node2;
    }

    @Override
    protected IIOMetadataNode getStandardTextNode() {
        if (this.comments != null) {
            IIOMetadataNode node2 = new IIOMetadataNode("Text");
            for (String comment : this.comments) {
                IIOMetadataNode subNode = new IIOMetadataNode("TextEntry");
                subNode.setAttribute("keyword", "comment");
                subNode.setAttribute("value", comment);
                node2.appendChild(subNode);
            }
            return node2;
        }
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void mergeTree(String formatName, Node root2) throws IIOInvalidTreeException {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2"));
        }
        if (formatName.equals(nativeMetadataFormatName) && root2.getNodeName().equals(nativeMetadataFormatName)) {
            this.mergeNativeTree(root2);
        } else if (formatName.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(root2);
        } else {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata1") + " " + formatName);
        }
    }

    @Override
    public void setFromTree(String formatName, Node root2) throws IIOInvalidTreeException {
        if (formatName == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata0"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2"));
        }
        if (formatName.equals(nativeMetadataFormatName) && root2.getNodeName().equals(nativeMetadataFormatName)) {
            this.mergeNativeTree(root2);
        } else if (formatName.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(root2);
        } else {
            throw new IllegalArgumentException(I18N.getString("PNMMetadata2") + " " + formatName);
        }
    }

    @Override
    public void reset() {
        this.maxSampleSize = 0;
        this.variant = 0;
        this.height = 0;
        this.width = 0;
        this.maxSample = 0;
        this.comments = null;
    }

    public String getFormatName() {
        int v = (this.variant - 49) % 3 + 1;
        if (v == 1) {
            return "PBM";
        }
        if (v == 2) {
            return "PGM";
        }
        if (v == 3) {
            return "PPM";
        }
        return null;
    }

    public String getVariant() {
        if (this.variant > 51) {
            return "RAWBITS";
        }
        return "ASCII";
    }

    boolean isRaw() {
        return this.getVariant().equals("RAWBITS");
    }

    public void setVariant(int v) {
        this.variant = v;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public void setHeight(int h) {
        this.height = h;
    }

    int getMaxBitDepth() {
        return this.maxSampleSize;
    }

    int getMaxValue() {
        return this.maxSample;
    }

    public void setMaxBitDepth(int maxValue) {
        this.maxSample = maxValue;
        this.maxSampleSize = 0;
        while (maxValue > 0) {
            maxValue >>>= 1;
            ++this.maxSampleSize;
        }
    }

    public synchronized void addComment(String comment) {
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        comment = comment.replaceAll("[\n\r\f]", " ");
        this.comments.add(comment);
    }

    Iterator getComments() {
        return this.comments == null ? null : this.comments.iterator();
    }

    private void mergeNativeTree(Node root2) throws IIOInvalidTreeException {
        NodeList list2 = root2.getChildNodes();
        String format = null;
        String var = null;
        for (int i2 = list2.getLength() - 1; i2 >= 0; --i2) {
            IIOMetadataNode node2 = (IIOMetadataNode)list2.item(i2);
            String name = node2.getNodeName();
            if (name.equals("Comment")) {
                this.addComment((String)node2.getUserObject());
                continue;
            }
            if (name.equals("Width")) {
                this.width = (Integer)node2.getUserObject();
                continue;
            }
            if (name.equals("Height")) {
                this.width = (Integer)node2.getUserObject();
                continue;
            }
            if (name.equals("MaximumSample")) {
                int maxValue = (Integer)node2.getUserObject();
                this.setMaxBitDepth(maxValue);
                continue;
            }
            if (name.equals("FormatName")) {
                format = (String)node2.getUserObject();
                continue;
            }
            if (!name.equals("Variant")) continue;
            var = (String)node2.getUserObject();
        }
        if (format.equals("PBM")) {
            this.variant = 49;
        } else if (format.equals("PGM")) {
            this.variant = 50;
        } else if (format.equals("PPM")) {
            this.variant = 51;
        }
        if (var.equals("RAWBITS")) {
            this.variant += 3;
        }
    }

    private void mergeStandardTree(Node root2) throws IIOInvalidTreeException {
        NodeList children = root2.getChildNodes();
        String colorSpace = null;
        int numComps = 0;
        int[] bitsPerSample = null;
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            String name1;
            int j;
            NodeList children1;
            Node node2 = children.item(i2);
            String name = node2.getNodeName();
            if (name.equals("Chroma")) {
                children1 = node2.getChildNodes();
                for (j = 0; j < children1.getLength(); ++j) {
                    Node child = children1.item(j);
                    name1 = child.getNodeName();
                    if (name1.equals("NumChannels")) {
                        String s = (String)this.getAttribute(child, "value");
                        numComps = new Integer(s);
                        continue;
                    }
                    if (!name1.equals("ColorSpaceType")) continue;
                    colorSpace = (String)this.getAttribute(child, "name");
                }
                continue;
            }
            if (name.equals("Compression")) continue;
            if (name.equals("Data")) {
                children1 = node2.getChildNodes();
                int maxBitDepth = -1;
                for (int j2 = 0; j2 < children1.getLength(); ++j2) {
                    Node child = children1.item(j2);
                    String name12 = child.getNodeName();
                    if (name12.equals("BitsPerSample")) {
                        ArrayList<Integer> bps = new ArrayList<Integer>(3);
                        String s = (String)this.getAttribute(child, "value");
                        StringTokenizer t = new StringTokenizer(s);
                        while (t.hasMoreTokens()) {
                            bps.add(Integer.valueOf(t.nextToken()));
                        }
                        bitsPerSample = new int[bps.size()];
                        for (int k = 0; k < bitsPerSample.length; ++k) {
                            bitsPerSample[k] = (Integer)bps.get(k);
                        }
                        continue;
                    }
                    if (!name12.equals("SignificantBitsPerSample")) continue;
                    String s = (String)this.getAttribute(child, "value");
                    StringTokenizer t = new StringTokenizer(s);
                    while (t.hasMoreTokens()) {
                        int sbps = Integer.valueOf(t.nextToken());
                        maxBitDepth = Math.max(sbps, maxBitDepth);
                    }
                }
                if (maxBitDepth > 0) {
                    this.setMaxBitDepth((1 << maxBitDepth) - 1);
                    continue;
                }
                if (bitsPerSample == null) continue;
                for (int k = 0; k < bitsPerSample.length; ++k) {
                    if (bitsPerSample[k] <= maxBitDepth) continue;
                    maxBitDepth = bitsPerSample[k];
                }
                this.setMaxBitDepth((1 << maxBitDepth) - 1);
                continue;
            }
            if (name.equals("Dimension") || name.equals("Document")) continue;
            if (name.equals("Text")) {
                children1 = node2.getChildNodes();
                for (j = 0; j < children1.getLength(); ++j) {
                    Node child = children1.item(j);
                    name1 = child.getNodeName();
                    if (!name1.equals("TextEntry")) continue;
                    this.addComment((String)this.getAttribute(child, "value"));
                }
                continue;
            }
            if (name.equals("Transparency")) continue;
            throw new IIOInvalidTreeException(I18N.getString("PNMMetadata3") + " " + name, node2);
        }
        this.variant = colorSpace != null && colorSpace.equals("RGB") || numComps > 1 || bitsPerSample.length > 1 ? 51 : (this.maxSampleSize > 1 ? 50 : 49);
    }

    public Object getAttribute(Node node2, String name) {
        NamedNodeMap map2 = node2.getAttributes();
        return (node2 = map2.getNamedItem(name)) != null ? node2.getNodeValue() : null;
    }
}

