/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.plugins.tiff;

import java.io.IOException;
import javax.imageio.IIOException;

public class TIFFLZWUtil {
    private static final boolean debug = false;
    byte[] srcData;
    int srcIndex;
    byte[] dstData;
    int dstIndex = 0;
    byte[][] stringTable;
    int tableIndex;
    int bitsToGet = 9;
    int predictor;
    int samplesPerPixel;
    int nextData = 0;
    int nextBits = 0;
    private static final int[] andTable = new int[]{511, 1023, 2047, 4095};

    public byte[] decode(byte[] data2, int predictor, int samplesPerPixel, int width, int height) throws IOException {
        int code;
        if (data2[0] == 0 && data2[1] == 1) {
            throw new IIOException("TIFF 5.0-style LZW compression is not supported!");
        }
        this.srcData = data2;
        this.srcIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        this.dstData = new byte[8192];
        this.dstIndex = 0;
        this.initializeStringTable();
        int oldCode = 0;
        while ((code = this.getNextCode()) != 257) {
            byte[] string2;
            if (code == 256) {
                this.initializeStringTable();
                code = this.getNextCode();
                if (code == 257) break;
                this.writeString(this.stringTable[code]);
                oldCode = code;
                continue;
            }
            if (code < this.tableIndex) {
                string2 = this.stringTable[code];
                this.writeString(string2);
                this.addStringToTable(this.stringTable[oldCode], string2[0]);
                oldCode = code;
                continue;
            }
            string2 = this.stringTable[oldCode];
            string2 = this.composeString(string2, string2[0]);
            this.writeString(string2);
            this.addStringToTable(string2);
            oldCode = code;
        }
        if (predictor == 2) {
            for (int j = 0; j < height; ++j) {
                int count = samplesPerPixel * (j * width + 1);
                for (int i2 = samplesPerPixel; i2 < width * samplesPerPixel; ++i2) {
                    int n = count;
                    this.dstData[n] = (byte)(this.dstData[n] + this.dstData[count - samplesPerPixel]);
                    ++count;
                }
            }
        }
        byte[] newDstData = new byte[this.dstIndex];
        System.arraycopy(this.dstData, 0, newDstData, 0, this.dstIndex);
        return newDstData;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.stringTable[i2] = new byte[1];
            this.stringTable[i2][0] = (byte)i2;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    private void ensureCapacity(int bytesToAdd) {
        if (this.dstIndex + bytesToAdd > this.dstData.length) {
            byte[] newDstData = new byte[Math.max((int)((float)this.dstData.length * 1.2f), this.dstIndex + bytesToAdd)];
            System.arraycopy(this.dstData, 0, newDstData, 0, this.dstData.length);
            this.dstData = newDstData;
        }
    }

    public void writeString(byte[] string2) {
        this.ensureCapacity(string2.length);
        for (int i2 = 0; i2 < string2.length; ++i2) {
            this.dstData[this.dstIndex++] = string2[i2];
        }
    }

    public void addStringToTable(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string2 = new byte[length + 1];
        System.arraycopy(oldString, 0, string2, 0, length);
        string2[length] = newString;
        this.stringTable[this.tableIndex++] = string2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] string2) {
        this.stringTable[this.tableIndex++] = string2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string2 = new byte[length + 1];
        System.arraycopy(oldString, 0, string2, 0, length);
        string2[length] = newString;
        return string2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
                this.nextBits += 8;
            }
            int code = this.nextData >> this.nextBits - this.bitsToGet & andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 257;
        }
    }
}

