/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.impl.plugins.tiff;

import com.github.jaiimageio.impl.plugins.tiff.TIFFImageMetadata;
import com.github.jaiimageio.impl.plugins.tiff.TIFFImageReader;
import com.github.jaiimageio.impl.plugins.tiff.TIFFJPEGDecompressor;
import com.github.jaiimageio.plugins.tiff.TIFFField;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOException;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFOldJPEGDecompressor
extends TIFFJPEGDecompressor {
    private static final boolean DEBUG = false;
    private static final int DHT = 196;
    private static final int DQT = 219;
    private static final int DRI = 221;
    private static final int SOF0 = 192;
    private static final int SOS = 218;
    private boolean isInitialized = false;
    private Long JPEGStreamOffset = null;
    private int SOFPosition = -1;
    private byte[] SOSMarker = null;
    private int subsamplingX = 2;
    private int subsamplingY = 2;

    private synchronized void initialize() throws IOException {
        int i2;
        TIFFField YCbCrSubsamplingField;
        long[] segmentOffsets;
        boolean isTiled;
        if (this.isInitialized) {
            return;
        }
        TIFFImageMetadata tim = (TIFFImageMetadata)this.metadata;
        TIFFField JPEGInterchangeFormatField = tim.getTIFFField(513);
        TIFFField segmentOffsetField = tim.getTIFFField(324);
        if (segmentOffsetField == null && (segmentOffsetField = tim.getTIFFField(273)) == null) {
            segmentOffsetField = JPEGInterchangeFormatField;
        }
        boolean bl = isTiled = (segmentOffsets = segmentOffsetField.getAsLongs()).length > 1;
        if (!isTiled) {
            this.stream.seek(this.offset);
            this.stream.mark();
            if (this.stream.read() == 255 && this.stream.read() == 216) {
                this.JPEGStreamOffset = new Long(this.offset);
                ((TIFFImageReader)this.reader).forwardWarningMessage("SOI marker detected at start of strip or tile.");
                this.isInitialized = true;
                this.stream.reset();
                return;
            }
            this.stream.reset();
            if (JPEGInterchangeFormatField != null) {
                long jpegInterchangeOffset = JPEGInterchangeFormatField.getAsLong(0);
                this.stream.mark();
                this.stream.seek(jpegInterchangeOffset);
                if (this.stream.read() == 255 && this.stream.read() == 216) {
                    this.JPEGStreamOffset = new Long(jpegInterchangeOffset);
                } else {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormat does not point to SOI");
                }
                this.stream.reset();
                TIFFField JPEGInterchangeFormatLengthField = tim.getTIFFField(514);
                if (JPEGInterchangeFormatLengthField == null) {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormatLength field is missing");
                } else {
                    long jpegInterchangeLength = JPEGInterchangeFormatLengthField.getAsLong(0);
                    if (jpegInterchangeOffset >= segmentOffsets[0] || jpegInterchangeOffset + jpegInterchangeLength <= segmentOffsets[0]) {
                        ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormatLength field value is invalid");
                    }
                }
                if (this.JPEGStreamOffset != null) {
                    this.isInitialized = true;
                    return;
                }
            }
        }
        if ((YCbCrSubsamplingField = tim.getTIFFField(530)) != null) {
            this.subsamplingX = YCbCrSubsamplingField.getAsChars()[0];
            this.subsamplingY = YCbCrSubsamplingField.getAsChars()[1];
        }
        if (JPEGInterchangeFormatField != null) {
            long jpegInterchangeOffset = JPEGInterchangeFormatField.getAsLong(0);
            TIFFField JPEGInterchangeFormatLengthField = tim.getTIFFField(514);
            if (JPEGInterchangeFormatLengthField != null) {
                long jpegInterchangeLength = JPEGInterchangeFormatLengthField.getAsLong(0);
                if (jpegInterchangeLength >= 2L && jpegInterchangeOffset + jpegInterchangeLength <= segmentOffsets[0]) {
                    this.stream.mark();
                    this.stream.seek(jpegInterchangeOffset + jpegInterchangeLength - 2L);
                    this.tables = this.stream.read() == 255 && this.stream.read() == 217 ? new byte[(int)(jpegInterchangeLength - 2L)] : new byte[(int)jpegInterchangeLength];
                    this.stream.reset();
                    this.stream.mark();
                    this.stream.seek(jpegInterchangeOffset);
                    this.stream.readFully(this.tables);
                    this.stream.reset();
                    ((TIFFImageReader)this.reader).forwardWarningMessage("Incorrect JPEG interchange format: using JPEGInterchangeFormat offset to derive tables.");
                } else {
                    ((TIFFImageReader)this.reader).forwardWarningMessage("JPEGInterchangeFormat+JPEGInterchangeFormatLength > offset to first strip or tile.");
                }
            }
        }
        if (this.tables == null) {
            char restartInterval;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            long streamLength = this.stream.length();
            baos.write(255);
            baos.write(216);
            TIFFField f = tim.getTIFFField(519);
            if (f == null) {
                throw new IIOException("JPEGQTables field missing!");
            }
            long[] off = f.getAsLongs();
            for (i2 = 0; i2 < off.length; ++i2) {
                baos.write(255);
                baos.write(219);
                int markerLength = 67;
                baos.write(markerLength >>> 8 & 0xFF);
                baos.write(markerLength & 0xFF);
                baos.write(i2);
                byte[] qtable = new byte[64];
                if (streamLength != -1L && off[i2] > streamLength) {
                    throw new IIOException("JPEGQTables offset for index " + i2 + " is not in the stream!");
                }
                this.stream.seek(off[i2]);
                this.stream.readFully(qtable);
                baos.write(qtable);
            }
            for (int k = 0; k < 2; ++k) {
                String fieldName;
                int tableTagNumber = k == 0 ? 520 : 521;
                f = tim.getTIFFField(tableTagNumber);
                String string2 = fieldName = tableTagNumber == 520 ? "JPEGDCTables" : "JPEGACTables";
                if (f == null) {
                    throw new IIOException(fieldName + " field missing!");
                }
                off = f.getAsLongs();
                for (int i3 = 0; i3 < off.length; ++i3) {
                    baos.write(255);
                    baos.write(196);
                    byte[] blengths = new byte[16];
                    if (streamLength != -1L && off[i3] > streamLength) {
                        throw new IIOException(fieldName + " offset for index " + i3 + " is not in the stream!");
                    }
                    this.stream.seek(off[i3]);
                    this.stream.readFully(blengths);
                    int numCodes = 0;
                    for (int j = 0; j < 16; ++j) {
                        numCodes += blengths[j] & 0xFF;
                    }
                    char markerLength = (char)(19 + numCodes);
                    baos.write(markerLength >>> 8 & 0xFF);
                    baos.write(markerLength & 0xFF);
                    baos.write(i3 | k << 4);
                    baos.write(blengths);
                    byte[] bcodes = new byte[numCodes];
                    this.stream.readFully(bcodes);
                    baos.write(bcodes);
                }
            }
            baos.write(-1);
            baos.write(-64);
            int sval = 8 + 3 * this.samplesPerPixel;
            baos.write((byte)(sval >>> 8 & 0xFF));
            baos.write((byte)(sval & 0xFF));
            baos.write(8);
            sval = (short)this.srcHeight;
            baos.write((byte)(sval >>> 8 & 0xFF));
            baos.write((byte)(sval & 0xFF));
            sval = (short)this.srcWidth;
            baos.write((byte)(sval >>> 8 & 0xFF));
            baos.write((byte)(sval & 0xFF));
            baos.write((byte)this.samplesPerPixel);
            if (this.samplesPerPixel == 1) {
                baos.write(1);
                baos.write(17);
                baos.write(0);
            } else {
                for (int i4 = 0; i4 < 3; ++i4) {
                    baos.write((byte)(i4 + 1));
                    baos.write((byte)(i4 != 0 ? 17 : (byte)((this.subsamplingX & 0xF) << 4 | this.subsamplingY & 0xF)));
                    baos.write((byte)i4);
                }
            }
            f = tim.getTIFFField(515);
            if (f != null && (restartInterval = f.getAsChars()[0]) != '\u0000') {
                baos.write(-1);
                baos.write(-35);
                sval = 4;
                baos.write((byte)(sval >>> 8 & 0xFF));
                baos.write((byte)(sval & 0xFF));
                baos.write((byte)(restartInterval >>> 8 & 0xFF));
                baos.write((byte)(restartInterval & 0xFF));
            }
            this.tables = baos.toByteArray();
        }
        int idxMax = this.tables.length - 1;
        for (int idx = 0; idx < idxMax; ++idx) {
            if ((this.tables[idx] & 0xFF) != 255 || (this.tables[idx + 1] & 0xFF) != 192) continue;
            this.SOFPosition = idx;
            break;
        }
        if (this.SOFPosition == -1) {
            byte[] tmpTables = new byte[this.tables.length + 10 + 3 * this.samplesPerPixel];
            System.arraycopy(this.tables, 0, tmpTables, 0, this.tables.length);
            int tmpOffset = this.tables.length;
            this.SOFPosition = this.tables.length;
            this.tables = tmpTables;
            this.tables[tmpOffset++] = -1;
            this.tables[tmpOffset++] = -64;
            short sval = (short)(8 + 3 * this.samplesPerPixel);
            this.tables[tmpOffset++] = (byte)(sval >>> 8 & 0xFF);
            this.tables[tmpOffset++] = (byte)(sval & 0xFF);
            this.tables[tmpOffset++] = 8;
            sval = (short)this.srcHeight;
            this.tables[tmpOffset++] = (byte)(sval >>> 8 & 0xFF);
            this.tables[tmpOffset++] = (byte)(sval & 0xFF);
            sval = (short)this.srcWidth;
            this.tables[tmpOffset++] = (byte)(sval >>> 8 & 0xFF);
            this.tables[tmpOffset++] = (byte)(sval & 0xFF);
            this.tables[tmpOffset++] = (byte)this.samplesPerPixel;
            if (this.samplesPerPixel == 1) {
                this.tables[tmpOffset++] = 1;
                this.tables[tmpOffset++] = 17;
                this.tables[tmpOffset++] = 0;
            } else {
                for (i2 = 0; i2 < 3; ++i2) {
                    this.tables[tmpOffset++] = (byte)(i2 + 1);
                    this.tables[tmpOffset++] = (byte)(i2 != 0 ? 17 : (byte)((this.subsamplingX & 0xF) << 4 | this.subsamplingY & 0xF));
                    this.tables[tmpOffset++] = (byte)i2;
                }
            }
        }
        this.stream.mark();
        this.stream.seek(segmentOffsets[0]);
        if (this.stream.read() == 255 && this.stream.read() == 218) {
            int SOSLength = this.stream.read() << 8 | this.stream.read();
            this.SOSMarker = new byte[SOSLength + 2];
            this.SOSMarker[0] = -1;
            this.SOSMarker[1] = -38;
            this.SOSMarker[2] = (byte)((SOSLength & 0xFF00) >> 8);
            this.SOSMarker[3] = (byte)(SOSLength & 0xFF);
            this.stream.readFully(this.SOSMarker, 4, SOSLength - 2);
        } else {
            this.SOSMarker = new byte[8 + 2 * this.samplesPerPixel];
            int SOSMarkerIndex = 0;
            this.SOSMarker[SOSMarkerIndex++] = -1;
            this.SOSMarker[SOSMarkerIndex++] = -38;
            short sval = (short)(6 + 2 * this.samplesPerPixel);
            this.SOSMarker[SOSMarkerIndex++] = (byte)(sval >>> 8 & 0xFF);
            this.SOSMarker[SOSMarkerIndex++] = (byte)(sval & 0xFF);
            this.SOSMarker[SOSMarkerIndex++] = (byte)this.samplesPerPixel;
            if (this.samplesPerPixel == 1) {
                this.SOSMarker[SOSMarkerIndex++] = 1;
                this.SOSMarker[SOSMarkerIndex++] = 0;
            } else {
                for (int i5 = 0; i5 < 3; ++i5) {
                    this.SOSMarker[SOSMarkerIndex++] = (byte)(i5 + 1);
                    this.SOSMarker[SOSMarkerIndex++] = (byte)(i5 << 4 | i5);
                }
            }
            this.SOSMarker[SOSMarkerIndex++] = 0;
            this.SOSMarker[SOSMarkerIndex++] = 63;
            this.SOSMarker[SOSMarkerIndex++] = 0;
        }
        this.stream.reset();
        this.isInitialized = true;
    }

    @Override
    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        this.initialize();
        TIFFImageMetadata tim = (TIFFImageMetadata)this.metadata;
        if (this.JPEGStreamOffset != null) {
            this.stream.seek(this.JPEGStreamOffset);
            this.JPEGReader.setInput(this.stream, false, true);
        } else {
            int tableLength = this.tables.length;
            int bufLength = tableLength + this.SOSMarker.length + this.byteCount + 2;
            byte[] buf = new byte[bufLength];
            if (this.tables != null) {
                System.arraycopy(this.tables, 0, buf, 0, tableLength);
            }
            int bufOffset = tableLength;
            short sval = (short)this.srcHeight;
            buf[this.SOFPosition + 5] = (byte)(sval >>> 8 & 0xFF);
            buf[this.SOFPosition + 6] = (byte)(sval & 0xFF);
            sval = (short)this.srcWidth;
            buf[this.SOFPosition + 7] = (byte)(sval >>> 8 & 0xFF);
            buf[this.SOFPosition + 8] = (byte)(sval & 0xFF);
            this.stream.seek(this.offset);
            byte[] twoBytes = new byte[2];
            this.stream.readFully(twoBytes);
            if ((twoBytes[0] & 0xFF) != 255 || (twoBytes[1] & 0xFF) != 218) {
                System.arraycopy(this.SOSMarker, 0, buf, bufOffset, this.SOSMarker.length);
                bufOffset += this.SOSMarker.length;
            }
            buf[bufOffset++] = twoBytes[0];
            buf[bufOffset++] = twoBytes[1];
            this.stream.readFully(buf, bufOffset, this.byteCount - 2);
            bufOffset += this.byteCount - 2;
            buf[bufOffset++] = -1;
            buf[bufOffset++] = -39;
            ByteArrayInputStream bais = new ByteArrayInputStream(buf, 0, bufOffset);
            MemoryCacheImageInputStream is = new MemoryCacheImageInputStream(bais);
            this.JPEGReader.setInput(is, true, true);
        }
        this.JPEGParam.setDestination(this.rawImage);
        this.JPEGReader.read(0, this.JPEGParam);
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.JPEGReader.dispose();
    }
}

