/*
 * Decompiled with CFR 0.152.
 */
package com.github.yitter.core;

import com.github.yitter.contract.ISnowWorker;
import com.github.yitter.contract.IdGeneratorException;
import com.github.yitter.contract.IdGeneratorOptions;
import com.github.yitter.contract.OverCostActionArg;

public class SnowWorkerM1
implements ISnowWorker {
    protected final long BaseTime;
    protected final short WorkerId;
    protected final byte WorkerIdBitLength;
    protected final byte SeqBitLength;
    protected final int MaxSeqNumber;
    protected final short MinSeqNumber;
    protected final int TopOverCostCount;
    protected final byte _TimestampShift;
    protected static final byte[] _SyncLock = new byte[0];
    protected short _CurrentSeqNumber;
    protected long _LastTimeTick = 0L;
    protected long _TurnBackTimeTick = 0L;
    protected byte _TurnBackIndex = 0;
    protected boolean _IsOverCost = false;
    protected int _OverCostCountInOneTerm = 0;
    protected int _GenCountInOneTerm = 0;
    protected int _TermIndex = 0;

    public SnowWorkerM1(IdGeneratorOptions options) {
        this.BaseTime = options.BaseTime != 0L ? options.BaseTime : 1582136402000L;
        this.WorkerIdBitLength = (byte)(options.WorkerIdBitLength == 0 ? 6 : (int)options.WorkerIdBitLength);
        this.WorkerId = options.WorkerId;
        this.SeqBitLength = (byte)(options.SeqBitLength == 0 ? 6 : (int)options.SeqBitLength);
        this.MaxSeqNumber = options.MaxSeqNumber <= 0 ? (1 << this.SeqBitLength) - 1 : options.MaxSeqNumber;
        this.MinSeqNumber = options.MinSeqNumber;
        this.TopOverCostCount = options.TopOverCostCount == 0 ? 2000 : (int)options.TopOverCostCount;
        this._TimestampShift = (byte)(this.WorkerIdBitLength + this.SeqBitLength);
        this._CurrentSeqNumber = this.MinSeqNumber;
    }

    private void DoGenIdAction(OverCostActionArg arg) {
    }

    private void BeginOverCostAction(long useTimeTick) {
    }

    private void EndOverCostAction(long useTimeTick) {
        if (this._TermIndex > 10000) {
            this._TermIndex = 0;
        }
    }

    private void BeginTurnBackAction(long useTimeTick) {
    }

    private void EndTurnBackAction(long useTimeTick) {
    }

    private long NextOverCostId() {
        long currentTimeTick = this.GetCurrentTimeTick();
        if (currentTimeTick > this._LastTimeTick) {
            this.EndOverCostAction(currentTimeTick);
            this._LastTimeTick = currentTimeTick;
            this._CurrentSeqNumber = this.MinSeqNumber;
            this._IsOverCost = false;
            this._OverCostCountInOneTerm = 0;
            this._GenCountInOneTerm = 0;
            return this.CalcId(this._LastTimeTick);
        }
        if (this._OverCostCountInOneTerm >= this.TopOverCostCount) {
            this.EndOverCostAction(currentTimeTick);
            this._LastTimeTick = this.GetNextTimeTick();
            this._CurrentSeqNumber = this.MinSeqNumber;
            this._IsOverCost = false;
            this._OverCostCountInOneTerm = 0;
            this._GenCountInOneTerm = 0;
            return this.CalcId(this._LastTimeTick);
        }
        if (this._CurrentSeqNumber > this.MaxSeqNumber) {
            ++this._LastTimeTick;
            this._CurrentSeqNumber = this.MinSeqNumber;
            this._IsOverCost = true;
            ++this._OverCostCountInOneTerm;
            ++this._GenCountInOneTerm;
            return this.CalcId(this._LastTimeTick);
        }
        ++this._GenCountInOneTerm;
        return this.CalcId(this._LastTimeTick);
    }

    private long NextNormalId() throws IdGeneratorException {
        long currentTimeTick = this.GetCurrentTimeTick();
        if (currentTimeTick < this._LastTimeTick) {
            if (this._TurnBackTimeTick < 1L) {
                this._TurnBackTimeTick = this._LastTimeTick - 1L;
                this._TurnBackIndex = (byte)(this._TurnBackIndex + 1);
                if (this._TurnBackIndex > 4) {
                    this._TurnBackIndex = 1;
                }
                this.BeginTurnBackAction(this._TurnBackTimeTick);
            }
            return this.CalcTurnBackId(this._TurnBackTimeTick);
        }
        if (this._TurnBackTimeTick > 0L) {
            this.EndTurnBackAction(this._TurnBackTimeTick);
            this._TurnBackTimeTick = 0L;
        }
        if (currentTimeTick > this._LastTimeTick) {
            this._LastTimeTick = currentTimeTick;
            this._CurrentSeqNumber = this.MinSeqNumber;
            return this.CalcId(this._LastTimeTick);
        }
        if (this._CurrentSeqNumber > this.MaxSeqNumber) {
            this.BeginOverCostAction(currentTimeTick);
            ++this._TermIndex;
            ++this._LastTimeTick;
            this._CurrentSeqNumber = this.MinSeqNumber;
            this._IsOverCost = true;
            this._OverCostCountInOneTerm = 1;
            this._GenCountInOneTerm = 1;
            return this.CalcId(this._LastTimeTick);
        }
        return this.CalcId(this._LastTimeTick);
    }

    private long CalcId(long useTimeTick) {
        long result2 = (useTimeTick << this._TimestampShift) + ((long)this.WorkerId << this.SeqBitLength) + (long)this._CurrentSeqNumber;
        this._CurrentSeqNumber = (short)(this._CurrentSeqNumber + 1);
        return result2;
    }

    private long CalcTurnBackId(long useTimeTick) {
        long result2 = (useTimeTick << this._TimestampShift) + ((long)this.WorkerId << this.SeqBitLength) + (long)this._TurnBackIndex;
        --this._TurnBackTimeTick;
        return result2;
    }

    protected long GetCurrentTimeTick() {
        long millis = System.currentTimeMillis();
        return millis - this.BaseTime;
    }

    protected long GetNextTimeTick() {
        long tempTimeTicker = this.GetCurrentTimeTick();
        while (tempTimeTicker <= this._LastTimeTick) {
            tempTimeTicker = this.GetCurrentTimeTick();
        }
        return tempTimeTicker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextId() {
        byte[] byArray = _SyncLock;
        synchronized (_SyncLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._IsOverCost ? this.NextOverCostId() : this.NextNormalId();
        }
    }
}

