/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class InvertedLuminanceSource
extends LuminanceSource {
    private final LuminanceSource delegate;

    public InvertedLuminanceSource(LuminanceSource delegate) {
        super(delegate.getWidth(), delegate.getHeight());
        this.delegate = delegate;
    }

    @Override
    public byte[] getRow(int y, byte[] row2) {
        row2 = this.delegate.getRow(y, row2);
        int width = this.getWidth();
        for (int i2 = 0; i2 < width; ++i2) {
            row2[i2] = (byte)(255 - (row2[i2] & 0xFF));
        }
        return row2;
    }

    @Override
    public byte[] getMatrix() {
        byte[] matrix = this.delegate.getMatrix();
        int length = this.getWidth() * this.getHeight();
        byte[] invertedMatrix = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            invertedMatrix[i2] = (byte)(255 - (matrix[i2] & 0xFF));
        }
        return invertedMatrix;
    }

    @Override
    public boolean isCropSupported() {
        return this.delegate.isCropSupported();
    }

    @Override
    public LuminanceSource crop(int left2, int top2, int width, int height) {
        return new InvertedLuminanceSource(this.delegate.crop(left2, top2, width, height));
    }

    @Override
    public boolean isRotateSupported() {
        return this.delegate.isRotateSupported();
    }

    @Override
    public LuminanceSource invert() {
        return this.delegate;
    }

    @Override
    public LuminanceSource rotateCounterClockwise() {
        return new InvertedLuminanceSource(this.delegate.rotateCounterClockwise());
    }

    @Override
    public LuminanceSource rotateCounterClockwise45() {
        return new InvertedLuminanceSource(this.delegate.rotateCounterClockwise45());
    }
}

