/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import java.util.EnumMap;
import java.util.Map;

public final class Result {
    private final String text;
    private final byte[] rawBytes;
    private final int numBits;
    private ResultPoint[] resultPoints;
    private final BarcodeFormat format;
    private Map<ResultMetadataType, Object> resultMetadata;
    private final long timestamp;

    public Result(String text2, byte[] rawBytes, ResultPoint[] resultPoints, BarcodeFormat format) {
        this(text2, rawBytes, resultPoints, format, System.currentTimeMillis());
    }

    public Result(String text2, byte[] rawBytes, ResultPoint[] resultPoints, BarcodeFormat format, long timestamp) {
        this(text2, rawBytes, rawBytes == null ? 0 : 8 * rawBytes.length, resultPoints, format, timestamp);
    }

    public Result(String text2, byte[] rawBytes, int numBits, ResultPoint[] resultPoints, BarcodeFormat format, long timestamp) {
        this.text = text2;
        this.rawBytes = rawBytes;
        this.numBits = numBits;
        this.resultPoints = resultPoints;
        this.format = format;
        this.resultMetadata = null;
        this.timestamp = timestamp;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public ResultPoint[] getResultPoints() {
        return this.resultPoints;
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.format;
    }

    public Map<ResultMetadataType, Object> getResultMetadata() {
        return this.resultMetadata;
    }

    public void putMetadata(ResultMetadataType type2, Object value) {
        if (this.resultMetadata == null) {
            this.resultMetadata = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        }
        this.resultMetadata.put(type2, value);
    }

    public void putAllMetadata(Map<ResultMetadataType, Object> metadata2) {
        if (metadata2 != null) {
            if (this.resultMetadata == null) {
                this.resultMetadata = metadata2;
            } else {
                this.resultMetadata.putAll(metadata2);
            }
        }
    }

    public void addResultPoints(ResultPoint[] newPoints) {
        ResultPoint[] oldPoints = this.resultPoints;
        if (oldPoints == null) {
            this.resultPoints = newPoints;
        } else if (newPoints != null && newPoints.length > 0) {
            ResultPoint[] allPoints = new ResultPoint[oldPoints.length + newPoints.length];
            System.arraycopy(oldPoints, 0, allPoints, 0, oldPoints.length);
            System.arraycopy(newPoints, 0, allPoints, oldPoints.length, newPoints.length);
            this.resultPoints = allPoints;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.text;
    }
}

