/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.HighLevelEncoder;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    public static AztecCode encode(String data2) {
        return Encoder.encode(data2.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static AztecCode encode(String data2, int minECCPercent, int userSpecifiedLayers) {
        return Encoder.encode(data2.getBytes(StandardCharsets.ISO_8859_1), minECCPercent, userSpecifiedLayers, null);
    }

    public static AztecCode encode(String data2, int minECCPercent, int userSpecifiedLayers, Charset charset) {
        byte[] bytes = data2.getBytes(null != charset ? charset : StandardCharsets.ISO_8859_1);
        return Encoder.encode(bytes, minECCPercent, userSpecifiedLayers, charset);
    }

    public static AztecCode encode(byte[] data2) {
        return Encoder.encode(data2, 33, 0, null);
    }

    public static AztecCode encode(byte[] data2, int minECCPercent, int userSpecifiedLayers) {
        return Encoder.encode(data2, minECCPercent, userSpecifiedLayers, null);
    }

    public static AztecCode encode(byte[] data2, int minECCPercent, int userSpecifiedLayers, Charset charset) {
        int i2;
        int matrixSize;
        BitArray stuffedBits;
        int wordSize;
        int totalBitsInLayer;
        int layers;
        boolean compact;
        BitArray bits = new HighLevelEncoder(data2, charset).encode();
        int eccBits = bits.getSize() * minECCPercent / 100 + 11;
        int totalSizeBits = bits.getSize() + eccBits;
        if (userSpecifiedLayers != 0) {
            compact = userSpecifiedLayers < 0;
            layers = Math.abs(userSpecifiedLayers);
            if (layers > (compact ? 4 : 32)) {
                throw new IllegalArgumentException(String.format("Illegal value %s for layers", userSpecifiedLayers));
            }
            totalBitsInLayer = Encoder.totalBitsInLayer(layers, compact);
            wordSize = WORD_SIZE[layers];
            int usableBitsInLayers = totalBitsInLayer - totalBitsInLayer % wordSize;
            stuffedBits = Encoder.stuffBits(bits, wordSize);
            if (stuffedBits.getSize() + eccBits > usableBitsInLayers) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            if (compact && stuffedBits.getSize() > wordSize * 64) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
        } else {
            wordSize = 0;
            stuffedBits = null;
            int i3 = 0;
            while (true) {
                if (i3 > 32) {
                    throw new IllegalArgumentException("Data too large for an Aztec code");
                }
                compact = i3 <= 3;
                layers = compact ? i3 + 1 : i3;
                totalBitsInLayer = Encoder.totalBitsInLayer(layers, compact);
                if (totalSizeBits <= totalBitsInLayer) {
                    if (stuffedBits == null || wordSize != WORD_SIZE[layers]) {
                        wordSize = WORD_SIZE[layers];
                        stuffedBits = Encoder.stuffBits(bits, wordSize);
                    }
                    int usableBitsInLayers = totalBitsInLayer - totalBitsInLayer % wordSize;
                    if ((!compact || stuffedBits.getSize() <= wordSize * 64) && stuffedBits.getSize() + eccBits <= usableBitsInLayers) break;
                }
                ++i3;
            }
        }
        BitArray messageBits = Encoder.generateCheckWords(stuffedBits, totalBitsInLayer, wordSize);
        int messageSizeInWords = stuffedBits.getSize() / wordSize;
        BitArray modeMessage = Encoder.generateModeMessage(compact, layers, messageSizeInWords);
        int baseMatrixSize = (compact ? 11 : 14) + layers * 4;
        int[] alignmentMap = new int[baseMatrixSize];
        if (compact) {
            matrixSize = baseMatrixSize;
            for (int i4 = 0; i4 < alignmentMap.length; ++i4) {
                alignmentMap[i4] = i4;
            }
        } else {
            matrixSize = baseMatrixSize + 1 + 2 * ((baseMatrixSize / 2 - 1) / 15);
            int origCenter = baseMatrixSize / 2;
            int center2 = matrixSize / 2;
            for (int i5 = 0; i5 < origCenter; ++i5) {
                int newOffset = i5 + i5 / 15;
                alignmentMap[origCenter - i5 - 1] = center2 - newOffset - 1;
                alignmentMap[origCenter + i5] = center2 + newOffset + 1;
            }
        }
        BitMatrix matrix = new BitMatrix(matrixSize);
        int rowOffset = 0;
        for (i2 = 0; i2 < layers; ++i2) {
            int rowSize = (layers - i2) * 4 + (compact ? 9 : 12);
            for (int j = 0; j < rowSize; ++j) {
                int columnOffset = j * 2;
                for (int k = 0; k < 2; ++k) {
                    if (messageBits.get(rowOffset + columnOffset + k)) {
                        matrix.set(alignmentMap[i2 * 2 + k], alignmentMap[i2 * 2 + j]);
                    }
                    if (messageBits.get(rowOffset + rowSize * 2 + columnOffset + k)) {
                        matrix.set(alignmentMap[i2 * 2 + j], alignmentMap[baseMatrixSize - 1 - i2 * 2 - k]);
                    }
                    if (messageBits.get(rowOffset + rowSize * 4 + columnOffset + k)) {
                        matrix.set(alignmentMap[baseMatrixSize - 1 - i2 * 2 - k], alignmentMap[baseMatrixSize - 1 - i2 * 2 - j]);
                    }
                    if (!messageBits.get(rowOffset + rowSize * 6 + columnOffset + k)) continue;
                    matrix.set(alignmentMap[baseMatrixSize - 1 - i2 * 2 - j], alignmentMap[i2 * 2 + k]);
                }
            }
            rowOffset += rowSize * 8;
        }
        Encoder.drawModeMessage(matrix, compact, matrixSize, modeMessage);
        if (compact) {
            Encoder.drawBullsEye(matrix, matrixSize / 2, 5);
        } else {
            Encoder.drawBullsEye(matrix, matrixSize / 2, 7);
            i2 = 0;
            int j = 0;
            while (i2 < baseMatrixSize / 2 - 1) {
                for (int k = matrixSize / 2 & 1; k < matrixSize; k += 2) {
                    matrix.set(matrixSize / 2 - j, k);
                    matrix.set(matrixSize / 2 + j, k);
                    matrix.set(k, matrixSize / 2 - j);
                    matrix.set(k, matrixSize / 2 + j);
                }
                i2 += 15;
                j += 16;
            }
        }
        AztecCode aztec = new AztecCode();
        aztec.setCompact(compact);
        aztec.setSize(matrixSize);
        aztec.setLayers(layers);
        aztec.setCodeWords(messageSizeInWords);
        aztec.setMatrix(matrix);
        return aztec;
    }

    private static void drawBullsEye(BitMatrix matrix, int center2, int size) {
        for (int i2 = 0; i2 < size; i2 += 2) {
            for (int j = center2 - i2; j <= center2 + i2; ++j) {
                matrix.set(j, center2 - i2);
                matrix.set(j, center2 + i2);
                matrix.set(center2 - i2, j);
                matrix.set(center2 + i2, j);
            }
        }
        matrix.set(center2 - size, center2 - size);
        matrix.set(center2 - size + 1, center2 - size);
        matrix.set(center2 - size, center2 - size + 1);
        matrix.set(center2 + size, center2 - size);
        matrix.set(center2 + size, center2 - size + 1);
        matrix.set(center2 + size, center2 + size - 1);
    }

    static BitArray generateModeMessage(boolean compact, int layers, int messageSizeInWords) {
        BitArray modeMessage = new BitArray();
        if (compact) {
            modeMessage.appendBits(layers - 1, 2);
            modeMessage.appendBits(messageSizeInWords - 1, 6);
            modeMessage = Encoder.generateCheckWords(modeMessage, 28, 4);
        } else {
            modeMessage.appendBits(layers - 1, 5);
            modeMessage.appendBits(messageSizeInWords - 1, 11);
            modeMessage = Encoder.generateCheckWords(modeMessage, 40, 4);
        }
        return modeMessage;
    }

    private static void drawModeMessage(BitMatrix matrix, boolean compact, int matrixSize, BitArray modeMessage) {
        int center2 = matrixSize / 2;
        if (compact) {
            for (int i2 = 0; i2 < 7; ++i2) {
                int offset = center2 - 3 + i2;
                if (modeMessage.get(i2)) {
                    matrix.set(offset, center2 - 5);
                }
                if (modeMessage.get(i2 + 7)) {
                    matrix.set(center2 + 5, offset);
                }
                if (modeMessage.get(20 - i2)) {
                    matrix.set(offset, center2 + 5);
                }
                if (!modeMessage.get(27 - i2)) continue;
                matrix.set(center2 - 5, offset);
            }
        } else {
            for (int i3 = 0; i3 < 10; ++i3) {
                int offset = center2 - 5 + i3 + i3 / 5;
                if (modeMessage.get(i3)) {
                    matrix.set(offset, center2 - 7);
                }
                if (modeMessage.get(i3 + 10)) {
                    matrix.set(center2 + 7, offset);
                }
                if (modeMessage.get(29 - i3)) {
                    matrix.set(offset, center2 + 7);
                }
                if (!modeMessage.get(39 - i3)) continue;
                matrix.set(center2 - 7, offset);
            }
        }
    }

    private static BitArray generateCheckWords(BitArray bitArray, int totalBits, int wordSize) {
        int messageSizeInWords = bitArray.getSize() / wordSize;
        ReedSolomonEncoder rs = new ReedSolomonEncoder(Encoder.getGF(wordSize));
        int totalWords = totalBits / wordSize;
        int[] messageWords = Encoder.bitsToWords(bitArray, wordSize, totalWords);
        rs.encode(messageWords, totalWords - messageSizeInWords);
        int startPad = totalBits % wordSize;
        BitArray messageBits = new BitArray();
        messageBits.appendBits(0, startPad);
        for (int messageWord : messageWords) {
            messageBits.appendBits(messageWord, wordSize);
        }
        return messageBits;
    }

    private static int[] bitsToWords(BitArray stuffedBits, int wordSize, int totalWords) {
        int[] message2 = new int[totalWords];
        int n = stuffedBits.getSize() / wordSize;
        for (int i2 = 0; i2 < n; ++i2) {
            int value = 0;
            for (int j = 0; j < wordSize; ++j) {
                value |= stuffedBits.get(i2 * wordSize + j) ? 1 << wordSize - j - 1 : 0;
            }
            message2[i2] = value;
        }
        return message2;
    }

    private static GenericGF getGF(int wordSize) {
        switch (wordSize) {
            case 4: {
                return GenericGF.AZTEC_PARAM;
            }
            case 6: {
                return GenericGF.AZTEC_DATA_6;
            }
            case 8: {
                return GenericGF.AZTEC_DATA_8;
            }
            case 10: {
                return GenericGF.AZTEC_DATA_10;
            }
            case 12: {
                return GenericGF.AZTEC_DATA_12;
            }
        }
        throw new IllegalArgumentException("Unsupported word size " + wordSize);
    }

    static BitArray stuffBits(BitArray bits, int wordSize) {
        BitArray out = new BitArray();
        int n = bits.getSize();
        int mask = (1 << wordSize) - 2;
        for (int i2 = 0; i2 < n; i2 += wordSize) {
            int word = 0;
            for (int j = 0; j < wordSize; ++j) {
                if (i2 + j < n && !bits.get(i2 + j)) continue;
                word |= 1 << wordSize - 1 - j;
            }
            if ((word & mask) == mask) {
                out.appendBits(word & mask, wordSize);
                --i2;
                continue;
            }
            if ((word & mask) == 0) {
                out.appendBits(word | 1, wordSize);
                --i2;
                continue;
            }
            out.appendBits(word, wordSize);
        }
        return out;
    }

    private static int totalBitsInLayer(int layers, boolean compact) {
        return ((compact ? 88 : 112) + 16 * layers) * layers;
    }
}

