/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.beust.jcommander.JCommander;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.EncoderConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.Locale;

public final class CommandLineEncoder {
    private CommandLineEncoder() {
    }

    public static void main(String[] args) throws Exception {
        EncoderConfig config2 = new EncoderConfig();
        JCommander jCommander = new JCommander(config2);
        jCommander.parse(args);
        jCommander.setProgramName(CommandLineEncoder.class.getSimpleName());
        if (config2.help) {
            jCommander.usage();
            return;
        }
        String outFileString = config2.outputFileBase;
        if ("out".equals(outFileString)) {
            outFileString = outFileString + '.' + config2.imageFormat.toLowerCase(Locale.ENGLISH);
        }
        EnumMap<EncodeHintType, String> hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
        if (config2.errorCorrectionLevel != null) {
            hints.put(EncodeHintType.ERROR_CORRECTION, config2.errorCorrectionLevel);
        }
        BitMatrix matrix = new MultiFormatWriter().encode(config2.contents.get(0), config2.barcodeFormat, config2.width, config2.height, hints);
        MatrixToImageWriter.writeToPath(matrix, config2.imageFormat, Paths.get(outFileString, new String[0]));
    }
}

