/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Base64;
import javax.imageio.ImageIO;

public final class ImageReader {
    private static final String BASE64TOKEN = "base64,";

    private ImageReader() {
    }

    public static BufferedImage readImage(URI uri) throws IOException {
        BufferedImage result2;
        if ("data".equals(uri.getScheme())) {
            return ImageReader.readDataURIImage(uri);
        }
        try {
            result2 = ImageIO.read(uri.toURL());
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Resource not found: " + uri, iae);
        }
        if (result2 == null) {
            throw new IOException("Could not load " + uri);
        }
        return result2;
    }

    public static BufferedImage readDataURIImage(URI uri) throws IOException {
        String uriString = uri.getSchemeSpecificPart();
        if (!uriString.startsWith("image/")) {
            throw new IOException("Unsupported data URI MIME type");
        }
        int base64Start = uriString.indexOf(BASE64TOKEN);
        if (base64Start < 0) {
            throw new IOException("Unsupported data URI encoding");
        }
        String base64Data = uriString.substring(base64Start + BASE64TOKEN.length());
        byte[] imageBytes = Base64.getDecoder().decode(base64Data);
        return ImageIO.read(new ByteArrayInputStream(imageBytes));
    }
}

