/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public final class MatrixToImageWriter {
    private static final MatrixToImageConfig DEFAULT_CONFIG = new MatrixToImageConfig();

    private MatrixToImageWriter() {
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        return MatrixToImageWriter.toBufferedImage(matrix, DEFAULT_CONFIG);
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix, MatrixToImageConfig config2) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, config2.getBufferedImageColorModel());
        int onColor = config2.getPixelOnColor();
        int offColor = config2.getPixelOffColor();
        int[] rowPixels = new int[width];
        BitArray row2 = new BitArray(width);
        for (int y = 0; y < height; ++y) {
            row2 = matrix.getRow(y, row2);
            for (int x = 0; x < width; ++x) {
                rowPixels[x] = row2.get(x) ? onColor : offColor;
            }
            image.setRGB(0, y, width, 1, rowPixels, 0, width);
        }
        return image;
    }

    @Deprecated
    public static void writeToFile(BitMatrix matrix, String format, File file) throws IOException {
        MatrixToImageWriter.writeToPath(matrix, format, file.toPath());
    }

    public static void writeToPath(BitMatrix matrix, String format, Path file) throws IOException {
        MatrixToImageWriter.writeToPath(matrix, format, file, DEFAULT_CONFIG);
    }

    @Deprecated
    public static void writeToFile(BitMatrix matrix, String format, File file, MatrixToImageConfig config2) throws IOException {
        MatrixToImageWriter.writeToPath(matrix, format, file.toPath(), config2);
    }

    public static void writeToPath(BitMatrix matrix, String format, Path file, MatrixToImageConfig config2) throws IOException {
        BufferedImage image = MatrixToImageWriter.toBufferedImage(matrix, config2);
        if (!ImageIO.write((RenderedImage)image, format, file.toFile())) {
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
    }

    public static void writeToStream(BitMatrix matrix, String format, OutputStream stream) throws IOException {
        MatrixToImageWriter.writeToStream(matrix, format, stream, DEFAULT_CONFIG);
    }

    public static void writeToStream(BitMatrix matrix, String format, OutputStream stream, MatrixToImageConfig config2) throws IOException {
        BufferedImage image = MatrixToImageWriter.toBufferedImage(matrix, config2);
        if (!ImageIO.write((RenderedImage)image, format, stream)) {
            throw new IOException("Could not write an image of format " + format);
        }
    }
}

