/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;

public final class GeoParsedResult
extends ParsedResult {
    private final double latitude;
    private final double longitude;
    private final double altitude;
    private final String query;

    GeoParsedResult(double latitude, double longitude, double altitude, String query) {
        super(ParsedResultType.GEO);
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.query = query;
    }

    public String getGeoURI() {
        StringBuilder result2 = new StringBuilder();
        result2.append("geo:");
        result2.append(this.latitude);
        result2.append(',');
        result2.append(this.longitude);
        if (this.altitude > 0.0) {
            result2.append(',');
            result2.append(this.altitude);
        }
        if (this.query != null) {
            result2.append('?');
            result2.append(this.query);
        }
        return result2.toString();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder result2 = new StringBuilder(20);
        result2.append(this.latitude);
        result2.append(", ");
        result2.append(this.longitude);
        if (this.altitude > 0.0) {
            result2.append(", ");
            result2.append(this.altitude);
            result2.append('m');
        }
        if (this.query != null) {
            result2.append(" (");
            result2.append(this.query);
            result2.append(')');
        }
        return result2.toString();
    }
}

