/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;

public final class SMSParsedResult
extends ParsedResult {
    private final String[] numbers;
    private final String[] vias;
    private final String subject;
    private final String body;

    public SMSParsedResult(String number, String via, String subject, String body) {
        super(ParsedResultType.SMS);
        this.numbers = new String[]{number};
        this.vias = new String[]{via};
        this.subject = subject;
        this.body = body;
    }

    public SMSParsedResult(String[] numbers, String[] vias, String subject, String body) {
        super(ParsedResultType.SMS);
        this.numbers = numbers;
        this.vias = vias;
        this.subject = subject;
        this.body = body;
    }

    public String getSMSURI() {
        boolean hasSubject;
        StringBuilder result2 = new StringBuilder();
        result2.append("sms:");
        boolean first = true;
        for (int i2 = 0; i2 < this.numbers.length; ++i2) {
            if (first) {
                first = false;
            } else {
                result2.append(',');
            }
            result2.append(this.numbers[i2]);
            if (this.vias == null || this.vias[i2] == null) continue;
            result2.append(";via=");
            result2.append(this.vias[i2]);
        }
        boolean hasBody = this.body != null;
        boolean bl = hasSubject = this.subject != null;
        if (hasBody || hasSubject) {
            result2.append('?');
            if (hasBody) {
                result2.append("body=");
                result2.append(this.body);
            }
            if (hasSubject) {
                if (hasBody) {
                    result2.append('&');
                }
                result2.append("subject=");
                result2.append(this.subject);
            }
        }
        return result2.toString();
    }

    public String[] getNumbers() {
        return this.numbers;
    }

    public String[] getVias() {
        return this.vias;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder result2 = new StringBuilder(100);
        SMSParsedResult.maybeAppend(this.numbers, result2);
        SMSParsedResult.maybeAppend(this.subject, result2);
        SMSParsedResult.maybeAppend(this.body, result2);
        return result2.toString();
    }
}

