/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VCardResultParser
extends ResultParser {
    private static final Pattern BEGIN_VCARD = Pattern.compile("BEGIN:VCARD", 2);
    private static final Pattern VCARD_LIKE_DATE = Pattern.compile("\\d{4}-?\\d{2}-?\\d{2}");
    private static final Pattern CR_LF_SPACE_TAB = Pattern.compile("\r\n[ \t]");
    private static final Pattern NEWLINE_ESCAPE = Pattern.compile("\\\\[nN]");
    private static final Pattern VCARD_ESCAPES = Pattern.compile("\\\\([,;\\\\])");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern UNESCAPED_SEMICOLONS = Pattern.compile("(?<!\\\\);+");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern SEMICOLON_OR_COMMA = Pattern.compile("[;,]");

    @Override
    public AddressBookParsedResult parse(Result result2) {
        String[] geo;
        List<String> nicknameString;
        String rawText = VCardResultParser.getMassagedText(result2);
        Matcher m = BEGIN_VCARD.matcher(rawText);
        if (!m.find() || m.start() != 0) {
            return null;
        }
        List<List<String>> names = VCardResultParser.matchVCardPrefixedField("FN", rawText, true, false);
        if (names == null) {
            names = VCardResultParser.matchVCardPrefixedField("N", rawText, true, false);
            VCardResultParser.formatNames(names);
        }
        String[] nicknames = (nicknameString = VCardResultParser.matchSingleVCardPrefixedField("NICKNAME", rawText, true, false)) == null ? null : COMMA.split(nicknameString.get(0));
        List<List<String>> phoneNumbers = VCardResultParser.matchVCardPrefixedField("TEL", rawText, true, false);
        List<List<String>> emails = VCardResultParser.matchVCardPrefixedField("EMAIL", rawText, true, false);
        List<String> note = VCardResultParser.matchSingleVCardPrefixedField("NOTE", rawText, false, false);
        List<List<String>> addresses = VCardResultParser.matchVCardPrefixedField("ADR", rawText, true, true);
        List<String> org = VCardResultParser.matchSingleVCardPrefixedField("ORG", rawText, true, true);
        List<String> birthday = VCardResultParser.matchSingleVCardPrefixedField("BDAY", rawText, true, false);
        if (birthday != null && !VCardResultParser.isLikeVCardDate(birthday.get(0))) {
            birthday = null;
        }
        List<String> title2 = VCardResultParser.matchSingleVCardPrefixedField("TITLE", rawText, true, false);
        List<List<String>> urls2 = VCardResultParser.matchVCardPrefixedField("URL", rawText, true, false);
        List<String> instantMessenger = VCardResultParser.matchSingleVCardPrefixedField("IMPP", rawText, true, false);
        List<String> geoString = VCardResultParser.matchSingleVCardPrefixedField("GEO", rawText, true, false);
        String[] stringArray = geo = geoString == null ? null : SEMICOLON_OR_COMMA.split(geoString.get(0));
        if (geo != null && geo.length != 2) {
            geo = null;
        }
        return new AddressBookParsedResult(VCardResultParser.toPrimaryValues(names), nicknames, null, VCardResultParser.toPrimaryValues(phoneNumbers), VCardResultParser.toTypes(phoneNumbers), VCardResultParser.toPrimaryValues(emails), VCardResultParser.toTypes(emails), VCardResultParser.toPrimaryValue(instantMessenger), VCardResultParser.toPrimaryValue(note), VCardResultParser.toPrimaryValues(addresses), VCardResultParser.toTypes(addresses), VCardResultParser.toPrimaryValue(org), VCardResultParser.toPrimaryValue(birthday), VCardResultParser.toPrimaryValue(title2), VCardResultParser.toPrimaryValues(urls2), geo);
    }

    static List<List<String>> matchVCardPrefixedField(CharSequence prefix, String rawText, boolean trim, boolean parseFieldDivider) {
        ArrayList matches2 = null;
        int i2 = 0;
        int max = rawText.length();
        while (i2 < max) {
            Matcher matcher = Pattern.compile("(?:^|\n)" + prefix + "(?:;([^:]*))?:", 2).matcher(rawText);
            if (i2 > 0) {
                --i2;
            }
            if (!matcher.find(i2)) break;
            i2 = matcher.end(0);
            String metadataString = matcher.group(1);
            ArrayList<String> metadata2 = null;
            boolean quotedPrintable = false;
            String quotedPrintableCharset = null;
            String valueType = null;
            if (metadataString != null) {
                for (String metadatum : SEMICOLON.split(metadataString)) {
                    if (metadata2 == null) {
                        metadata2 = new ArrayList<String>(1);
                    }
                    metadata2.add(metadatum);
                    String[] metadatumTokens = EQUALS.split(metadatum, 2);
                    if (metadatumTokens.length <= 1) continue;
                    String key2 = metadatumTokens[0];
                    String value = metadatumTokens[1];
                    if ("ENCODING".equalsIgnoreCase(key2) && "QUOTED-PRINTABLE".equalsIgnoreCase(value)) {
                        quotedPrintable = true;
                        continue;
                    }
                    if ("CHARSET".equalsIgnoreCase(key2)) {
                        quotedPrintableCharset = value;
                        continue;
                    }
                    if (!"VALUE".equalsIgnoreCase(key2)) continue;
                    valueType = value;
                }
            }
            int matchStart = i2;
            while ((i2 = rawText.indexOf(10, i2)) >= 0) {
                if (i2 < rawText.length() - 1 && (rawText.charAt(i2 + 1) == ' ' || rawText.charAt(i2 + 1) == '\t')) {
                    i2 += 2;
                    continue;
                }
                if (!quotedPrintable || (i2 < 1 || rawText.charAt(i2 - 1) != '=') && (i2 < 2 || rawText.charAt(i2 - 2) != '=')) break;
                ++i2;
            }
            if (i2 < 0) {
                i2 = max;
                continue;
            }
            if (i2 > matchStart) {
                if (matches2 == null) {
                    matches2 = new ArrayList(1);
                }
                if (i2 >= 1 && rawText.charAt(i2 - 1) == '\r') {
                    --i2;
                }
                String element = rawText.substring(matchStart, i2);
                if (trim) {
                    element = element.trim();
                }
                if (quotedPrintable) {
                    element = VCardResultParser.decodeQuotedPrintable(element, quotedPrintableCharset);
                    if (parseFieldDivider) {
                        element = UNESCAPED_SEMICOLONS.matcher(element).replaceAll("\n").trim();
                    }
                } else {
                    if (parseFieldDivider) {
                        element = UNESCAPED_SEMICOLONS.matcher(element).replaceAll("\n").trim();
                    }
                    element = CR_LF_SPACE_TAB.matcher(element).replaceAll("");
                    element = NEWLINE_ESCAPE.matcher(element).replaceAll("\n");
                    element = VCARD_ESCAPES.matcher(element).replaceAll("$1");
                }
                if ("uri".equals(valueType)) {
                    try {
                        element = URI.create(element).getSchemeSpecificPart();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (metadata2 == null) {
                    ArrayList<String> match = new ArrayList<String>(1);
                    match.add(element);
                    matches2.add(match);
                } else {
                    metadata2.add(0, element);
                    matches2.add(metadata2);
                }
                ++i2;
                continue;
            }
            ++i2;
        }
        return matches2;
    }

    private static String decodeQuotedPrintable(CharSequence value, String charset) {
        int length = value.length();
        StringBuilder result2 = new StringBuilder(length);
        ByteArrayOutputStream fragmentBuffer = new ByteArrayOutputStream();
        block4: for (int i2 = 0; i2 < length; ++i2) {
            char c = value.charAt(i2);
            switch (c) {
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '=': {
                    char nextChar;
                    if (i2 >= length - 2 || (nextChar = value.charAt(i2 + 1)) == '\r' || nextChar == '\n') continue block4;
                    char nextNextChar = value.charAt(i2 + 2);
                    int firstDigit = VCardResultParser.parseHexDigit(nextChar);
                    int secondDigit = VCardResultParser.parseHexDigit(nextNextChar);
                    if (firstDigit >= 0 && secondDigit >= 0) {
                        fragmentBuffer.write((firstDigit << 4) + secondDigit);
                    }
                    i2 += 2;
                    continue block4;
                }
                default: {
                    VCardResultParser.maybeAppendFragment(fragmentBuffer, charset, result2);
                    result2.append(c);
                }
            }
        }
        VCardResultParser.maybeAppendFragment(fragmentBuffer, charset, result2);
        return result2.toString();
    }

    private static void maybeAppendFragment(ByteArrayOutputStream fragmentBuffer, String charset, StringBuilder result2) {
        if (fragmentBuffer.size() > 0) {
            String fragment2;
            byte[] fragmentBytes = fragmentBuffer.toByteArray();
            if (charset == null) {
                fragment2 = new String(fragmentBytes, StandardCharsets.UTF_8);
            } else {
                try {
                    fragment2 = new String(fragmentBytes, charset);
                }
                catch (UnsupportedEncodingException e) {
                    fragment2 = new String(fragmentBytes, StandardCharsets.UTF_8);
                }
            }
            fragmentBuffer.reset();
            result2.append(fragment2);
        }
    }

    static List<String> matchSingleVCardPrefixedField(CharSequence prefix, String rawText, boolean trim, boolean parseFieldDivider) {
        List<List<String>> values2 = VCardResultParser.matchVCardPrefixedField(prefix, rawText, trim, parseFieldDivider);
        return values2 == null || values2.isEmpty() ? null : values2.get(0);
    }

    private static String toPrimaryValue(List<String> list2) {
        return list2 == null || list2.isEmpty() ? null : list2.get(0);
    }

    private static String[] toPrimaryValues(Collection<List<String>> lists) {
        if (lists == null || lists.isEmpty()) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(lists.size());
        for (List<String> list2 : lists) {
            String value = list2.get(0);
            if (value == null || value.isEmpty()) continue;
            result2.add(value);
        }
        return result2.toArray(EMPTY_STR_ARRAY);
    }

    private static String[] toTypes(Collection<List<String>> lists) {
        if (lists == null || lists.isEmpty()) {
            return null;
        }
        ArrayList<String> result2 = new ArrayList<String>(lists.size());
        for (List<String> list2 : lists) {
            String value = list2.get(0);
            if (value == null || value.isEmpty()) continue;
            String type2 = null;
            for (int i2 = 1; i2 < list2.size(); ++i2) {
                String metadatum = list2.get(i2);
                int equals = metadatum.indexOf(61);
                if (equals < 0) {
                    type2 = metadatum;
                    break;
                }
                if (!"TYPE".equalsIgnoreCase(metadatum.substring(0, equals))) continue;
                type2 = metadatum.substring(equals + 1);
                break;
            }
            result2.add(type2);
        }
        return result2.toArray(EMPTY_STR_ARRAY);
    }

    private static boolean isLikeVCardDate(CharSequence value) {
        return value == null || VCARD_LIKE_DATE.matcher(value).matches();
    }

    private static void formatNames(Iterable<List<String>> names) {
        if (names != null) {
            for (List<String> list2 : names) {
                int end;
                String name = list2.get(0);
                String[] components = new String[5];
                int start2 = 0;
                for (int componentIndex = 0; componentIndex < components.length - 1 && (end = name.indexOf(59, start2)) >= 0; ++componentIndex) {
                    components[componentIndex] = name.substring(start2, end);
                    start2 = end + 1;
                }
                components[componentIndex] = name.substring(start2);
                StringBuilder newName = new StringBuilder(100);
                VCardResultParser.maybeAppendComponent(components, 3, newName);
                VCardResultParser.maybeAppendComponent(components, 1, newName);
                VCardResultParser.maybeAppendComponent(components, 2, newName);
                VCardResultParser.maybeAppendComponent(components, 0, newName);
                VCardResultParser.maybeAppendComponent(components, 4, newName);
                list2.set(0, newName.toString().trim());
            }
        }
    }

    private static void maybeAppendComponent(String[] components, int i2, StringBuilder newName) {
        if (components[i2] != null && !components[i2].isEmpty()) {
            if (newName.length() > 0) {
                newName.append(' ');
            }
            newName.append(components[i2]);
        }
    }
}

