/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.VCardResultParser;
import java.util.List;

public final class VEventResultParser
extends ResultParser {
    @Override
    public CalendarParsedResult parse(Result result2) {
        double longitude;
        double latitude;
        String rawText = VEventResultParser.getMassagedText(result2);
        int vEventStart = rawText.indexOf("BEGIN:VEVENT");
        if (vEventStart < 0) {
            return null;
        }
        String summary = VEventResultParser.matchSingleVCardPrefixedField("SUMMARY", rawText);
        String start2 = VEventResultParser.matchSingleVCardPrefixedField("DTSTART", rawText);
        if (start2 == null) {
            return null;
        }
        String end = VEventResultParser.matchSingleVCardPrefixedField("DTEND", rawText);
        String duration = VEventResultParser.matchSingleVCardPrefixedField("DURATION", rawText);
        String location = VEventResultParser.matchSingleVCardPrefixedField("LOCATION", rawText);
        String organizer = VEventResultParser.stripMailto(VEventResultParser.matchSingleVCardPrefixedField("ORGANIZER", rawText));
        String[] attendees = VEventResultParser.matchVCardPrefixedField("ATTENDEE", rawText);
        if (attendees != null) {
            for (int i2 = 0; i2 < attendees.length; ++i2) {
                attendees[i2] = VEventResultParser.stripMailto(attendees[i2]);
            }
        }
        String description2 = VEventResultParser.matchSingleVCardPrefixedField("DESCRIPTION", rawText);
        String geoString = VEventResultParser.matchSingleVCardPrefixedField("GEO", rawText);
        if (geoString == null) {
            latitude = Double.NaN;
            longitude = Double.NaN;
        } else {
            int semicolon = geoString.indexOf(59);
            if (semicolon < 0) {
                return null;
            }
            try {
                latitude = Double.parseDouble(geoString.substring(0, semicolon));
                longitude = Double.parseDouble(geoString.substring(semicolon + 1));
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        try {
            return new CalendarParsedResult(summary, start2, end, duration, location, organizer, attendees, description2, latitude, longitude);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    private static String matchSingleVCardPrefixedField(CharSequence prefix, String rawText) {
        List<String> values2 = VCardResultParser.matchSingleVCardPrefixedField(prefix, rawText, true, false);
        return values2 == null || values2.isEmpty() ? null : values2.get(0);
    }

    private static String[] matchVCardPrefixedField(CharSequence prefix, String rawText) {
        List<List<String>> values2 = VCardResultParser.matchVCardPrefixedField(prefix, rawText, true, false);
        if (values2 == null || values2.isEmpty()) {
            return null;
        }
        int size = values2.size();
        String[] result2 = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            result2[i2] = values2.get(i2).get(0);
        }
        return result2;
    }

    private static String stripMailto(String s) {
        if (s != null && (s.startsWith("mailto:") || s.startsWith("MAILTO:"))) {
            s = s.substring(7);
        }
        return s;
    }
}

