/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;

public final class WifiParsedResult
extends ParsedResult {
    private final String ssid;
    private final String networkEncryption;
    private final String password;
    private final boolean hidden;
    private final String identity;
    private final String anonymousIdentity;
    private final String eapMethod;
    private final String phase2Method;

    public WifiParsedResult(String networkEncryption, String ssid, String password) {
        this(networkEncryption, ssid, password, false);
    }

    public WifiParsedResult(String networkEncryption, String ssid, String password, boolean hidden) {
        this(networkEncryption, ssid, password, hidden, null, null, null, null);
    }

    public WifiParsedResult(String networkEncryption, String ssid, String password, boolean hidden, String identity, String anonymousIdentity, String eapMethod, String phase2Method) {
        super(ParsedResultType.WIFI);
        this.ssid = ssid;
        this.networkEncryption = networkEncryption;
        this.password = password;
        this.hidden = hidden;
        this.identity = identity;
        this.anonymousIdentity = anonymousIdentity;
        this.eapMethod = eapMethod;
        this.phase2Method = phase2Method;
    }

    public String getSsid() {
        return this.ssid;
    }

    public String getNetworkEncryption() {
        return this.networkEncryption;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getAnonymousIdentity() {
        return this.anonymousIdentity;
    }

    public String getEapMethod() {
        return this.eapMethod;
    }

    public String getPhase2Method() {
        return this.phase2Method;
    }

    @Override
    public String getDisplayResult() {
        StringBuilder result2 = new StringBuilder(80);
        WifiParsedResult.maybeAppend(this.ssid, result2);
        WifiParsedResult.maybeAppend(this.networkEncryption, result2);
        WifiParsedResult.maybeAppend(this.password, result2);
        WifiParsedResult.maybeAppend(Boolean.toString(this.hidden), result2);
        return result2.toString();
    }
}

