/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource source2) {
        super(source2);
    }

    @Override
    public BitArray getBlackRow(int y, BitArray row2) throws NotFoundException {
        LuminanceSource source2 = this.getLuminanceSource();
        int width = source2.getWidth();
        if (row2 == null || row2.getSize() < width) {
            row2 = new BitArray(width);
        } else {
            row2.clear();
        }
        this.initArrays(width);
        byte[] localLuminances = source2.getRow(y, this.luminances);
        int[] localBuckets = this.buckets;
        for (int x = 0; x < width; ++x) {
            int n = (localLuminances[x] & 0xFF) >> 3;
            localBuckets[n] = localBuckets[n] + 1;
        }
        int blackPoint = GlobalHistogramBinarizer.estimateBlackPoint(localBuckets);
        if (width < 3) {
            for (int x = 0; x < width; ++x) {
                if ((localLuminances[x] & 0xFF) >= blackPoint) continue;
                row2.set(x);
            }
        } else {
            int left2 = localLuminances[0] & 0xFF;
            int center2 = localLuminances[1] & 0xFF;
            for (int x = 1; x < width - 1; ++x) {
                int right2 = localLuminances[x + 1] & 0xFF;
                if ((center2 * 4 - left2 - right2) / 2 < blackPoint) {
                    row2.set(x);
                }
                left2 = center2;
                center2 = right2;
            }
        }
        return row2;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        int pixel;
        int x;
        LuminanceSource source2 = this.getLuminanceSource();
        int width = source2.getWidth();
        int height = source2.getHeight();
        BitMatrix matrix = new BitMatrix(width, height);
        this.initArrays(width);
        int[] localBuckets = this.buckets;
        for (int y = 1; y < 5; ++y) {
            int row2 = height * y / 5;
            byte[] localLuminances = source2.getRow(row2, this.luminances);
            int right2 = width * 4 / 5;
            for (x = width / 5; x < right2; ++x) {
                pixel = localLuminances[x] & 0xFF;
                int n = pixel >> 3;
                localBuckets[n] = localBuckets[n] + 1;
            }
        }
        int blackPoint = GlobalHistogramBinarizer.estimateBlackPoint(localBuckets);
        byte[] localLuminances = source2.getMatrix();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (x = 0; x < width; ++x) {
                pixel = localLuminances[offset + x] & 0xFF;
                if (pixel >= blackPoint) continue;
                matrix.set(x, y);
            }
        }
        return matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource source2) {
        return new GlobalHistogramBinarizer(source2);
    }

    private void initArrays(int luminanceSize) {
        if (this.luminances.length < luminanceSize) {
            this.luminances = new byte[luminanceSize];
        }
        for (int x = 0; x < 32; ++x) {
            this.buckets[x] = 0;
        }
    }

    private static int estimateBlackPoint(int[] buckets) throws NotFoundException {
        int numBuckets = buckets.length;
        int maxBucketCount = 0;
        int firstPeak = 0;
        int firstPeakSize = 0;
        for (int x = 0; x < numBuckets; ++x) {
            if (buckets[x] > firstPeakSize) {
                firstPeak = x;
                firstPeakSize = buckets[x];
            }
            if (buckets[x] <= maxBucketCount) continue;
            maxBucketCount = buckets[x];
        }
        int secondPeak = 0;
        int secondPeakScore = 0;
        for (int x = 0; x < numBuckets; ++x) {
            int distanceToBiggest = x - firstPeak;
            int score = buckets[x] * distanceToBiggest * distanceToBiggest;
            if (score <= secondPeakScore) continue;
            secondPeak = x;
            secondPeakScore = score;
        }
        if (firstPeak > secondPeak) {
            int temp = firstPeak;
            firstPeak = secondPeak;
            secondPeak = temp;
        }
        if (secondPeak - firstPeak <= numBuckets / 16) {
            throw NotFoundException.getNotFoundInstance();
        }
        int bestValley = secondPeak - 1;
        int bestValleyScore = -1;
        for (int x = secondPeak - 1; x > firstPeak; --x) {
            int fromFirst = x - firstPeak;
            int score = fromFirst * fromFirst * (secondPeak - x) * (maxBucketCount - buckets[x]);
            if (score <= bestValleyScore) continue;
            bestValley = x;
            bestValleyScore = score;
        }
        return bestValley << 3;
    }
}

