/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;

@Deprecated
public final class MonochromeRectangleDetector {
    private static final int MAX_MODULES = 32;
    private final BitMatrix image;

    public MonochromeRectangleDetector(BitMatrix image) {
        this.image = image;
    }

    public ResultPoint[] detect() throws NotFoundException {
        int height = this.image.getHeight();
        int width = this.image.getWidth();
        int halfHeight = height / 2;
        int halfWidth = width / 2;
        int deltaY = Math.max(1, height / 256);
        int deltaX = Math.max(1, width / 256);
        int top2 = 0;
        int bottom2 = height;
        int left2 = 0;
        int right2 = width;
        ResultPoint pointA = this.findCornerFromCenter(halfWidth, 0, left2, right2, halfHeight, -deltaY, top2, bottom2, halfWidth / 2);
        top2 = (int)pointA.getY() - 1;
        ResultPoint pointB = this.findCornerFromCenter(halfWidth, -deltaX, left2, right2, halfHeight, 0, top2, bottom2, halfHeight / 2);
        left2 = (int)pointB.getX() - 1;
        ResultPoint pointC = this.findCornerFromCenter(halfWidth, deltaX, left2, right2, halfHeight, 0, top2, bottom2, halfHeight / 2);
        right2 = (int)pointC.getX() + 1;
        ResultPoint pointD = this.findCornerFromCenter(halfWidth, 0, left2, right2, halfHeight, deltaY, top2, bottom2, halfWidth / 2);
        bottom2 = (int)pointD.getY() + 1;
        pointA = this.findCornerFromCenter(halfWidth, 0, left2, right2, halfHeight, -deltaY, top2, bottom2, halfWidth / 4);
        return new ResultPoint[]{pointA, pointB, pointC, pointD};
    }

    private ResultPoint findCornerFromCenter(int centerX, int deltaX, int left2, int right2, int centerY, int deltaY, int top2, int bottom2, int maxWhiteRun) throws NotFoundException {
        int[] lastRange = null;
        int y = centerY;
        for (int x = centerX; y < bottom2 && y >= top2 && x < right2 && x >= left2; y += deltaY, x += deltaX) {
            int[] range = deltaX == 0 ? this.blackWhiteRange(y, maxWhiteRun, left2, right2, true) : this.blackWhiteRange(x, maxWhiteRun, top2, bottom2, false);
            if (range == null) {
                if (lastRange == null) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (deltaX == 0) {
                    int lastY = y - deltaY;
                    if (lastRange[0] < centerX) {
                        if (lastRange[1] > centerX) {
                            return new ResultPoint(lastRange[deltaY > 0 ? 0 : 1], lastY);
                        }
                        return new ResultPoint(lastRange[0], lastY);
                    }
                    return new ResultPoint(lastRange[1], lastY);
                }
                int lastX = x - deltaX;
                if (lastRange[0] < centerY) {
                    if (lastRange[1] > centerY) {
                        return new ResultPoint(lastX, lastRange[deltaX < 0 ? 0 : 1]);
                    }
                    return new ResultPoint(lastX, lastRange[0]);
                }
                return new ResultPoint(lastX, lastRange[1]);
            }
            lastRange = range;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private int[] blackWhiteRange(int fixedDimension, int maxWhiteRun, int minDim, int maxDim, boolean horizontal) {
        int[] nArray;
        int center2;
        int start2 = center2 = (minDim + maxDim) / 2;
        while (start2 >= minDim) {
            if (horizontal ? this.image.get(start2, fixedDimension) : this.image.get(fixedDimension, start2)) {
                --start2;
                continue;
            }
            int whiteRunStart = start2;
            while (--start2 >= minDim && !(horizontal ? this.image.get(start2, fixedDimension) : this.image.get(fixedDimension, start2))) {
            }
            int whiteRunSize = whiteRunStart - start2;
            if (start2 >= minDim && whiteRunSize <= maxWhiteRun) continue;
            start2 = whiteRunStart;
            break;
        }
        ++start2;
        int end = center2;
        while (end < maxDim) {
            if (horizontal ? this.image.get(end, fixedDimension) : this.image.get(fixedDimension, end)) {
                ++end;
                continue;
            }
            int whiteRunStart = end;
            while (++end < maxDim && !(horizontal ? this.image.get(end, fixedDimension) : this.image.get(fixedDimension, end))) {
            }
            int whiteRunSize = end - whiteRunStart;
            if (end < maxDim && whiteRunSize <= maxWhiteRun) continue;
            end = whiteRunStart;
            break;
        }
        if (--end > start2) {
            int[] nArray2 = new int[2];
            nArray2[0] = start2;
            nArray = nArray2;
            nArray2[1] = end;
        } else {
            nArray = null;
        }
        return nArray;
    }
}

