/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;

final class GenericGFPoly {
    private final GenericGF field;
    private final int[] coefficients;

    GenericGFPoly(GenericGF field2, int[] coefficients) {
        if (coefficients.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = field2;
        int coefficientsLength = coefficients.length;
        if (coefficientsLength > 1 && coefficients[0] == 0) {
            int firstNonZero;
            for (firstNonZero = 1; firstNonZero < coefficientsLength && coefficients[firstNonZero] == 0; ++firstNonZero) {
            }
            if (firstNonZero == coefficientsLength) {
                this.coefficients = new int[]{0};
            } else {
                this.coefficients = new int[coefficientsLength - firstNonZero];
                System.arraycopy(coefficients, firstNonZero, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = coefficients;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int degree) {
        return this.coefficients[this.coefficients.length - 1 - degree];
    }

    int evaluateAt(int a) {
        if (a == 0) {
            return this.getCoefficient(0);
        }
        if (a == 1) {
            int result2 = 0;
            for (int coefficient : this.coefficients) {
                result2 = GenericGF.addOrSubtract(result2, coefficient);
            }
            return result2;
        }
        int result3 = this.coefficients[0];
        int size = this.coefficients.length;
        for (int i2 = 1; i2 < size; ++i2) {
            result3 = GenericGF.addOrSubtract(this.field.multiply(a, result3), this.coefficients[i2]);
        }
        return result3;
    }

    GenericGFPoly addOrSubtract(GenericGFPoly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (this.isZero()) {
            return other;
        }
        if (other.isZero()) {
            return this;
        }
        int[] smallerCoefficients = this.coefficients;
        int[] largerCoefficients = other.coefficients;
        if (smallerCoefficients.length > largerCoefficients.length) {
            int[] temp = smallerCoefficients;
            smallerCoefficients = largerCoefficients;
            largerCoefficients = temp;
        }
        int[] sumDiff = new int[largerCoefficients.length];
        int lengthDiff = largerCoefficients.length - smallerCoefficients.length;
        System.arraycopy(largerCoefficients, 0, sumDiff, 0, lengthDiff);
        for (int i2 = lengthDiff; i2 < largerCoefficients.length; ++i2) {
            sumDiff[i2] = GenericGF.addOrSubtract(smallerCoefficients[i2 - lengthDiff], largerCoefficients[i2]);
        }
        return new GenericGFPoly(this.field, sumDiff);
    }

    GenericGFPoly multiply(GenericGFPoly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (this.isZero() || other.isZero()) {
            return this.field.getZero();
        }
        int[] aCoefficients = this.coefficients;
        int aLength = aCoefficients.length;
        int[] bCoefficients = other.coefficients;
        int bLength = bCoefficients.length;
        int[] product = new int[aLength + bLength - 1];
        for (int i2 = 0; i2 < aLength; ++i2) {
            int aCoeff = aCoefficients[i2];
            for (int j = 0; j < bLength; ++j) {
                product[i2 + j] = GenericGF.addOrSubtract(product[i2 + j], this.field.multiply(aCoeff, bCoefficients[j]));
            }
        }
        return new GenericGFPoly(this.field, product);
    }

    GenericGFPoly multiply(int scalar) {
        if (scalar == 0) {
            return this.field.getZero();
        }
        if (scalar == 1) {
            return this;
        }
        int size = this.coefficients.length;
        int[] product = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            product[i2] = this.field.multiply(this.coefficients[i2], scalar);
        }
        return new GenericGFPoly(this.field, product);
    }

    GenericGFPoly multiplyByMonomial(int degree, int coefficient) {
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.field.getZero();
        }
        int size = this.coefficients.length;
        int[] product = new int[size + degree];
        for (int i2 = 0; i2 < size; ++i2) {
            product[i2] = this.field.multiply(this.coefficients[i2], coefficient);
        }
        return new GenericGFPoly(this.field, product);
    }

    GenericGFPoly[] divide(GenericGFPoly other) {
        if (!this.field.equals(other.field)) {
            throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
        }
        if (other.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        GenericGFPoly quotient = this.field.getZero();
        GenericGFPoly remainder = this;
        int denominatorLeadingTerm = other.getCoefficient(other.getDegree());
        int inverseDenominatorLeadingTerm = this.field.inverse(denominatorLeadingTerm);
        while (remainder.getDegree() >= other.getDegree() && !remainder.isZero()) {
            int degreeDifference = remainder.getDegree() - other.getDegree();
            int scale2 = this.field.multiply(remainder.getCoefficient(remainder.getDegree()), inverseDenominatorLeadingTerm);
            GenericGFPoly term = other.multiplyByMonomial(degreeDifference, scale2);
            GenericGFPoly iterationQuotient = this.field.buildMonomial(degreeDifference, scale2);
            quotient = quotient.addOrSubtract(iterationQuotient);
            remainder = remainder.addOrSubtract(term);
        }
        return new GenericGFPoly[]{quotient, remainder};
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuilder result2 = new StringBuilder(8 * this.getDegree());
        for (int degree = this.getDegree(); degree >= 0; --degree) {
            int coefficient = this.getCoefficient(degree);
            if (coefficient == 0) continue;
            if (coefficient < 0) {
                if (degree == this.getDegree()) {
                    result2.append("-");
                } else {
                    result2.append(" - ");
                }
                coefficient = -coefficient;
            } else if (result2.length() > 0) {
                result2.append(" + ");
            }
            if (degree == 0 || coefficient != 1) {
                int alphaPower = this.field.log(coefficient);
                if (alphaPower == 0) {
                    result2.append('1');
                } else if (alphaPower == 1) {
                    result2.append('a');
                } else {
                    result2.append("a^");
                    result2.append(alphaPower);
                }
            }
            if (degree == 0) continue;
            if (degree == 1) {
                result2.append('x');
                continue;
            }
            result2.append("x^");
            result2.append(degree);
        }
        return result2.toString();
    }
}

