/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.GenericGFPoly;
import com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class ReedSolomonDecoder {
    private final GenericGF field;

    public ReedSolomonDecoder(GenericGF field2) {
        this.field = field2;
    }

    public void decode(int[] received, int twoS) throws ReedSolomonException {
        GenericGFPoly poly = new GenericGFPoly(this.field, received);
        int[] syndromeCoefficients = new int[twoS];
        boolean noError = true;
        for (int i2 = 0; i2 < twoS; ++i2) {
            int eval;
            syndromeCoefficients[syndromeCoefficients.length - 1 - i2] = eval = poly.evaluateAt(this.field.exp(i2 + this.field.getGeneratorBase()));
            if (eval == 0) continue;
            noError = false;
        }
        if (noError) {
            return;
        }
        GenericGFPoly syndrome = new GenericGFPoly(this.field, syndromeCoefficients);
        GenericGFPoly[] sigmaOmega = this.runEuclideanAlgorithm(this.field.buildMonomial(twoS, 1), syndrome, twoS);
        GenericGFPoly sigma = sigmaOmega[0];
        GenericGFPoly omega = sigmaOmega[1];
        int[] errorLocations = this.findErrorLocations(sigma);
        int[] errorMagnitudes = this.findErrorMagnitudes(omega, errorLocations);
        for (int i3 = 0; i3 < errorLocations.length; ++i3) {
            int position = received.length - 1 - this.field.log(errorLocations[i3]);
            if (position < 0) {
                throw new ReedSolomonException("Bad error location");
            }
            received[position] = GenericGF.addOrSubtract(received[position], errorMagnitudes[i3]);
        }
    }

    private GenericGFPoly[] runEuclideanAlgorithm(GenericGFPoly a, GenericGFPoly b, int R) throws ReedSolomonException {
        if (a.getDegree() < b.getDegree()) {
            GenericGFPoly temp = a;
            a = b;
            b = temp;
        }
        GenericGFPoly rLast = a;
        GenericGFPoly r = b;
        GenericGFPoly tLast = this.field.getZero();
        GenericGFPoly t = this.field.getOne();
        while (2 * r.getDegree() >= R) {
            GenericGFPoly rLastLast = rLast;
            GenericGFPoly tLastLast = tLast;
            rLast = r;
            tLast = t;
            if (rLast.isZero()) {
                throw new ReedSolomonException("r_{i-1} was zero");
            }
            r = rLastLast;
            GenericGFPoly q = this.field.getZero();
            int denominatorLeadingTerm = rLast.getCoefficient(rLast.getDegree());
            int dltInverse = this.field.inverse(denominatorLeadingTerm);
            while (r.getDegree() >= rLast.getDegree() && !r.isZero()) {
                int degreeDiff = r.getDegree() - rLast.getDegree();
                int scale2 = this.field.multiply(r.getCoefficient(r.getDegree()), dltInverse);
                q = q.addOrSubtract(this.field.buildMonomial(degreeDiff, scale2));
                r = r.addOrSubtract(rLast.multiplyByMonomial(degreeDiff, scale2));
            }
            t = q.multiply(tLast).addOrSubtract(tLastLast);
            if (r.getDegree() < rLast.getDegree()) continue;
            throw new IllegalStateException("Division algorithm failed to reduce polynomial? r: " + r + ", rLast: " + rLast);
        }
        int sigmaTildeAtZero = t.getCoefficient(0);
        if (sigmaTildeAtZero == 0) {
            throw new ReedSolomonException("sigmaTilde(0) was zero");
        }
        int inverse = this.field.inverse(sigmaTildeAtZero);
        GenericGFPoly sigma = t.multiply(inverse);
        GenericGFPoly omega = r.multiply(inverse);
        return new GenericGFPoly[]{sigma, omega};
    }

    private int[] findErrorLocations(GenericGFPoly errorLocator) throws ReedSolomonException {
        int numErrors = errorLocator.getDegree();
        if (numErrors == 1) {
            return new int[]{errorLocator.getCoefficient(1)};
        }
        int[] result2 = new int[numErrors];
        int e = 0;
        for (int i2 = 1; i2 < this.field.getSize() && e < numErrors; ++i2) {
            if (errorLocator.evaluateAt(i2) != 0) continue;
            result2[e] = this.field.inverse(i2);
            ++e;
        }
        if (e != numErrors) {
            throw new ReedSolomonException("Error locator degree does not match number of roots");
        }
        return result2;
    }

    private int[] findErrorMagnitudes(GenericGFPoly errorEvaluator, int[] errorLocations) {
        int s = errorLocations.length;
        int[] result2 = new int[s];
        for (int i2 = 0; i2 < s; ++i2) {
            int xiInverse = this.field.inverse(errorLocations[i2]);
            int denominator = 1;
            for (int j = 0; j < s; ++j) {
                if (i2 == j) continue;
                int term = this.field.multiply(errorLocations[j], xiInverse);
                int termPlus1 = (term & 1) == 0 ? term | 1 : term & 0xFFFFFFFE;
                denominator = this.field.multiply(denominator, termPlus1);
            }
            result2[i2] = this.field.multiply(errorEvaluator.evaluateAt(xiInverse), this.field.inverse(denominator));
            if (this.field.getGeneratorBase() == 0) continue;
            result2[i2] = this.field.multiply(result2[i2], xiInverse);
        }
        return result2;
    }
}

