/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.ECIStringBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT2_SET_CHARS = C40_SHIFT2_SET_CHARS;
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] bytes) throws FormatException {
        BitSource bits = new BitSource(bytes);
        ECIStringBuilder result2 = new ECIStringBuilder(100);
        StringBuilder resultTrailer = new StringBuilder(0);
        ArrayList<byte[]> byteSegments = new ArrayList<byte[]>(1);
        Mode mode = Mode.ASCII_ENCODE;
        HashSet<Integer> fnc1Positions = new HashSet<Integer>();
        boolean isECIencoded = false;
        do {
            if (mode == Mode.ASCII_ENCODE) {
                mode = DecodedBitStreamParser.decodeAsciiSegment(bits, result2, resultTrailer, fnc1Positions);
                continue;
            }
            switch (mode) {
                case C40_ENCODE: {
                    DecodedBitStreamParser.decodeC40Segment(bits, result2, fnc1Positions);
                    break;
                }
                case TEXT_ENCODE: {
                    DecodedBitStreamParser.decodeTextSegment(bits, result2, fnc1Positions);
                    break;
                }
                case ANSIX12_ENCODE: {
                    DecodedBitStreamParser.decodeAnsiX12Segment(bits, result2);
                    break;
                }
                case EDIFACT_ENCODE: {
                    DecodedBitStreamParser.decodeEdifactSegment(bits, result2);
                    break;
                }
                case BASE256_ENCODE: {
                    DecodedBitStreamParser.decodeBase256Segment(bits, result2, byteSegments);
                    break;
                }
                case ECI_ENCODE: {
                    DecodedBitStreamParser.decodeECISegment(bits, result2);
                    isECIencoded = true;
                    break;
                }
                default: {
                    throw FormatException.getFormatInstance();
                }
            }
            mode = Mode.ASCII_ENCODE;
        } while (mode != Mode.PAD_ENCODE && bits.available() > 0);
        if (resultTrailer.length() > 0) {
            result2.appendCharacters(resultTrailer);
        }
        int symbologyModifier = isECIencoded ? (fnc1Positions.contains(0) || fnc1Positions.contains(4) ? 5 : (fnc1Positions.contains(1) || fnc1Positions.contains(5) ? 6 : 4)) : (fnc1Positions.contains(0) || fnc1Positions.contains(4) ? 2 : (fnc1Positions.contains(1) || fnc1Positions.contains(5) ? 3 : 1));
        return new DecoderResult(bytes, result2.toString(), byteSegments.isEmpty() ? null : byteSegments, null, symbologyModifier);
    }

    private static Mode decodeAsciiSegment(BitSource bits, ECIStringBuilder result2, StringBuilder resultTrailer, Set<Integer> fnc1positions) throws FormatException {
        boolean upperShift = false;
        block13: do {
            int oneByte;
            if ((oneByte = bits.readBits(8)) == 0) {
                throw FormatException.getFormatInstance();
            }
            if (oneByte <= 128) {
                if (upperShift) {
                    oneByte += 128;
                }
                result2.append((char)(oneByte - 1));
                return Mode.ASCII_ENCODE;
            }
            if (oneByte == 129) {
                return Mode.PAD_ENCODE;
            }
            if (oneByte <= 229) {
                int value = oneByte - 130;
                if (value < 10) {
                    result2.append('0');
                }
                result2.append(value);
                continue;
            }
            switch (oneByte) {
                case 230: {
                    return Mode.C40_ENCODE;
                }
                case 231: {
                    return Mode.BASE256_ENCODE;
                }
                case 232: {
                    fnc1positions.add(result2.length());
                    result2.append('\u001d');
                    break;
                }
                case 233: 
                case 234: {
                    break;
                }
                case 235: {
                    upperShift = true;
                    break;
                }
                case 236: {
                    result2.append("[)>\u001e05\u001d");
                    resultTrailer.insert(0, "\u001e\u0004");
                    break;
                }
                case 237: {
                    result2.append("[)>\u001e06\u001d");
                    resultTrailer.insert(0, "\u001e\u0004");
                    break;
                }
                case 238: {
                    return Mode.ANSIX12_ENCODE;
                }
                case 239: {
                    return Mode.TEXT_ENCODE;
                }
                case 240: {
                    return Mode.EDIFACT_ENCODE;
                }
                case 241: {
                    return Mode.ECI_ENCODE;
                }
                default: {
                    if (oneByte == 254 && bits.available() == 0) continue block13;
                    throw FormatException.getFormatInstance();
                }
            }
        } while (bits.available() > 0);
        return Mode.ASCII_ENCODE;
    }

    private static void decodeC40Segment(BitSource bits, ECIStringBuilder result2, Set<Integer> fnc1positions) throws FormatException {
        boolean upperShift = false;
        int[] cValues = new int[3];
        int shift = 0;
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            block11: for (int i2 = 0; i2 < 3; ++i2) {
                int cValue = cValues[i2];
                switch (shift) {
                    case 0: {
                        char c40char;
                        if (cValue < 3) {
                            shift = cValue + 1;
                            continue block11;
                        }
                        if (cValue < C40_BASIC_SET_CHARS.length) {
                            c40char = C40_BASIC_SET_CHARS[cValue];
                            if (upperShift) {
                                result2.append((char)(c40char + 128));
                                upperShift = false;
                                continue block11;
                            }
                            result2.append(c40char);
                            continue block11;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (upperShift) {
                            result2.append((char)(cValue + 128));
                            upperShift = false;
                        } else {
                            result2.append((char)cValue);
                        }
                        shift = 0;
                        continue block11;
                    }
                    case 2: {
                        char c40char;
                        if (cValue < C40_SHIFT2_SET_CHARS.length) {
                            c40char = C40_SHIFT2_SET_CHARS[cValue];
                            if (upperShift) {
                                result2.append((char)(c40char + 128));
                                upperShift = false;
                            } else {
                                result2.append(c40char);
                            }
                        } else {
                            switch (cValue) {
                                case 27: {
                                    fnc1positions.add(result2.length());
                                    result2.append('\u001d');
                                    break;
                                }
                                case 30: {
                                    upperShift = true;
                                    break;
                                }
                                default: {
                                    throw FormatException.getFormatInstance();
                                }
                            }
                        }
                        shift = 0;
                        continue block11;
                    }
                    case 3: {
                        if (upperShift) {
                            result2.append((char)(cValue + 224));
                            upperShift = false;
                        } else {
                            result2.append((char)(cValue + 96));
                        }
                        shift = 0;
                        continue block11;
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bits.available() > 0);
    }

    private static void decodeTextSegment(BitSource bits, ECIStringBuilder result2, Set<Integer> fnc1positions) throws FormatException {
        boolean upperShift = false;
        int[] cValues = new int[3];
        int shift = 0;
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            block11: for (int i2 = 0; i2 < 3; ++i2) {
                int cValue = cValues[i2];
                switch (shift) {
                    case 0: {
                        char textChar;
                        if (cValue < 3) {
                            shift = cValue + 1;
                            continue block11;
                        }
                        if (cValue < TEXT_BASIC_SET_CHARS.length) {
                            textChar = TEXT_BASIC_SET_CHARS[cValue];
                            if (upperShift) {
                                result2.append((char)(textChar + 128));
                                upperShift = false;
                                continue block11;
                            }
                            result2.append(textChar);
                            continue block11;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (upperShift) {
                            result2.append((char)(cValue + 128));
                            upperShift = false;
                        } else {
                            result2.append((char)cValue);
                        }
                        shift = 0;
                        continue block11;
                    }
                    case 2: {
                        char textChar;
                        if (cValue < TEXT_SHIFT2_SET_CHARS.length) {
                            textChar = TEXT_SHIFT2_SET_CHARS[cValue];
                            if (upperShift) {
                                result2.append((char)(textChar + 128));
                                upperShift = false;
                            } else {
                                result2.append(textChar);
                            }
                        } else {
                            switch (cValue) {
                                case 27: {
                                    fnc1positions.add(result2.length());
                                    result2.append('\u001d');
                                    break;
                                }
                                case 30: {
                                    upperShift = true;
                                    break;
                                }
                                default: {
                                    throw FormatException.getFormatInstance();
                                }
                            }
                        }
                        shift = 0;
                        continue block11;
                    }
                    case 3: {
                        char textChar;
                        if (cValue < TEXT_SHIFT3_SET_CHARS.length) {
                            textChar = TEXT_SHIFT3_SET_CHARS[cValue];
                            if (upperShift) {
                                result2.append((char)(textChar + 128));
                                upperShift = false;
                            } else {
                                result2.append(textChar);
                            }
                            shift = 0;
                            continue block11;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bits.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bits, ECIStringBuilder result2) throws FormatException {
        int[] cValues = new int[3];
        do {
            if (bits.available() == 8) {
                return;
            }
            int firstByte = bits.readBits(8);
            if (firstByte == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(firstByte, bits.readBits(8), cValues);
            block7: for (int i2 = 0; i2 < 3; ++i2) {
                int cValue = cValues[i2];
                switch (cValue) {
                    case 0: {
                        result2.append('\r');
                        continue block7;
                    }
                    case 1: {
                        result2.append('*');
                        continue block7;
                    }
                    case 2: {
                        result2.append('>');
                        continue block7;
                    }
                    case 3: {
                        result2.append(' ');
                        continue block7;
                    }
                    default: {
                        if (cValue < 14) {
                            result2.append((char)(cValue + 44));
                            continue block7;
                        }
                        if (cValue < 40) {
                            result2.append((char)(cValue + 51));
                            continue block7;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
            }
        } while (bits.available() > 0);
    }

    private static void parseTwoBytes(int firstByte, int secondByte, int[] result2) {
        int temp;
        int fullBitValue = (firstByte << 8) + secondByte - 1;
        result2[0] = temp = fullBitValue / 1600;
        fullBitValue -= temp * 1600;
        result2[1] = temp = fullBitValue / 40;
        result2[2] = fullBitValue - temp * 40;
    }

    private static void decodeEdifactSegment(BitSource bits, ECIStringBuilder result2) {
        do {
            if (bits.available() <= 16) {
                return;
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                int edifactValue = bits.readBits(6);
                if (edifactValue == 31) {
                    int bitsLeft = 8 - bits.getBitOffset();
                    if (bitsLeft != 8) {
                        bits.readBits(bitsLeft);
                    }
                    return;
                }
                if ((edifactValue & 0x20) == 0) {
                    edifactValue |= 0x40;
                }
                result2.append((char)edifactValue);
            }
        } while (bits.available() > 0);
    }

    private static void decodeBase256Segment(BitSource bits, ECIStringBuilder result2, Collection<byte[]> byteSegments) throws FormatException {
        int codewordPosition = 1 + bits.getByteOffset();
        int d1 = DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++);
        int count = d1 == 0 ? bits.available() / 8 : (d1 < 250 ? d1 : 250 * (d1 - 249) + DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++));
        if (count < 0) {
            throw FormatException.getFormatInstance();
        }
        byte[] bytes = new byte[count];
        for (int i2 = 0; i2 < count; ++i2) {
            if (bits.available() < 8) {
                throw FormatException.getFormatInstance();
            }
            bytes[i2] = (byte)DecodedBitStreamParser.unrandomize255State(bits.readBits(8), codewordPosition++);
        }
        byteSegments.add(bytes);
        result2.append(new String(bytes, StandardCharsets.ISO_8859_1));
    }

    private static void decodeECISegment(BitSource bits, ECIStringBuilder result2) throws FormatException {
        if (bits.available() < 8) {
            throw FormatException.getFormatInstance();
        }
        int c1 = bits.readBits(8);
        if (c1 <= 127) {
            result2.appendECI(c1 - 1);
        }
    }

    private static int unrandomize255State(int randomizedBase256Codeword, int base256CodewordPosition) {
        int pseudoRandomNumber = 149 * base256CodewordPosition % 255 + 1;
        int tempVariable = randomizedBase256Codeword - pseudoRandomNumber;
        return tempVariable >= 0 ? tempVariable : tempVariable + 256;
    }

    private static enum Mode {
        PAD_ENCODE,
        ASCII_ENCODE,
        C40_ENCODE,
        TEXT_ENCODE,
        ANSIX12_ENCODE,
        EDIFACT_ENCODE,
        BASE256_ENCODE,
        ECI_ENCODE;

    }
}

