/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.ArrayList;
import java.util.Map;

public final class Code128Reader
extends OneDReader {
    static final int[][] CODE_PATTERNS = new int[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}, {2, 3, 3, 1, 1, 1, 2}};
    private static final float MAX_AVG_VARIANCE = 0.25f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.7f;
    private static final int CODE_SHIFT = 98;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_A = 101;
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_STOP = 106;

    private static int[] findStartPattern(BitArray row2) throws NotFoundException {
        int width = row2.getSize();
        int rowOffset = row2.getNextSet(0);
        int counterPosition = 0;
        int[] counters = new int[6];
        int patternStart = rowOffset;
        boolean isWhite = false;
        int patternLength = counters.length;
        for (int i2 = rowOffset; i2 < width; ++i2) {
            if (row2.get(i2) != isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                float bestVariance = 0.25f;
                int bestMatch = -1;
                for (int startCode = 103; startCode <= 105; ++startCode) {
                    float variance = Code128Reader.patternMatchVariance(counters, CODE_PATTERNS[startCode], 0.7f);
                    if (!(variance < bestVariance)) continue;
                    bestVariance = variance;
                    bestMatch = startCode;
                }
                if (bestMatch >= 0 && row2.isRange(Math.max(0, patternStart - (i2 - patternStart) / 2), patternStart, false)) {
                    return new int[]{patternStart, i2, bestMatch};
                }
                patternStart += counters[0] + counters[1];
                System.arraycopy(counters, 2, counters, 0, counterPosition - 1);
                counters[counterPosition - 1] = 0;
                counters[counterPosition] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite = !isWhite;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeCode(BitArray row2, int[] counters, int rowOffset) throws NotFoundException {
        Code128Reader.recordPattern(row2, rowOffset, counters);
        float bestVariance = 0.25f;
        int bestMatch = -1;
        for (int d = 0; d < CODE_PATTERNS.length; ++d) {
            int[] pattern = CODE_PATTERNS[d];
            float variance = Code128Reader.patternMatchVariance(counters, pattern, 0.7f);
            if (!(variance < bestVariance)) continue;
            bestVariance = variance;
            bestMatch = d;
        }
        if (bestMatch >= 0) {
            return bestMatch;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row2, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException, ChecksumException {
        int codeSet;
        boolean convertFNC1 = hints != null && hints.containsKey((Object)DecodeHintType.ASSUME_GS1);
        int symbologyModifier = 0;
        int[] startPatternInfo = Code128Reader.findStartPattern(row2);
        int startCode = startPatternInfo[2];
        ArrayList<Byte> rawCodes = new ArrayList<Byte>(20);
        rawCodes.add((byte)startCode);
        switch (startCode) {
            case 103: {
                codeSet = 101;
                break;
            }
            case 104: {
                codeSet = 100;
                break;
            }
            case 105: {
                codeSet = 99;
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        boolean done = false;
        boolean isNextShifted = false;
        StringBuilder result2 = new StringBuilder(20);
        int lastStart = startPatternInfo[0];
        int nextStart = startPatternInfo[1];
        int[] counters = new int[6];
        int lastCode = 0;
        int code = 0;
        int checksumTotal = startCode;
        int multiplier = 0;
        boolean lastCharacterWasPrintable = true;
        boolean upperMode = false;
        boolean shiftUpperMode = false;
        while (!done) {
            boolean unshift;
            block81: {
                unshift = isNextShifted;
                isNextShifted = false;
                lastCode = code;
                code = Code128Reader.decodeCode(row2, counters, nextStart);
                rawCodes.add((byte)code);
                if (code != 106) {
                    lastCharacterWasPrintable = true;
                }
                if (code != 106) {
                    checksumTotal += ++multiplier * code;
                }
                lastStart = nextStart;
                for (int counter : counters) {
                    nextStart += counter;
                }
                switch (code) {
                    case 103: 
                    case 104: 
                    case 105: {
                        throw FormatException.getFormatInstance();
                    }
                }
                block8 : switch (codeSet) {
                    case 101: {
                        if (code < 64) {
                            if (shiftUpperMode == upperMode) {
                                result2.append((char)(32 + code));
                            } else {
                                result2.append((char)(32 + code + 128));
                            }
                            shiftUpperMode = false;
                            break;
                        }
                        if (code < 96) {
                            if (shiftUpperMode == upperMode) {
                                result2.append((char)(code - 64));
                            } else {
                                result2.append((char)(code + 64));
                            }
                            shiftUpperMode = false;
                            break;
                        }
                        if (code != 106) {
                            lastCharacterWasPrintable = false;
                        }
                        switch (code) {
                            case 102: {
                                if (result2.length() == 0) {
                                    symbologyModifier = 1;
                                } else if (result2.length() == 1) {
                                    symbologyModifier = 2;
                                }
                                if (!convertFNC1) break;
                                if (result2.length() == 0) {
                                    result2.append("]C1");
                                    break;
                                }
                                result2.append('\u001d');
                                break;
                            }
                            case 97: {
                                symbologyModifier = 4;
                                break;
                            }
                            case 96: {
                                break;
                            }
                            case 101: {
                                if (!upperMode && shiftUpperMode) {
                                    upperMode = true;
                                    shiftUpperMode = false;
                                    break;
                                }
                                if (upperMode && shiftUpperMode) {
                                    upperMode = false;
                                    shiftUpperMode = false;
                                    break;
                                }
                                shiftUpperMode = true;
                                break;
                            }
                            case 98: {
                                isNextShifted = true;
                                codeSet = 100;
                                break;
                            }
                            case 100: {
                                codeSet = 100;
                                break;
                            }
                            case 99: {
                                codeSet = 99;
                                break;
                            }
                            case 106: {
                                done = true;
                            }
                        }
                        break;
                    }
                    case 100: {
                        if (code < 96) {
                            if (shiftUpperMode == upperMode) {
                                result2.append((char)(32 + code));
                            } else {
                                result2.append((char)(32 + code + 128));
                            }
                            shiftUpperMode = false;
                            break;
                        }
                        if (code != 106) {
                            lastCharacterWasPrintable = false;
                        }
                        switch (code) {
                            case 102: {
                                if (result2.length() == 0) {
                                    symbologyModifier = 1;
                                } else if (result2.length() == 1) {
                                    symbologyModifier = 2;
                                }
                                if (!convertFNC1) break;
                                if (result2.length() == 0) {
                                    result2.append("]C1");
                                    break;
                                }
                                result2.append('\u001d');
                                break;
                            }
                            case 97: {
                                symbologyModifier = 4;
                                break;
                            }
                            case 96: {
                                break;
                            }
                            case 100: {
                                if (!upperMode && shiftUpperMode) {
                                    upperMode = true;
                                    shiftUpperMode = false;
                                    break;
                                }
                                if (upperMode && shiftUpperMode) {
                                    upperMode = false;
                                    shiftUpperMode = false;
                                    break;
                                }
                                shiftUpperMode = true;
                                break;
                            }
                            case 98: {
                                isNextShifted = true;
                                codeSet = 101;
                                break;
                            }
                            case 101: {
                                codeSet = 101;
                                break;
                            }
                            case 99: {
                                codeSet = 99;
                                break;
                            }
                            case 106: {
                                done = true;
                            }
                        }
                        break;
                    }
                    case 99: {
                        if (code < 100) {
                            if (code < 10) {
                                result2.append('0');
                            }
                            result2.append(code);
                            break;
                        }
                        if (code != 106) {
                            lastCharacterWasPrintable = false;
                        }
                        switch (code) {
                            case 102: {
                                if (result2.length() == 0) {
                                    symbologyModifier = 1;
                                } else if (result2.length() == 1) {
                                    symbologyModifier = 2;
                                }
                                if (convertFNC1) {
                                    if (result2.length() == 0) {
                                        result2.append("]C1");
                                        break block8;
                                    }
                                    result2.append('\u001d');
                                    break block8;
                                }
                                break block81;
                            }
                            case 101: {
                                codeSet = 101;
                                break block8;
                            }
                            case 100: {
                                codeSet = 100;
                                break block8;
                            }
                            case 106: {
                                done = true;
                            }
                        }
                    }
                }
            }
            if (!unshift) continue;
            codeSet = codeSet == 101 ? 100 : 101;
        }
        int lastPatternSize = nextStart - lastStart;
        if (!row2.isRange(nextStart = row2.getNextUnset(nextStart), Math.min(row2.getSize(), nextStart + (nextStart - lastStart) / 2), false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((checksumTotal -= multiplier * lastCode) % 103 != lastCode) {
            throw ChecksumException.getChecksumInstance();
        }
        int resultLength = result2.length();
        if (resultLength == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (resultLength > 0 && lastCharacterWasPrintable) {
            if (codeSet == 99) {
                result2.delete(resultLength - 2, resultLength);
            } else {
                result2.delete(resultLength - 1, resultLength);
            }
        }
        float left2 = (float)(startPatternInfo[1] + startPatternInfo[0]) / 2.0f;
        float right2 = (float)lastStart + (float)lastPatternSize / 2.0f;
        int rawCodesSize = rawCodes.size();
        byte[] rawBytes = new byte[rawCodesSize];
        for (int i2 = 0; i2 < rawCodesSize; ++i2) {
            rawBytes[i2] = (Byte)rawCodes.get(i2);
        }
        Result resultObject = new Result(result2.toString(), rawBytes, new ResultPoint[]{new ResultPoint(left2, rowNumber), new ResultPoint(right2, rowNumber)}, BarcodeFormat.CODE_128);
        resultObject.putMetadata(ResultMetadataType.SYMBOLOGY_IDENTIFIER, "]C" + symbologyModifier);
        return resultObject;
    }
}

