/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_A = 101;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;

    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.CODE_128);
    }

    @Override
    public boolean[] encode(String contents) {
        return this.encode(contents, null);
    }

    @Override
    protected boolean[] encode(String contents, Map<EncodeHintType, ?> hints) {
        int forcedCodeSet = Code128Writer.check(contents, hints);
        boolean hasCompactionHint = hints != null && hints.containsKey((Object)EncodeHintType.CODE128_COMPACT) && Boolean.parseBoolean(hints.get((Object)EncodeHintType.CODE128_COMPACT).toString());
        return hasCompactionHint ? new MinimalEncoder().encode(contents) : Code128Writer.encodeFast(contents, forcedCodeSet);
    }

    private static int check(String contents, Map<EncodeHintType, ?> hints) {
        int length = contents.length();
        if (length < 1 || length > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + length);
        }
        int forcedCodeSet = -1;
        if (hints != null && hints.containsKey((Object)EncodeHintType.FORCE_CODE_SET)) {
            String codeSetHint;
            switch (codeSetHint = hints.get((Object)EncodeHintType.FORCE_CODE_SET).toString()) {
                case "A": {
                    forcedCodeSet = 101;
                    break;
                }
                case "B": {
                    forcedCodeSet = 100;
                    break;
                }
                case "C": {
                    forcedCodeSet = 99;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported code set hint: " + codeSetHint);
                }
            }
        }
        block18: for (int i2 = 0; i2 < length; ++i2) {
            char c = contents.charAt(i2);
            switch (c) {
                case '\u00f1': 
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': {
                    break;
                }
                default: {
                    if (c <= '\u007f') break;
                    throw new IllegalArgumentException("Bad character in input: ASCII value=" + c);
                }
            }
            switch (forcedCodeSet) {
                case 101: {
                    if (c <= '_' || c > '\u007f') continue block18;
                    throw new IllegalArgumentException("Bad character in input for forced code set A: ASCII value=" + c);
                }
                case 100: {
                    if (c > ' ') continue block18;
                    throw new IllegalArgumentException("Bad character in input for forced code set B: ASCII value=" + c);
                }
                case 99: {
                    if (c >= '0' && (c <= '9' || c > '\u007f') && c != '\u00f2' && c != '\u00f3' && c != '\u00f4') continue block18;
                    throw new IllegalArgumentException("Bad character in input for forced code set C: ASCII value=" + c);
                }
            }
        }
        return forcedCodeSet;
    }

    private static boolean[] encodeFast(String contents, int forcedCodeSet) {
        int length = contents.length();
        ArrayList<int[]> patterns = new ArrayList<int[]>();
        int checkSum = 0;
        int checkWeight = 1;
        int codeSet = 0;
        int position = 0;
        while (position < length) {
            int patternIndex;
            int newCodeSet = forcedCodeSet == -1 ? Code128Writer.chooseCode(contents, position, codeSet) : forcedCodeSet;
            if (newCodeSet == codeSet) {
                block0 : switch (contents.charAt(position)) {
                    case '\u00f1': {
                        patternIndex = 102;
                        break;
                    }
                    case '\u00f2': {
                        patternIndex = 97;
                        break;
                    }
                    case '\u00f3': {
                        patternIndex = 96;
                        break;
                    }
                    case '\u00f4': {
                        if (codeSet == 101) {
                            patternIndex = 101;
                            break;
                        }
                        patternIndex = 100;
                        break;
                    }
                    default: {
                        switch (codeSet) {
                            case 101: {
                                patternIndex = contents.charAt(position) - 32;
                                if (patternIndex >= 0) break block0;
                                patternIndex += 96;
                                break block0;
                            }
                            case 100: {
                                patternIndex = contents.charAt(position) - 32;
                                break block0;
                            }
                            default: {
                                if (position + 1 == length) {
                                    throw new IllegalArgumentException("Bad number of characters for digit only encoding.");
                                }
                                patternIndex = Integer.parseInt(contents.substring(position, position + 2));
                                ++position;
                            }
                        }
                    }
                }
                ++position;
            } else {
                if (codeSet == 0) {
                    switch (newCodeSet) {
                        case 101: {
                            patternIndex = 103;
                            break;
                        }
                        case 100: {
                            patternIndex = 104;
                            break;
                        }
                        default: {
                            patternIndex = 105;
                            break;
                        }
                    }
                } else {
                    patternIndex = newCodeSet;
                }
                codeSet = newCodeSet;
            }
            patterns.add(Code128Reader.CODE_PATTERNS[patternIndex]);
            checkSum += patternIndex * checkWeight;
            if (position == 0) continue;
            ++checkWeight;
        }
        return Code128Writer.produceResult(patterns, checkSum);
    }

    static boolean[] produceResult(Collection<int[]> patterns, int checkSum) {
        patterns.add(Code128Reader.CODE_PATTERNS[checkSum %= 103]);
        patterns.add(Code128Reader.CODE_PATTERNS[106]);
        int codeWidth = 0;
        for (int[] pattern : patterns) {
            for (int width : pattern) {
                codeWidth += width;
            }
        }
        boolean[] result2 = new boolean[codeWidth];
        int pos = 0;
        Object object = patterns.iterator();
        while (object.hasNext()) {
            int[] pattern = (int[])object.next();
            pos += Code128Writer.appendPattern(result2, pos, pattern, true);
        }
        return result2;
    }

    private static CType findCType(CharSequence value, int start2) {
        int last = value.length();
        if (start2 >= last) {
            return CType.UNCODABLE;
        }
        char c = value.charAt(start2);
        if (c == '\u00f1') {
            return CType.FNC_1;
        }
        if (c < '0' || c > '9') {
            return CType.UNCODABLE;
        }
        if (start2 + 1 >= last) {
            return CType.ONE_DIGIT;
        }
        c = value.charAt(start2 + 1);
        if (c < '0' || c > '9') {
            return CType.ONE_DIGIT;
        }
        return CType.TWO_DIGITS;
    }

    private static int chooseCode(CharSequence value, int start2, int oldCode) {
        CType lookahead = Code128Writer.findCType(value, start2);
        if (lookahead == CType.ONE_DIGIT) {
            if (oldCode == 101) {
                return 101;
            }
            return 100;
        }
        if (lookahead == CType.UNCODABLE) {
            char c;
            if (start2 < value.length() && ((c = value.charAt(start2)) < ' ' || oldCode == 101 && (c < '`' || c >= '\u00f1' && c <= '\u00f4'))) {
                return 101;
            }
            return 100;
        }
        if (oldCode == 101 && lookahead == CType.FNC_1) {
            return 101;
        }
        if (oldCode == 99) {
            return 99;
        }
        if (oldCode == 100) {
            if (lookahead == CType.FNC_1) {
                return 100;
            }
            lookahead = Code128Writer.findCType(value, start2 + 2);
            if (lookahead == CType.UNCODABLE || lookahead == CType.ONE_DIGIT) {
                return 100;
            }
            if (lookahead == CType.FNC_1) {
                lookahead = Code128Writer.findCType(value, start2 + 3);
                if (lookahead == CType.TWO_DIGITS) {
                    return 99;
                }
                return 100;
            }
            int index = start2 + 4;
            while ((lookahead = Code128Writer.findCType(value, index)) == CType.TWO_DIGITS) {
                index += 2;
            }
            if (lookahead == CType.ONE_DIGIT) {
                return 100;
            }
            return 99;
        }
        if (lookahead == CType.FNC_1) {
            lookahead = Code128Writer.findCType(value, start2 + 1);
        }
        if (lookahead == CType.TWO_DIGITS) {
            return 99;
        }
        return 100;
    }

    private static final class MinimalEncoder {
        static final String A = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f\u00ff";
        static final String B = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f\u00ff";
        private static final int CODE_SHIFT = 98;
        private int[][] memoizedCost;
        private Latch[][] minPath;

        private MinimalEncoder() {
        }

        private boolean[] encode(String contents) {
            this.memoizedCost = new int[4][contents.length()];
            this.minPath = new Latch[4][contents.length()];
            this.encode(contents, Charset.NONE, 0);
            ArrayList<int[]> patterns = new ArrayList<int[]>();
            int[] checkSum = new int[]{0};
            int[] checkWeight = new int[]{1};
            int length = contents.length();
            Charset charset = Charset.NONE;
            for (int i2 = 0; i2 < length; ++i2) {
                int patternIndex;
                Latch latch = this.minPath[charset.ordinal()][i2];
                switch (latch) {
                    case A: {
                        charset = Charset.A;
                        MinimalEncoder.addPattern(patterns, i2 == 0 ? 103 : 101, checkSum, checkWeight, i2);
                        break;
                    }
                    case B: {
                        charset = Charset.B;
                        MinimalEncoder.addPattern(patterns, i2 == 0 ? 104 : 100, checkSum, checkWeight, i2);
                        break;
                    }
                    case C: {
                        charset = Charset.C;
                        MinimalEncoder.addPattern(patterns, i2 == 0 ? 105 : 99, checkSum, checkWeight, i2);
                        break;
                    }
                    case SHIFT: {
                        MinimalEncoder.addPattern(patterns, 98, checkSum, checkWeight, i2);
                    }
                }
                if (charset == Charset.C) {
                    if (contents.charAt(i2) == '\u00f1') {
                        MinimalEncoder.addPattern(patterns, 102, checkSum, checkWeight, i2);
                        continue;
                    }
                    MinimalEncoder.addPattern(patterns, Integer.parseInt(contents.substring(i2, i2 + 2)), checkSum, checkWeight, i2);
                    assert (i2 + 1 < length);
                    if (i2 + 1 >= length) continue;
                    ++i2;
                    continue;
                }
                switch (contents.charAt(i2)) {
                    case '\u00f1': {
                        patternIndex = 102;
                        break;
                    }
                    case '\u00f2': {
                        patternIndex = 97;
                        break;
                    }
                    case '\u00f3': {
                        patternIndex = 96;
                        break;
                    }
                    case '\u00f4': {
                        if (charset == Charset.A && latch != Latch.SHIFT || charset == Charset.B && latch == Latch.SHIFT) {
                            patternIndex = 101;
                            break;
                        }
                        patternIndex = 100;
                        break;
                    }
                    default: {
                        patternIndex = contents.charAt(i2) - 32;
                    }
                }
                if ((charset == Charset.A && latch != Latch.SHIFT || charset == Charset.B && latch == Latch.SHIFT) && patternIndex < 0) {
                    patternIndex += 96;
                }
                MinimalEncoder.addPattern(patterns, patternIndex, checkSum, checkWeight, i2);
            }
            this.memoizedCost = null;
            this.minPath = null;
            return Code128Writer.produceResult(patterns, checkSum[0]);
        }

        private static void addPattern(Collection<int[]> patterns, int patternIndex, int[] checkSum, int[] checkWeight, int position) {
            patterns.add(Code128Reader.CODE_PATTERNS[patternIndex]);
            if (position != 0) {
                checkWeight[0] = checkWeight[0] + 1;
            }
            checkSum[0] = checkSum[0] + patternIndex * checkWeight[0];
        }

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }

        private boolean canEncode(CharSequence contents, Charset charset, int position) {
            char c = contents.charAt(position);
            switch (charset) {
                case A: {
                    return c == '\u00f1' || c == '\u00f2' || c == '\u00f3' || c == '\u00f4' || A.indexOf(c) >= 0;
                }
                case B: {
                    return c == '\u00f1' || c == '\u00f2' || c == '\u00f3' || c == '\u00f4' || B.indexOf(c) >= 0;
                }
                case C: {
                    return c == '\u00f1' || position + 1 < contents.length() && MinimalEncoder.isDigit(c) && MinimalEncoder.isDigit(contents.charAt(position + 1));
                }
            }
            return false;
        }

        private int encode(CharSequence contents, Charset charset, int position) {
            assert (position < contents.length());
            int mCost = this.memoizedCost[charset.ordinal()][position];
            if (mCost > 0) {
                return mCost;
            }
            int minCost = Integer.MAX_VALUE;
            Latch minLatch = Latch.NONE;
            boolean atEnd = position + 1 >= contents.length();
            Charset[] sets = new Charset[]{Charset.A, Charset.B};
            for (int i2 = 0; i2 <= 1; ++i2) {
                if (!this.canEncode(contents, sets[i2], position)) continue;
                int cost = 1;
                Latch latch = Latch.NONE;
                if (charset != sets[i2]) {
                    ++cost;
                    latch = Latch.valueOf(sets[i2].toString());
                }
                if (!atEnd) {
                    cost += this.encode(contents, sets[i2], position + 1);
                }
                if (cost < minCost) {
                    minCost = cost;
                    minLatch = latch;
                }
                cost = 1;
                if (charset != sets[(i2 + 1) % 2]) continue;
                ++cost;
                latch = Latch.SHIFT;
                if (!atEnd) {
                    cost += this.encode(contents, charset, position + 1);
                }
                if (cost >= minCost) continue;
                minCost = cost;
                minLatch = latch;
            }
            if (this.canEncode(contents, Charset.C, position)) {
                int advance;
                int cost = 1;
                Latch latch = Latch.NONE;
                if (charset != Charset.C) {
                    ++cost;
                    latch = Latch.C;
                }
                int n = advance = contents.charAt(position) == '\u00f1' ? 1 : 2;
                if (position + advance < contents.length()) {
                    cost += this.encode(contents, Charset.C, position + advance);
                }
                if (cost < minCost) {
                    minCost = cost;
                    minLatch = latch;
                }
            }
            if (minCost == Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Bad character in input: ASCII value=" + contents.charAt(position));
            }
            this.memoizedCost[charset.ordinal()][position] = minCost;
            this.minPath[charset.ordinal()][position] = minLatch;
            return minCost;
        }

        private static enum Latch {
            A,
            B,
            C,
            SHIFT,
            NONE;

        }

        private static enum Charset {
            A,
            B,
            C,
            NONE;

        }
    }

    private static enum CType {
        UNCODABLE,
        ONE_DIGIT,
        TWO_DIGITS,
        FNC_1;

    }
}

