/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.UPCEANReader;
import java.util.Map;

public final class UPCAReader
extends UPCEANReader {
    private final UPCEANReader ean13Reader = new EAN13Reader();

    @Override
    public Result decodeRow(int rowNumber, BitArray row2, int[] startGuardRange, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException, ChecksumException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(rowNumber, row2, startGuardRange, hints));
    }

    @Override
    public Result decodeRow(int rowNumber, BitArray row2, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException, ChecksumException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(rowNumber, row2, hints));
    }

    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(image));
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(image, hints));
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.UPC_A;
    }

    @Override
    protected int decodeMiddle(BitArray row2, int[] startRange, StringBuilder resultString) throws NotFoundException {
        return this.ean13Reader.decodeMiddle(row2, startRange, resultString);
    }

    private static Result maybeReturnResult(Result result2) throws FormatException {
        String text2 = result2.getText();
        if (text2.charAt(0) == '0') {
            Result upcaResult = new Result(text2.substring(1), null, result2.getResultPoints(), BarcodeFormat.UPC_A);
            if (result2.getResultMetadata() != null) {
                upcaResult.putAllMetadata(result2.getResultMetadata());
            }
            return upcaResult;
        }
        throw FormatException.getFormatInstance();
    }
}

