/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension2Support {
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension2Support() {
    }

    Result decodeRow(int rowNumber, BitArray row2, int[] extensionStartRange) throws NotFoundException {
        StringBuilder result2 = this.decodeRowStringBuffer;
        result2.setLength(0);
        int end = this.decodeMiddle(row2, extensionStartRange, result2);
        String resultString = result2.toString();
        Map<ResultMetadataType, Object> extensionData = UPCEANExtension2Support.parseExtensionString(resultString);
        Result extensionResult = new Result(resultString, null, new ResultPoint[]{new ResultPoint((float)(extensionStartRange[0] + extensionStartRange[1]) / 2.0f, rowNumber), new ResultPoint(end, rowNumber)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (extensionData != null) {
            extensionResult.putAllMetadata(extensionData);
        }
        return extensionResult;
    }

    private int decodeMiddle(BitArray row2, int[] startRange, StringBuilder resultString) throws NotFoundException {
        int[] counters = this.decodeMiddleCounters;
        counters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row2.getSize();
        int rowOffset = startRange[1];
        int checkParity = 0;
        for (int x = 0; x < 2 && rowOffset < end; ++x) {
            int bestMatch = UPCEANReader.decodeDigit(row2, counters, rowOffset, UPCEANReader.L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            for (int counter : counters) {
                rowOffset += counter;
            }
            if (bestMatch >= 10) {
                checkParity |= 1 << 1 - x;
            }
            if (x == 1) continue;
            rowOffset = row2.getNextSet(rowOffset);
            rowOffset = row2.getNextUnset(rowOffset);
        }
        if (resultString.length() != 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (Integer.parseInt(resultString.toString()) % 4 != checkParity) {
            throw NotFoundException.getNotFoundInstance();
        }
        return rowOffset;
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String raw) {
        if (raw.length() != 2) {
            return null;
        }
        EnumMap<ResultMetadataType, Object> result2 = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        result2.put(ResultMetadataType.ISSUE_NUMBER, Integer.valueOf(raw));
        return result2;
    }
}

