/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.ECIStringBuilder;
import com.google.zxing.pdf417.PDF417ResultMetadata;
import java.math.BigInteger;
import java.util.Arrays;

final class DecodedBitStreamParser {
    private static final int TEXT_COMPACTION_MODE_LATCH = 900;
    private static final int BYTE_COMPACTION_MODE_LATCH = 901;
    private static final int NUMERIC_COMPACTION_MODE_LATCH = 902;
    private static final int BYTE_COMPACTION_MODE_LATCH_6 = 924;
    private static final int ECI_USER_DEFINED = 925;
    private static final int ECI_GENERAL_PURPOSE = 926;
    private static final int ECI_CHARSET = 927;
    private static final int BEGIN_MACRO_PDF417_CONTROL_BLOCK = 928;
    private static final int BEGIN_MACRO_PDF417_OPTIONAL_FIELD = 923;
    private static final int MACRO_PDF417_TERMINATOR = 922;
    private static final int MODE_SHIFT_TO_BYTE_COMPACTION_MODE = 913;
    private static final int MAX_NUMERIC_CODEWORDS = 15;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_FILE_NAME = 0;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_SEGMENT_COUNT = 1;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_TIME_STAMP = 2;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_SENDER = 3;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_ADDRESSEE = 4;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_FILE_SIZE = 5;
    private static final int MACRO_PDF417_OPTIONAL_FIELD_CHECKSUM = 6;
    private static final int PL = 25;
    private static final int LL = 27;
    private static final int AS = 27;
    private static final int ML = 28;
    private static final int AL = 28;
    private static final int PS = 29;
    private static final int PAL = 29;
    private static final char[] PUNCT_CHARS;
    private static final char[] MIXED_CHARS;
    private static final BigInteger[] EXP900;
    private static final int NUMBER_OF_SEQUENCE_CODEWORDS = 2;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(int[] codewords, String ecLevel) throws FormatException {
        ECIStringBuilder result2 = new ECIStringBuilder(codewords.length * 2);
        int codeIndex = DecodedBitStreamParser.textCompaction(codewords, 1, result2);
        PDF417ResultMetadata resultMetadata = new PDF417ResultMetadata();
        block11: while (codeIndex < codewords[0]) {
            int code = codewords[codeIndex++];
            switch (code) {
                case 900: {
                    codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex, result2);
                    continue block11;
                }
                case 901: 
                case 924: {
                    codeIndex = DecodedBitStreamParser.byteCompaction(code, codewords, codeIndex, result2);
                    continue block11;
                }
                case 913: {
                    result2.append((char)codewords[codeIndex++]);
                    continue block11;
                }
                case 902: {
                    codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex, result2);
                    continue block11;
                }
                case 927: {
                    result2.appendECI(codewords[codeIndex++]);
                    continue block11;
                }
                case 926: {
                    codeIndex += 2;
                    continue block11;
                }
                case 925: {
                    ++codeIndex;
                    continue block11;
                }
                case 928: {
                    codeIndex = DecodedBitStreamParser.decodeMacroBlock(codewords, codeIndex, resultMetadata);
                    continue block11;
                }
                case 922: 
                case 923: {
                    throw FormatException.getFormatInstance();
                }
            }
            --codeIndex;
            codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex, result2);
        }
        if (result2.isEmpty() && resultMetadata.getFileId() == null) {
            throw FormatException.getFormatInstance();
        }
        DecoderResult decoderResult = new DecoderResult(null, result2.toString(), null, ecLevel);
        decoderResult.setOther(resultMetadata);
        return decoderResult;
    }

    static int decodeMacroBlock(int[] codewords, int codeIndex, PDF417ResultMetadata resultMetadata) throws FormatException {
        if (codeIndex + 2 > codewords[0]) {
            throw FormatException.getFormatInstance();
        }
        int[] segmentIndexArray = new int[2];
        int i2 = 0;
        while (i2 < 2) {
            segmentIndexArray[i2] = codewords[codeIndex];
            ++i2;
            ++codeIndex;
        }
        String segmentIndexString = DecodedBitStreamParser.decodeBase900toBase10(segmentIndexArray, 2);
        if (segmentIndexString.isEmpty()) {
            resultMetadata.setSegmentIndex(0);
        } else {
            try {
                resultMetadata.setSegmentIndex(Integer.parseInt(segmentIndexString));
            }
            catch (NumberFormatException nfe) {
                throw FormatException.getFormatInstance();
            }
        }
        StringBuilder fileId = new StringBuilder();
        while (codeIndex < codewords[0] && codeIndex < codewords.length && codewords[codeIndex] != 922 && codewords[codeIndex] != 923) {
            fileId.append(String.format("%03d", codewords[codeIndex]));
            ++codeIndex;
        }
        if (fileId.length() == 0) {
            throw FormatException.getFormatInstance();
        }
        resultMetadata.setFileId(fileId.toString());
        int optionalFieldsStart = -1;
        if (codewords[codeIndex] == 923) {
            optionalFieldsStart = codeIndex + 1;
        }
        block17: while (codeIndex < codewords[0]) {
            switch (codewords[codeIndex]) {
                case 923: {
                    switch (codewords[++codeIndex]) {
                        case 0: {
                            ECIStringBuilder fileName = new ECIStringBuilder();
                            codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex + 1, fileName);
                            resultMetadata.setFileName(fileName.toString());
                            continue block17;
                        }
                        case 3: {
                            ECIStringBuilder sender = new ECIStringBuilder();
                            codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex + 1, sender);
                            resultMetadata.setSender(sender.toString());
                            continue block17;
                        }
                        case 4: {
                            ECIStringBuilder addressee = new ECIStringBuilder();
                            codeIndex = DecodedBitStreamParser.textCompaction(codewords, codeIndex + 1, addressee);
                            resultMetadata.setAddressee(addressee.toString());
                            continue block17;
                        }
                        case 1: {
                            ECIStringBuilder segmentCount = new ECIStringBuilder();
                            codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex + 1, segmentCount);
                            resultMetadata.setSegmentCount(Integer.parseInt(segmentCount.toString()));
                            continue block17;
                        }
                        case 2: {
                            ECIStringBuilder timestamp = new ECIStringBuilder();
                            codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex + 1, timestamp);
                            resultMetadata.setTimestamp(Long.parseLong(timestamp.toString()));
                            continue block17;
                        }
                        case 6: {
                            ECIStringBuilder checksum = new ECIStringBuilder();
                            codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex + 1, checksum);
                            resultMetadata.setChecksum(Integer.parseInt(checksum.toString()));
                            continue block17;
                        }
                        case 5: {
                            ECIStringBuilder fileSize = new ECIStringBuilder();
                            codeIndex = DecodedBitStreamParser.numericCompaction(codewords, codeIndex + 1, fileSize);
                            resultMetadata.setFileSize(Long.parseLong(fileSize.toString()));
                            continue block17;
                        }
                    }
                    throw FormatException.getFormatInstance();
                }
                case 922: {
                    ++codeIndex;
                    resultMetadata.setLastSegment(true);
                    continue block17;
                }
            }
            throw FormatException.getFormatInstance();
        }
        if (optionalFieldsStart != -1) {
            int optionalFieldsLength = codeIndex - optionalFieldsStart;
            if (resultMetadata.isLastSegment()) {
                --optionalFieldsLength;
            }
            resultMetadata.setOptionalData(Arrays.copyOfRange(codewords, optionalFieldsStart, optionalFieldsStart + optionalFieldsLength));
        }
        return codeIndex;
    }

    private static int textCompaction(int[] codewords, int codeIndex, ECIStringBuilder result2) throws FormatException {
        int[] textCompactionData = new int[(codewords[0] - codeIndex) * 2];
        int[] byteCompactionData = new int[(codewords[0] - codeIndex) * 2];
        int index = 0;
        boolean end = false;
        Mode subMode = Mode.ALPHA;
        while (codeIndex < codewords[0] && !end) {
            int code;
            if ((code = codewords[codeIndex++]) < 900) {
                textCompactionData[index] = code / 30;
                textCompactionData[index + 1] = code % 30;
                index += 2;
                continue;
            }
            switch (code) {
                case 900: {
                    textCompactionData[index++] = 900;
                    break;
                }
                case 901: 
                case 902: 
                case 922: 
                case 923: 
                case 924: 
                case 928: {
                    --codeIndex;
                    end = true;
                    break;
                }
                case 913: {
                    textCompactionData[index] = 913;
                    byteCompactionData[index] = code = codewords[codeIndex++];
                    ++index;
                    break;
                }
                case 927: {
                    subMode = DecodedBitStreamParser.decodeTextCompaction(textCompactionData, byteCompactionData, index, result2, subMode);
                    result2.appendECI(codewords[codeIndex++]);
                    textCompactionData = new int[(codewords[0] - codeIndex) * 2];
                    byteCompactionData = new int[(codewords[0] - codeIndex) * 2];
                    index = 0;
                }
            }
        }
        DecodedBitStreamParser.decodeTextCompaction(textCompactionData, byteCompactionData, index, result2, subMode);
        return codeIndex;
    }

    private static Mode decodeTextCompaction(int[] textCompactionData, int[] byteCompactionData, int length, ECIStringBuilder result2, Mode startMode) {
        Mode subMode = startMode;
        Mode priorToShiftMode = startMode;
        Mode latchedMode = startMode;
        for (int i2 = 0; i2 < length; ++i2) {
            int subModeCh = textCompactionData[i2];
            int ch = 0;
            block0 : switch (subMode) {
                case ALPHA: {
                    if (subModeCh < 26) {
                        ch = (char)(65 + subModeCh);
                        break;
                    }
                    switch (subModeCh) {
                        case 26: {
                            ch = 32;
                            break;
                        }
                        case 27: {
                            latchedMode = subMode = Mode.LOWER;
                            break;
                        }
                        case 28: {
                            latchedMode = subMode = Mode.MIXED;
                            break;
                        }
                        case 29: {
                            priorToShiftMode = subMode;
                            subMode = Mode.PUNCT_SHIFT;
                            break;
                        }
                        case 913: {
                            result2.append((char)byteCompactionData[i2]);
                            break;
                        }
                        case 900: {
                            latchedMode = subMode = Mode.ALPHA;
                        }
                    }
                    break;
                }
                case LOWER: {
                    if (subModeCh < 26) {
                        ch = (char)(97 + subModeCh);
                        break;
                    }
                    switch (subModeCh) {
                        case 26: {
                            ch = 32;
                            break;
                        }
                        case 27: {
                            priorToShiftMode = subMode;
                            subMode = Mode.ALPHA_SHIFT;
                            break;
                        }
                        case 28: {
                            latchedMode = subMode = Mode.MIXED;
                            break;
                        }
                        case 29: {
                            priorToShiftMode = subMode;
                            subMode = Mode.PUNCT_SHIFT;
                            break;
                        }
                        case 913: {
                            result2.append((char)byteCompactionData[i2]);
                            break;
                        }
                        case 900: {
                            latchedMode = subMode = Mode.ALPHA;
                        }
                    }
                    break;
                }
                case MIXED: {
                    if (subModeCh < 25) {
                        ch = MIXED_CHARS[subModeCh];
                        break;
                    }
                    switch (subModeCh) {
                        case 25: {
                            latchedMode = subMode = Mode.PUNCT;
                            break;
                        }
                        case 26: {
                            ch = 32;
                            break;
                        }
                        case 27: {
                            latchedMode = subMode = Mode.LOWER;
                            break;
                        }
                        case 28: 
                        case 900: {
                            latchedMode = subMode = Mode.ALPHA;
                            break;
                        }
                        case 29: {
                            priorToShiftMode = subMode;
                            subMode = Mode.PUNCT_SHIFT;
                            break;
                        }
                        case 913: {
                            result2.append((char)byteCompactionData[i2]);
                        }
                    }
                    break;
                }
                case PUNCT: {
                    if (subModeCh < 29) {
                        ch = PUNCT_CHARS[subModeCh];
                        break;
                    }
                    switch (subModeCh) {
                        case 29: 
                        case 900: {
                            latchedMode = subMode = Mode.ALPHA;
                            break;
                        }
                        case 913: {
                            result2.append((char)byteCompactionData[i2]);
                        }
                    }
                    break;
                }
                case ALPHA_SHIFT: {
                    subMode = priorToShiftMode;
                    if (subModeCh < 26) {
                        ch = (char)(65 + subModeCh);
                        break;
                    }
                    switch (subModeCh) {
                        case 26: {
                            ch = 32;
                            break;
                        }
                        case 900: {
                            subMode = Mode.ALPHA;
                        }
                    }
                    break;
                }
                case PUNCT_SHIFT: {
                    subMode = priorToShiftMode;
                    if (subModeCh < 29) {
                        ch = PUNCT_CHARS[subModeCh];
                        break;
                    }
                    switch (subModeCh) {
                        case 29: 
                        case 900: {
                            subMode = Mode.ALPHA;
                            break block0;
                        }
                        case 913: {
                            result2.append((char)byteCompactionData[i2]);
                        }
                    }
                }
            }
            if (ch == 0) continue;
            result2.append((char)ch);
        }
        return latchedMode;
    }

    private static int byteCompaction(int mode, int[] codewords, int codeIndex, ECIStringBuilder result2) throws FormatException {
        boolean end = false;
        while (codeIndex < codewords[0] && !end) {
            while (codeIndex < codewords[0] && codewords[codeIndex] == 927) {
                result2.appendECI(codewords[++codeIndex]);
                ++codeIndex;
            }
            if (codeIndex >= codewords[0] || codewords[codeIndex] >= 900) {
                end = true;
                continue;
            }
            long value = 0L;
            int count = 0;
            do {
                value = 900L * value + (long)codewords[codeIndex++];
            } while (++count < 5 && codeIndex < codewords[0] && codewords[codeIndex] < 900);
            if (count == 5 && (mode == 924 || codeIndex < codewords[0] && codewords[codeIndex] < 900)) {
                for (int i2 = 0; i2 < 6; ++i2) {
                    result2.append((byte)(value >> 8 * (5 - i2)));
                }
                continue;
            }
            codeIndex -= count;
            while (codeIndex < codewords[0] && !end) {
                int code;
                if ((code = codewords[codeIndex++]) < 900) {
                    result2.append((byte)code);
                    continue;
                }
                if (code == 927) {
                    result2.appendECI(codewords[codeIndex++]);
                    continue;
                }
                --codeIndex;
                end = true;
            }
        }
        return codeIndex;
    }

    private static int numericCompaction(int[] codewords, int codeIndex, ECIStringBuilder result2) throws FormatException {
        int count = 0;
        boolean end = false;
        int[] numericCodewords = new int[15];
        while (codeIndex < codewords[0] && !end) {
            int code = codewords[codeIndex++];
            if (codeIndex == codewords[0]) {
                end = true;
            }
            if (code < 900) {
                numericCodewords[count] = code;
                ++count;
            } else {
                switch (code) {
                    case 900: 
                    case 901: 
                    case 922: 
                    case 923: 
                    case 924: 
                    case 927: 
                    case 928: {
                        --codeIndex;
                        end = true;
                    }
                }
            }
            if (count % 15 != 0 && code != 902 && !end || count <= 0) continue;
            result2.append(DecodedBitStreamParser.decodeBase900toBase10(numericCodewords, count));
            count = 0;
        }
        return codeIndex;
    }

    private static String decodeBase900toBase10(int[] codewords, int count) throws FormatException {
        BigInteger result2 = BigInteger.ZERO;
        for (int i2 = 0; i2 < count; ++i2) {
            result2 = result2.add(EXP900[count - i2 - 1].multiply(BigInteger.valueOf(codewords[i2])));
        }
        String resultString = result2.toString();
        if (resultString.charAt(0) != '1') {
            throw FormatException.getFormatInstance();
        }
        return resultString.substring(1);
    }

    static {
        BigInteger nineHundred;
        PUNCT_CHARS = ";<>@[\\]_`~!\r\t,:\n-.$/\"|*()?{}'".toCharArray();
        MIXED_CHARS = "0123456789&\r\t,:#-.$/+%*=^".toCharArray();
        EXP900 = new BigInteger[16];
        DecodedBitStreamParser.EXP900[0] = BigInteger.ONE;
        DecodedBitStreamParser.EXP900[1] = nineHundred = BigInteger.valueOf(900L);
        for (int i2 = 2; i2 < EXP900.length; ++i2) {
            DecodedBitStreamParser.EXP900[i2] = EXP900[i2 - 1].multiply(nineHundred);
        }
    }

    private static enum Mode {
        ALPHA,
        LOWER,
        MIXED,
        PUNCT,
        ALPHA_SHIFT,
        PUNCT_SHIFT;

    }
}

