/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.detector;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final float MAX_AVG_VARIANCE = 0.42f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.8f;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap image, Map<DecodeHintType, ?> hints, boolean multiple) throws NotFoundException {
        BitMatrix bitMatrix = image.getBlackMatrix();
        List<ResultPoint[]> barcodeCoordinates = Detector.detect(multiple, bitMatrix);
        for (int rotate2 = 0; barcodeCoordinates.isEmpty() && rotate2 < 3; ++rotate2) {
            bitMatrix = bitMatrix.clone();
            if (rotate2 != 1) {
                bitMatrix.rotate180();
            } else {
                bitMatrix.rotate90();
            }
            barcodeCoordinates = Detector.detect(multiple, bitMatrix);
        }
        return new PDF417DetectorResult(bitMatrix, barcodeCoordinates);
    }

    private static List<ResultPoint[]> detect(boolean multiple, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> barcodeCoordinates = new ArrayList<ResultPoint[]>();
        int row2 = 0;
        int column2 = 0;
        boolean foundBarcodeInRow = false;
        while (row2 < bitMatrix.getHeight()) {
            ResultPoint[] vertices = Detector.findVertices(bitMatrix, row2, column2);
            if (vertices[0] == null && vertices[3] == null) {
                if (!foundBarcodeInRow) break;
                foundBarcodeInRow = false;
                column2 = 0;
                for (ResultPoint[] barcodeCoordinate : barcodeCoordinates) {
                    if (barcodeCoordinate[1] != null) {
                        row2 = (int)Math.max((float)row2, barcodeCoordinate[1].getY());
                    }
                    if (barcodeCoordinate[3] == null) continue;
                    row2 = Math.max(row2, (int)barcodeCoordinate[3].getY());
                }
                row2 += 5;
                continue;
            }
            foundBarcodeInRow = true;
            barcodeCoordinates.add(vertices);
            if (!multiple) break;
            if (vertices[2] != null) {
                column2 = (int)vertices[2].getX();
                row2 = (int)vertices[2].getY();
                continue;
            }
            column2 = (int)vertices[4].getX();
            row2 = (int)vertices[4].getY();
        }
        return barcodeCoordinates;
    }

    private static ResultPoint[] findVertices(BitMatrix matrix, int startRow, int startColumn) {
        int height = matrix.getHeight();
        int width = matrix.getWidth();
        ResultPoint[] result2 = new ResultPoint[8];
        Detector.copyToResult(result2, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, START_PATTERN), INDEXES_START_PATTERN);
        if (result2[4] != null) {
            startColumn = (int)result2[4].getX();
            startRow = (int)result2[4].getY();
        }
        Detector.copyToResult(result2, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, STOP_PATTERN), INDEXES_STOP_PATTERN);
        return result2;
    }

    private static void copyToResult(ResultPoint[] result2, ResultPoint[] tmpResult, int[] destinationIndexes) {
        for (int i2 = 0; i2 < destinationIndexes.length; ++i2) {
            result2[destinationIndexes[i2]] = tmpResult[i2];
        }
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix matrix, int height, int width, int startRow, int startColumn, int[] pattern) {
        int stopRow;
        Object[] result2 = new ResultPoint[4];
        boolean found = false;
        int[] counters = new int[pattern.length];
        while (startRow < height) {
            int[] loc = Detector.findGuardPattern(matrix, startColumn, startRow, width, pattern, counters);
            if (loc != null) {
                while (startRow > 0) {
                    int[] previousRowLoc;
                    if ((previousRowLoc = Detector.findGuardPattern(matrix, startColumn, --startRow, width, pattern, counters)) != null) {
                        loc = previousRowLoc;
                        continue;
                    }
                    ++startRow;
                    break;
                }
                result2[0] = new ResultPoint(loc[0], startRow);
                result2[1] = new ResultPoint(loc[1], startRow);
                found = true;
                break;
            }
            startRow += 5;
        }
        if (found) {
            int skippedRowCount = 0;
            int[] previousRowLoc = new int[]{(int)((ResultPoint)result2[0]).getX(), (int)((ResultPoint)result2[1]).getX()};
            for (stopRow = startRow + 1; stopRow < height; ++stopRow) {
                int[] loc = Detector.findGuardPattern(matrix, previousRowLoc[0], stopRow, width, pattern, counters);
                if (loc != null && Math.abs(previousRowLoc[0] - loc[0]) < 5 && Math.abs(previousRowLoc[1] - loc[1]) < 5) {
                    previousRowLoc = loc;
                    skippedRowCount = 0;
                    continue;
                }
                if (skippedRowCount > 25) break;
                ++skippedRowCount;
            }
            result2[2] = new ResultPoint(previousRowLoc[0], stopRow -= skippedRowCount + 1);
            result2[3] = new ResultPoint(previousRowLoc[1], stopRow);
        }
        if (stopRow - startRow < 10) {
            Arrays.fill(result2, null);
        }
        return result2;
    }

    private static int[] findGuardPattern(BitMatrix matrix, int column2, int row2, int width, int[] pattern, int[] counters) {
        int x;
        int patternStart;
        Arrays.fill(counters, 0, counters.length, 0);
        int pixelDrift = 0;
        for (patternStart = column2; matrix.get(patternStart, row2) && patternStart > 0 && pixelDrift++ < 3; --patternStart) {
        }
        int counterPosition = 0;
        int patternLength = pattern.length;
        boolean isWhite = false;
        for (x = patternStart; x < width; ++x) {
            boolean pixel = matrix.get(x, row2);
            if (pixel != isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                if (Detector.patternMatchVariance(counters, pattern) < 0.42f) {
                    return new int[]{patternStart, x};
                }
                patternStart += counters[0] + counters[1];
                System.arraycopy(counters, 2, counters, 0, counterPosition - 1);
                counters[counterPosition - 1] = 0;
                counters[counterPosition] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite = !isWhite;
        }
        if (counterPosition == patternLength - 1 && Detector.patternMatchVariance(counters, pattern) < 0.42f) {
            return new int[]{patternStart, x - 1};
        }
        return null;
    }

    private static float patternMatchVariance(int[] counters, int[] pattern) {
        int numCounters = counters.length;
        int total = 0;
        int patternLength = 0;
        for (int i2 = 0; i2 < numCounters; ++i2) {
            total += counters[i2];
            patternLength += pattern[i2];
        }
        if (total < patternLength) {
            return Float.POSITIVE_INFINITY;
        }
        float unitBarWidth = (float)total / (float)patternLength;
        float maxIndividualVariance = 0.8f * unitBarWidth;
        float totalVariance = 0.0f;
        for (int x = 0; x < numCounters; ++x) {
            float variance;
            int counter = counters[x];
            float scaledPattern = (float)pattern[x] * unitBarWidth;
            float f = variance = (float)counter > scaledPattern ? (float)counter - scaledPattern : scaledPattern - (float)counter;
            if (variance > maxIndividualVariance) {
                return Float.POSITIVE_INFINITY;
            }
            totalVariance += variance;
        }
        return totalVariance / (float)total;
    }
}

