/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int numDataCodewords, byte[] codewords) {
        this.numDataCodewords = numDataCodewords;
        this.codewords = codewords;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version, ErrorCorrectionLevel ecLevel) {
        int numCodewords;
        int longerBlocksStartAt;
        int i2;
        Version.ECB[] ecBlockArray;
        if (rawCodewords.length != version.getTotalCodewords()) {
            throw new IllegalArgumentException();
        }
        Version.ECBlocks ecBlocks = version.getECBlocksForLevel(ecLevel);
        int totalBlocks = 0;
        for (Version.ECB ecBlock : ecBlockArray = ecBlocks.getECBlocks()) {
            totalBlocks += ecBlock.getCount();
        }
        DataBlock[] result2 = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        for (Version.ECB ecBlock : ecBlockArray) {
            for (i2 = 0; i2 < ecBlock.getCount(); ++i2) {
                int numDataCodewords = ecBlock.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewordsPerBlock() + numDataCodewords;
                result2[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
            }
        }
        int shorterBlocksTotalCodewords = result2[0].codewords.length;
        for (longerBlocksStartAt = result2.length - 1; longerBlocksStartAt >= 0 && (numCodewords = result2[longerBlocksStartAt].codewords.length) != shorterBlocksTotalCodewords; --longerBlocksStartAt) {
        }
        ++longerBlocksStartAt;
        int shorterBlocksNumDataCodewords = shorterBlocksTotalCodewords - ecBlocks.getECCodewordsPerBlock();
        int rawCodewordsOffset = 0;
        for (i2 = 0; i2 < shorterBlocksNumDataCodewords; ++i2) {
            for (int j = 0; j < numResultBlocks; ++j) {
                result2[j].codewords[i2] = rawCodewords[rawCodewordsOffset++];
            }
        }
        for (int j = longerBlocksStartAt; j < numResultBlocks; ++j) {
            result2[j].codewords[shorterBlocksNumDataCodewords] = rawCodewords[rawCodewordsOffset++];
        }
        int max = result2[0].codewords.length;
        for (int i3 = shorterBlocksNumDataCodewords; i3 < max; ++i3) {
            for (int j = 0; j < numResultBlocks; ++j) {
                int iOffset = j < longerBlocksStartAt ? i3 : i3 + 1;
                result2[j].codewords[iOffset] = rawCodewords[rawCodewordsOffset++];
            }
        }
        return result2;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

