/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.ByteMatrix;

public final class QRCode {
    public static final int NUM_MASK_PATTERNS = 8;
    private Mode mode;
    private ErrorCorrectionLevel ecLevel;
    private Version version;
    private int maskPattern = -1;
    private ByteMatrix matrix;

    public Mode getMode() {
        return this.mode;
    }

    public ErrorCorrectionLevel getECLevel() {
        return this.ecLevel;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getMaskPattern() {
        return this.maskPattern;
    }

    public ByteMatrix getMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder(200);
        result2.append("<<\n");
        result2.append(" mode: ");
        result2.append((Object)this.mode);
        result2.append("\n ecLevel: ");
        result2.append((Object)this.ecLevel);
        result2.append("\n version: ");
        result2.append(this.version);
        result2.append("\n maskPattern: ");
        result2.append(this.maskPattern);
        if (this.matrix == null) {
            result2.append("\n matrix: null\n");
        } else {
            result2.append("\n matrix:\n");
            result2.append(this.matrix);
        }
        result2.append(">>\n");
        return result2.toString();
    }

    public void setMode(Mode value) {
        this.mode = value;
    }

    public void setECLevel(ErrorCorrectionLevel value) {
        this.ecLevel = value;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setMaskPattern(int value) {
        this.maskPattern = value;
    }

    public void setMatrix(ByteMatrix value) {
        this.matrix = value;
    }

    public static boolean isValidMaskPattern(int maskPattern) {
        return maskPattern >= 0 && maskPattern < 8;
    }
}

