/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html.simpleparser;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocListener;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.html.simpleparser.ChainedProperties;
import com.itextpdf.text.html.simpleparser.ImageProvider;
import com.itextpdf.text.pdf.HyphenationAuto;
import com.itextpdf.text.pdf.HyphenationEvent;
import com.itextpdf.text.pdf.draw.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFactory {
    private FontProvider provider = FontFactory.getFontImp();

    public void setFontProvider(FontProvider provider2) {
        this.provider = provider2;
    }

    public FontProvider getFontProvider() {
        return this.provider;
    }

    public Font getFont(ChainedProperties chain) {
        String encoding;
        String face = chain.getProperty("face");
        if (face == null || face.trim().length() == 0) {
            face = chain.getProperty("font-family");
        }
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (face.startsWith("\"")) {
                    face = face.substring(1);
                }
                if (face.endsWith("\"")) {
                    face = face.substring(0, face.length() - 1);
                }
                if (!this.provider.isRegistered(face)) continue;
            }
        }
        if ((encoding = chain.getProperty("encoding")) == null) {
            encoding = "Cp1252";
        }
        String value = chain.getProperty("size");
        float size = 12.0f;
        if (value != null) {
            size = Float.parseFloat(value);
        }
        int style = 0;
        String decoration = chain.getProperty("text-decoration");
        if (decoration != null && decoration.trim().length() != 0) {
            if ("underline".equals(decoration)) {
                style |= 4;
            } else if ("line-through".equals(decoration)) {
                style |= 8;
            }
        }
        if (chain.hasProperty("i")) {
            style |= 2;
        }
        if (chain.hasProperty("b")) {
            style |= 1;
        }
        if (chain.hasProperty("u")) {
            style |= 4;
        }
        if (chain.hasProperty("s")) {
            style |= 8;
        }
        BaseColor color = HtmlUtilities.decodeColor(chain.getProperty("color"));
        return this.provider.getFont(face, encoding, true, size, style, color);
    }

    public Chunk createChunk(String content, ChainedProperties chain) {
        Font font = this.getFont(chain);
        Chunk ck = new Chunk(content, font);
        if (chain.hasProperty("sub")) {
            ck.setTextRise(-font.getSize() / 2.0f);
        } else if (chain.hasProperty("sup")) {
            ck.setTextRise(font.getSize() / 2.0f);
        }
        ck.setHyphenation(this.getHyphenation(chain));
        return ck;
    }

    public Paragraph createParagraph(ChainedProperties chain) {
        Paragraph paragraph = new Paragraph();
        this.updateElement(paragraph, chain);
        return paragraph;
    }

    public ListItem createListItem(ChainedProperties chain) {
        ListItem item2 = new ListItem();
        this.updateElement(item2, chain);
        return item2;
    }

    protected void updateElement(Paragraph paragraph, ChainedProperties chain) {
        String value = chain.getProperty("align");
        paragraph.setAlignment(HtmlUtilities.alignmentValue(value));
        paragraph.setHyphenation(this.getHyphenation(chain));
        ElementFactory.setParagraphLeading(paragraph, chain.getProperty("leading"));
        value = chain.getProperty("after");
        if (value != null) {
            try {
                paragraph.setSpacingBefore(Float.parseFloat(value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value = chain.getProperty("after")) != null) {
            try {
                paragraph.setSpacingAfter(Float.parseFloat(value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value = chain.getProperty("extraparaspace")) != null) {
            try {
                paragraph.setExtraParagraphSpace(Float.parseFloat(value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value = chain.getProperty("indent")) != null) {
            try {
                paragraph.setIndentationLeft(Float.parseFloat(value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected static void setParagraphLeading(Paragraph paragraph, String leading) {
        if (leading == null) {
            paragraph.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer tk = new StringTokenizer(leading, " ,");
            String v = tk.nextToken();
            float v1 = Float.parseFloat(v);
            if (!tk.hasMoreTokens()) {
                paragraph.setLeading(v1, 0.0f);
                return;
            }
            v = tk.nextToken();
            float v2 = Float.parseFloat(v);
            paragraph.setLeading(v1, v2);
        }
        catch (Exception e) {
            paragraph.setLeading(0.0f, 1.5f);
        }
    }

    public HyphenationEvent getHyphenation(ChainedProperties chain) {
        int leftMin;
        String value = chain.getProperty("hyphenation");
        if (value == null || value.length() == 0) {
            return null;
        }
        int pos = value.indexOf(95);
        if (pos == -1) {
            return new HyphenationAuto(value, null, 2, 2);
        }
        String lang = value.substring(0, pos);
        String country = value.substring(pos + 1);
        if ((pos = country.indexOf(44)) == -1) {
            return new HyphenationAuto(lang, country, 2, 2);
        }
        int rightMin = 2;
        value = country.substring(pos + 1);
        country = country.substring(0, pos);
        pos = value.indexOf(44);
        if (pos == -1) {
            leftMin = Integer.parseInt(value);
        } else {
            leftMin = Integer.parseInt(value.substring(0, pos));
            rightMin = Integer.parseInt(value.substring(pos + 1));
        }
        return new HyphenationAuto(lang, country, leftMin, rightMin);
    }

    public LineSeparator createLineSeparator(Map<String, String> attrs, float offset) {
        float tmpSize;
        float lineWidth = 1.0f;
        String size = attrs.get("size");
        if (size != null && (tmpSize = HtmlUtilities.parseLength(size, 12.0f)) > 0.0f) {
            lineWidth = tmpSize;
        }
        String width = attrs.get("width");
        float percentage = 100.0f;
        if (width != null) {
            float tmpWidth = HtmlUtilities.parseLength(width, 12.0f);
            if (tmpWidth > 0.0f) {
                percentage = tmpWidth;
            }
            if (!width.endsWith("%")) {
                percentage = 100.0f;
            }
        }
        BaseColor lineColor = null;
        int align = HtmlUtilities.alignmentValue(attrs.get("align"));
        return new LineSeparator(lineWidth, percentage, lineColor, align, offset);
    }

    public Image createImage(String src, Map<String, String> attrs, ChainedProperties chain, DocListener document, ImageProvider img_provider, HashMap<String, Image> img_store, String img_baseurl) throws DocumentException, IOException {
        String after;
        Image tim;
        Image img2 = null;
        if (img_provider != null) {
            img2 = img_provider.getImage(src, attrs, chain, document);
        }
        if (img2 == null && img_store != null && (tim = img_store.get(src)) != null) {
            img2 = Image.getInstance(tim);
        }
        if (img2 != null) {
            return img2;
        }
        if (!src.startsWith("http") && img_baseurl != null) {
            src = img_baseurl + src;
        } else if (img2 == null && !src.startsWith("http")) {
            String path2 = chain.getProperty("image_path");
            if (path2 == null) {
                path2 = "";
            }
            src = new File(path2, src).getPath();
        }
        img2 = Image.getInstance(src);
        if (img2 == null) {
            return null;
        }
        float actualFontSize = HtmlUtilities.parseLength(chain.getProperty("size"), 12.0f);
        if (actualFontSize <= 0.0f) {
            actualFontSize = 12.0f;
        }
        String width = attrs.get("width");
        float widthInPoints = HtmlUtilities.parseLength(width, actualFontSize);
        String height = attrs.get("height");
        float heightInPoints = HtmlUtilities.parseLength(height, actualFontSize);
        if (widthInPoints > 0.0f && heightInPoints > 0.0f) {
            img2.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (widthInPoints > 0.0f) {
            heightInPoints = img2.getHeight() * widthInPoints / img2.getWidth();
            img2.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (heightInPoints > 0.0f) {
            widthInPoints = img2.getWidth() * heightInPoints / img2.getHeight();
            img2.scaleAbsolute(widthInPoints, heightInPoints);
        }
        String before = chain.getProperty("before");
        if (before != null) {
            img2.setSpacingBefore(Float.parseFloat(before));
        }
        if ((after = chain.getProperty("after")) != null) {
            img2.setSpacingAfter(Float.parseFloat(after));
        }
        img2.setWidthPercentage(0.0f);
        return img2;
    }

    public List createList(String tag, ChainedProperties chain) {
        List list2;
        if ("ul".equalsIgnoreCase(tag)) {
            list2 = new List(false);
            list2.setListSymbol("\u2022 ");
        } else {
            list2 = new List(true);
        }
        try {
            list2.setIndentationLeft(new Float(chain.getProperty("indent")).floatValue());
        }
        catch (Exception e) {
            list2.setAutoindent(true);
        }
        return list2;
    }
}

