/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocWriter;
import com.itextpdf.text.log.Counter;
import com.itextpdf.text.log.CounterFactory;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.FdfReader;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FdfWriter {
    private static final byte[] HEADER_FDF = DocWriter.getISOBytes("%FDF-1.4\n%\u00e2\u00e3\u00cf\u00d3\n");
    HashMap<String, Object> fields = new HashMap();
    private String file;
    protected Counter COUNTER = CounterFactory.getCounter(FdfWriter.class);

    public void writeTo(OutputStream os) throws IOException {
        Wrt wrt = new Wrt(os, this);
        wrt.writeTo();
    }

    boolean setField(String field2, PdfObject value) {
        HashMap obj;
        String s;
        HashMap<String, Object> map2;
        block4: {
            map2 = this.fields;
            StringTokenizer tk = new StringTokenizer(field2, ".");
            if (!tk.hasMoreTokens()) {
                return false;
            }
            while (true) {
                s = tk.nextToken();
                obj = map2.get(s);
                if (!tk.hasMoreTokens()) break block4;
                if (obj == null) {
                    obj = new HashMap();
                    map2.put(s, obj);
                    map2 = obj;
                    continue;
                }
                if (!(obj instanceof HashMap)) break;
                map2 = obj;
            }
            return false;
        }
        if (!(obj instanceof HashMap)) {
            map2.put(s, value);
            return true;
        }
        return false;
    }

    void iterateFields(HashMap<String, Object> values2, HashMap<String, Object> map2, String name) {
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            String s = entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof HashMap) {
                this.iterateFields(values2, (HashMap)obj, name + "." + s);
                continue;
            }
            values2.put((name + "." + s).substring(1), obj);
        }
    }

    public boolean removeField(String field2) {
        Object obj;
        ArrayList<Object> hist;
        HashMap map2;
        block5: {
            map2 = this.fields;
            StringTokenizer tk = new StringTokenizer(field2, ".");
            if (!tk.hasMoreTokens()) {
                return false;
            }
            hist = new ArrayList<Object>();
            while (true) {
                String s;
                if ((obj = map2.get(s = tk.nextToken())) == null) {
                    return false;
                }
                hist.add(map2);
                hist.add(s);
                if (!tk.hasMoreTokens()) break block5;
                if (!(obj instanceof HashMap)) break;
                map2 = (HashMap)obj;
            }
            return false;
        }
        if (obj instanceof HashMap) {
            return false;
        }
        for (int k = hist.size() - 2; k >= 0; k -= 2) {
            map2 = (HashMap)hist.get(k);
            String s = (String)hist.get(k + 1);
            map2.remove(s);
            if (!map2.isEmpty()) break;
        }
        return true;
    }

    public HashMap<String, Object> getFields() {
        HashMap<String, Object> values2 = new HashMap<String, Object>();
        this.iterateFields(values2, this.fields, "");
        return values2;
    }

    public String getField(String field2) {
        Object obj;
        block5: {
            HashMap map2 = this.fields;
            StringTokenizer tk = new StringTokenizer(field2, ".");
            if (!tk.hasMoreTokens()) {
                return null;
            }
            while (true) {
                String s;
                if ((obj = map2.get(s = tk.nextToken())) == null) {
                    return null;
                }
                if (!tk.hasMoreTokens()) break block5;
                if (!(obj instanceof HashMap)) break;
                map2 = (HashMap)obj;
            }
            return null;
        }
        if (obj instanceof HashMap) {
            return null;
        }
        if (((PdfObject)obj).isString()) {
            return ((PdfString)obj).toUnicodeString();
        }
        return PdfName.decodeName(obj.toString());
    }

    public boolean setFieldAsName(String field2, String value) {
        return this.setField(field2, new PdfName(value));
    }

    public boolean setFieldAsString(String field2, String value) {
        return this.setField(field2, new PdfString(value, "UnicodeBig"));
    }

    public boolean setFieldAsAction(String field2, PdfAction action2) {
        return this.setField(field2, action2);
    }

    public void setFields(FdfReader fdf) {
        HashMap<String, PdfDictionary> map2 = fdf.getFields();
        for (Map.Entry<String, PdfDictionary> entry : map2.entrySet()) {
            String key2 = entry.getKey();
            PdfDictionary dic = entry.getValue();
            PdfObject v = dic.get(PdfName.V);
            if (v != null) {
                this.setField(key2, v);
            }
            if ((v = dic.get(PdfName.A)) == null) continue;
            this.setField(key2, v);
        }
    }

    public void setFields(PdfReader pdf) {
        this.setFields(pdf.getAcroFields());
    }

    public void setFields(AcroFields af) {
        for (Map.Entry<String, AcroFields.Item> entry : af.getFields().entrySet()) {
            PdfObject ft;
            String fn = entry.getKey();
            AcroFields.Item item2 = entry.getValue();
            PdfDictionary dic = item2.getMerged(0);
            PdfObject v = PdfReader.getPdfObjectRelease(dic.get(PdfName.V));
            if (v == null || (ft = PdfReader.getPdfObjectRelease(dic.get(PdfName.FT))) == null || PdfName.SIG.equals(ft)) continue;
            this.setField(fn, v);
        }
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    protected Counter getCounter() {
        return this.COUNTER;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Wrt
    extends PdfWriter {
        private FdfWriter fdf;

        Wrt(OutputStream os, FdfWriter fdf) throws IOException {
            super(new PdfDocument(), os);
            this.fdf = fdf;
            this.os.write(HEADER_FDF);
            this.body = new PdfWriter.PdfBody(this);
        }

        void writeTo() throws IOException {
            PdfDictionary dic = new PdfDictionary();
            dic.put(PdfName.FIELDS, this.calculate(this.fdf.fields));
            if (this.fdf.file != null) {
                dic.put(PdfName.F, new PdfString(this.fdf.file, "UnicodeBig"));
            }
            PdfDictionary fd = new PdfDictionary();
            fd.put(PdfName.FDF, dic);
            PdfIndirectReference ref = this.addToBody(fd).getIndirectReference();
            this.os.write(Wrt.getISOBytes("trailer\n"));
            PdfDictionary trailer = new PdfDictionary();
            trailer.put(PdfName.ROOT, ref);
            trailer.toPdf(null, this.os);
            this.os.write(Wrt.getISOBytes("\n%%EOF\n"));
            this.os.close();
        }

        PdfArray calculate(HashMap<String, Object> map2) throws IOException {
            PdfArray ar = new PdfArray();
            for (Map.Entry<String, Object> entry : map2.entrySet()) {
                String key2 = entry.getKey();
                Object v = entry.getValue();
                PdfDictionary dic = new PdfDictionary();
                dic.put(PdfName.T, new PdfString(key2, "UnicodeBig"));
                if (v instanceof HashMap) {
                    dic.put(PdfName.KIDS, this.calculate((HashMap)v));
                } else if (v instanceof PdfAction) {
                    dic.put(PdfName.A, (PdfAction)v);
                } else {
                    dic.put(PdfName.V, (PdfObject)v);
                }
                ar.add(dic);
            }
            return ar;
        }
    }
}

