/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfArray
extends PdfObject
implements Iterable<PdfObject> {
    protected ArrayList<PdfObject> arrayList;

    public PdfArray() {
        super(5);
        this.arrayList = new ArrayList();
    }

    public PdfArray(PdfObject object) {
        super(5);
        this.arrayList = new ArrayList();
        this.arrayList.add(object);
    }

    public PdfArray(float[] values2) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(values2);
    }

    public PdfArray(int[] values2) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(values2);
    }

    public PdfArray(List<PdfObject> l) {
        this();
        for (PdfObject element : l) {
            this.add(element);
        }
    }

    public PdfArray(PdfArray array) {
        super(5);
        this.arrayList = new ArrayList<PdfObject>(array.arrayList);
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        PdfObject object;
        os.write(91);
        Iterator<PdfObject> i2 = this.arrayList.iterator();
        int type2 = 0;
        if (i2.hasNext()) {
            object = i2.next();
            if (object == null) {
                object = PdfNull.PDFNULL;
            }
            object.toPdf(writer, os);
        }
        while (i2.hasNext()) {
            object = i2.next();
            if (object == null) {
                object = PdfNull.PDFNULL;
            }
            if ((type2 = object.type()) != 5 && type2 != 6 && type2 != 4 && type2 != 3) {
                os.write(32);
            }
            object.toPdf(writer, os);
        }
        os.write(93);
    }

    @Override
    public String toString() {
        return this.arrayList.toString();
    }

    public PdfObject set(int idx, PdfObject obj) {
        return this.arrayList.set(idx, obj);
    }

    public PdfObject remove(int idx) {
        return this.arrayList.remove(idx);
    }

    @Deprecated
    public ArrayList<PdfObject> getArrayList() {
        return this.arrayList;
    }

    public int size() {
        return this.arrayList.size();
    }

    public boolean isEmpty() {
        return this.arrayList.isEmpty();
    }

    public boolean add(PdfObject object) {
        return this.arrayList.add(object);
    }

    public boolean add(float[] values2) {
        for (int k = 0; k < values2.length; ++k) {
            this.arrayList.add(new PdfNumber(values2[k]));
        }
        return true;
    }

    public boolean add(int[] values2) {
        for (int k = 0; k < values2.length; ++k) {
            this.arrayList.add(new PdfNumber(values2[k]));
        }
        return true;
    }

    public void add(int index, PdfObject element) {
        this.arrayList.add(index, element);
    }

    public void addFirst(PdfObject object) {
        this.arrayList.add(0, object);
    }

    public boolean contains(PdfObject object) {
        return this.arrayList.contains(object);
    }

    public ListIterator<PdfObject> listIterator() {
        return this.arrayList.listIterator();
    }

    public PdfObject getPdfObject(int idx) {
        return this.arrayList.get(idx);
    }

    public PdfObject getDirectObject(int idx) {
        return PdfReader.getPdfObject(this.getPdfObject(idx));
    }

    public PdfDictionary getAsDict(int idx) {
        PdfDictionary dict = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isDictionary()) {
            dict = (PdfDictionary)orig;
        }
        return dict;
    }

    public PdfArray getAsArray(int idx) {
        PdfArray array = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isArray()) {
            array = (PdfArray)orig;
        }
        return array;
    }

    public PdfStream getAsStream(int idx) {
        PdfStream stream = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isStream()) {
            stream = (PdfStream)orig;
        }
        return stream;
    }

    public PdfString getAsString(int idx) {
        PdfString string2 = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isString()) {
            string2 = (PdfString)orig;
        }
        return string2;
    }

    public PdfNumber getAsNumber(int idx) {
        PdfNumber number = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isNumber()) {
            number = (PdfNumber)orig;
        }
        return number;
    }

    public PdfName getAsName(int idx) {
        PdfName name = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isName()) {
            name = (PdfName)orig;
        }
        return name;
    }

    public PdfBoolean getAsBoolean(int idx) {
        PdfBoolean bool2 = null;
        PdfObject orig = this.getDirectObject(idx);
        if (orig != null && orig.isBoolean()) {
            bool2 = (PdfBoolean)orig;
        }
        return bool2;
    }

    public PdfIndirectReference getAsIndirectObject(int idx) {
        PdfIndirectReference ref = null;
        PdfObject orig = this.getPdfObject(idx);
        if (orig != null && orig.isIndirect()) {
            ref = (PdfIndirectReference)orig;
        }
        return ref;
    }

    @Override
    public Iterator<PdfObject> iterator() {
        return this.arrayList.iterator();
    }

    public long[] asLongArray() {
        long[] rslt = new long[this.size()];
        for (int k = 0; k < rslt.length; ++k) {
            rslt[k] = this.getAsNumber(k).longValue();
        }
        return rslt;
    }
}

