/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfDictionary
extends PdfObject {
    public static final PdfName FONT = PdfName.FONT;
    public static final PdfName OUTLINES = PdfName.OUTLINES;
    public static final PdfName PAGE = PdfName.PAGE;
    public static final PdfName PAGES = PdfName.PAGES;
    public static final PdfName CATALOG = PdfName.CATALOG;
    private PdfName dictionaryType = null;
    protected HashMap<PdfName, PdfObject> hashMap = new HashMap();

    public PdfDictionary() {
        super(6);
    }

    public PdfDictionary(PdfName type2) {
        this();
        this.dictionaryType = type2;
        this.put(PdfName.TYPE, this.dictionaryType);
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        os.write(60);
        os.write(60);
        int type2 = 0;
        for (Map.Entry<PdfName, PdfObject> e : this.hashMap.entrySet()) {
            e.getKey().toPdf(writer, os);
            PdfObject value = e.getValue();
            type2 = value.type();
            if (type2 != 5 && type2 != 6 && type2 != 4 && type2 != 3) {
                os.write(32);
            }
            value.toPdf(writer, os);
        }
        os.write(62);
        os.write(62);
    }

    @Override
    public String toString() {
        if (this.get(PdfName.TYPE) == null) {
            return "Dictionary";
        }
        return "Dictionary of type: " + this.get(PdfName.TYPE);
    }

    public void put(PdfName key2, PdfObject object) {
        if (object == null || object.isNull()) {
            this.hashMap.remove(key2);
        } else {
            this.hashMap.put(key2, object);
        }
    }

    public void putEx(PdfName key2, PdfObject value) {
        if (value == null) {
            return;
        }
        this.put(key2, value);
    }

    public void putAll(PdfDictionary dic) {
        this.hashMap.putAll(dic.hashMap);
    }

    public void remove(PdfName key2) {
        this.hashMap.remove(key2);
    }

    public void clear() {
        this.hashMap.clear();
    }

    public PdfObject get(PdfName key2) {
        return this.hashMap.get(key2);
    }

    public PdfObject getDirectObject(PdfName key2) {
        return PdfReader.getPdfObject(this.get(key2));
    }

    public Set<PdfName> getKeys() {
        return this.hashMap.keySet();
    }

    public int size() {
        return this.hashMap.size();
    }

    public boolean contains(PdfName key2) {
        return this.hashMap.containsKey(key2);
    }

    public boolean isFont() {
        return FONT.equals(this.dictionaryType);
    }

    public boolean isPage() {
        return PAGE.equals(this.dictionaryType);
    }

    public boolean isPages() {
        return PAGES.equals(this.dictionaryType);
    }

    public boolean isCatalog() {
        return CATALOG.equals(this.dictionaryType);
    }

    public boolean isOutlineTree() {
        return OUTLINES.equals(this.dictionaryType);
    }

    public void merge(PdfDictionary other) {
        this.hashMap.putAll(other.hashMap);
    }

    public void mergeDifferent(PdfDictionary other) {
        for (PdfName key2 : other.hashMap.keySet()) {
            if (this.hashMap.containsKey(key2)) continue;
            this.hashMap.put(key2, other.hashMap.get(key2));
        }
    }

    public PdfDictionary getAsDict(PdfName key2) {
        PdfDictionary dict = null;
        PdfObject orig = this.getDirectObject(key2);
        if (orig != null && orig.isDictionary()) {
            dict = (PdfDictionary)orig;
        }
        return dict;
    }

    public PdfArray getAsArray(PdfName key2) {
        PdfArray array = null;
        PdfObject orig = this.getDirectObject(key2);
        if (orig != null && orig.isArray()) {
            array = (PdfArray)orig;
        }
        return array;
    }

    public PdfStream getAsStream(PdfName key2) {
        PdfStream stream = null;
        PdfObject orig = this.getDirectObject(key2);
        if (orig != null && orig.isStream()) {
            stream = (PdfStream)orig;
        }
        return stream;
    }

    public PdfString getAsString(PdfName key2) {
        PdfString string2 = null;
        PdfObject orig = this.getDirectObject(key2);
        if (orig != null && orig.isString()) {
            string2 = (PdfString)orig;
        }
        return string2;
    }

    public PdfNumber getAsNumber(PdfName key2) {
        PdfNumber number = null;
        PdfObject orig = this.getDirectObject(key2);
        if (orig != null && orig.isNumber()) {
            number = (PdfNumber)orig;
        }
        return number;
    }

    public PdfName getAsName(PdfName key2) {
        PdfName name = null;
        PdfObject orig = this.getDirectObject(key2);
        if (orig != null && orig.isName()) {
            name = (PdfName)orig;
        }
        return name;
    }

    public PdfBoolean getAsBoolean(PdfName key2) {
        PdfBoolean bool2 = null;
        PdfObject orig = this.getDirectObject(key2);
        if (orig != null && orig.isBoolean()) {
            bool2 = (PdfBoolean)orig;
        }
        return bool2;
    }

    public PdfIndirectReference getAsIndirectObject(PdfName key2) {
        PdfIndirectReference ref = null;
        PdfObject orig = this.get(key2);
        if (orig != null && orig.isIndirect()) {
            ref = (PdfIndirectReference)orig;
        }
        return ref;
    }
}

