/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.api.Spaceable;
import com.itextpdf.text.pdf.FloatLayout;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfDiv
implements Element,
Spaceable,
IAccessibleElement {
    private ArrayList<Element> content;
    private Float left = null;
    private Float top = null;
    private Float right = null;
    private Float bottom = null;
    private Float width = null;
    private Float height = null;
    private Float percentageHeight = null;
    private Float percentageWidth = null;
    private float contentWidth = 0.0f;
    private float contentHeight = 0.0f;
    private int textAlignment = -1;
    private float paddingLeft = 0.0f;
    private float paddingRight = 0.0f;
    private float paddingTop = 0.0f;
    private float paddingBottom = 0.0f;
    private FloatType floatType = FloatType.NONE;
    private PositionType position = PositionType.STATIC;
    private FloatLayout floatLayout = null;
    protected PdfName role = PdfName.DIV;
    protected HashMap<PdfName, PdfObject> accessibleAttributes = null;
    protected UUID id = UUID.randomUUID();
    private BaseColor backgroundColor = null;
    protected float spacingBefore;
    protected float spacingAfter;

    public float getContentWidth() {
        return this.contentWidth;
    }

    public void setContentWidth(float contentWidth) {
        this.contentWidth = contentWidth;
    }

    public float getContentHeight() {
        return this.contentHeight;
    }

    public void setContentHeight(float contentHeight) {
        this.contentHeight = contentHeight;
    }

    public float getActualHeight() {
        return this.height != null && this.height.floatValue() >= this.contentHeight ? this.height.floatValue() : this.contentHeight;
    }

    public float getActualWidth() {
        return this.width != null && this.width.floatValue() >= this.contentWidth ? this.width.floatValue() : this.contentWidth;
    }

    public Float getPercentageHeight() {
        return this.percentageHeight;
    }

    public void setPercentageHeight(Float percentageHeight) {
        this.percentageHeight = percentageHeight;
    }

    public Float getPercentageWidth() {
        return this.percentageWidth;
    }

    public void setPercentageWidth(Float percentageWidth) {
        this.percentageWidth = percentageWidth;
    }

    public BaseColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BaseColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public PdfDiv() {
        this.content = new ArrayList();
    }

    @Override
    public List<Chunk> getChunks() {
        return new ArrayList<Chunk>();
    }

    @Override
    public int type() {
        return 37;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    @Override
    public boolean process(ElementListener listener2) {
        try {
            return listener2.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    @Override
    public void setSpacingBefore(float spacing) {
        this.spacingBefore = spacing;
    }

    @Override
    public void setSpacingAfter(float spacing) {
        this.spacingAfter = spacing;
    }

    @Override
    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    @Override
    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(int textAlignment) {
        this.textAlignment = textAlignment;
    }

    public void addElement(Element element) {
        if (element instanceof PdfPTable) {
            ((PdfPTable)element).setSplitLate(false);
        }
        this.content.add(element);
    }

    public Float getLeft() {
        return this.left;
    }

    public void setLeft(Float left2) {
        this.left = left2;
    }

    public Float getRight() {
        return this.right;
    }

    public void setRight(Float right2) {
        this.right = right2;
    }

    public Float getTop() {
        return this.top;
    }

    public void setTop(Float top2) {
        this.top = top2;
    }

    public Float getBottom() {
        return this.bottom;
    }

    public void setBottom(Float bottom2) {
        this.bottom = bottom2;
    }

    public Float getWidth() {
        return this.width;
    }

    public void setWidth(Float width) {
        this.width = width;
    }

    public Float getHeight() {
        return this.height;
    }

    public void setHeight(Float height) {
        this.height = height;
    }

    public float getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(float paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public float getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(float paddingRight) {
        this.paddingRight = paddingRight;
    }

    public float getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(float paddingTop) {
        this.paddingTop = paddingTop;
    }

    public float getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(float paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public FloatType getFloatType() {
        return this.floatType;
    }

    public void setFloatType(FloatType floatType) {
        this.floatType = floatType;
    }

    public PositionType getPosition() {
        return this.position;
    }

    public void setPosition(PositionType position) {
        this.position = position;
    }

    public ArrayList<Element> getContent() {
        return this.content;
    }

    public void setContent(ArrayList<Element> content) {
        this.content = content;
    }

    public int layout(PdfContentByte canvas2, boolean useAscender, boolean simulate, float llx, float lly, float urx, float ury) throws DocumentException {
        float leftX = Math.min(llx, urx);
        float maxY = Math.max(lly, ury);
        float minY = Math.min(lly, ury);
        float rightX = Math.max(llx, urx);
        float yLine = maxY;
        boolean contentCutByFixedHeight = false;
        if (this.width != null && this.width.floatValue() > 0.0f) {
            if (this.width.floatValue() < rightX - leftX) {
                rightX = leftX + this.width.floatValue();
            } else if (this.width.floatValue() > rightX - leftX) {
                return 2;
            }
        } else if (this.percentageWidth != null) {
            this.contentWidth = (rightX - leftX) * this.percentageWidth.floatValue();
            rightX = leftX + this.contentWidth;
        }
        if (this.height != null && this.height.floatValue() > 0.0f) {
            if (this.height.floatValue() < maxY - minY) {
                minY = maxY - this.height.floatValue();
                contentCutByFixedHeight = true;
            } else if (this.height.floatValue() > maxY - minY) {
                return 2;
            }
        } else if (this.percentageHeight != null) {
            if ((double)this.percentageHeight.floatValue() < 1.0) {
                contentCutByFixedHeight = true;
            }
            this.contentHeight = (maxY - minY) * this.percentageHeight.floatValue();
            minY = maxY - this.contentHeight;
        }
        if (!simulate && this.position == PositionType.RELATIVE) {
            Float translationX = null;
            translationX = this.left != null ? this.left : (this.right != null ? Float.valueOf(-this.right.floatValue()) : Float.valueOf(0.0f));
            Float translationY = null;
            translationY = this.top != null ? Float.valueOf(-this.top.floatValue()) : (this.bottom != null ? this.bottom : Float.valueOf(0.0f));
            canvas2.saveState();
            canvas2.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, translationX.floatValue(), translationY.floatValue()));
        }
        if (!simulate && this.backgroundColor != null && this.getActualWidth() > 0.0f && this.getActualHeight() > 0.0f) {
            float backgroundWidth = this.getActualWidth();
            float backgroundHeight = this.getActualHeight();
            if (this.width != null) {
                float f = backgroundWidth = this.width.floatValue() > 0.0f ? this.width.floatValue() : 0.0f;
            }
            if (this.height != null) {
                float f = backgroundHeight = this.height.floatValue() > 0.0f ? this.height.floatValue() : 0.0f;
            }
            if (backgroundWidth > 0.0f && backgroundHeight > 0.0f) {
                Rectangle background = new Rectangle(leftX, maxY - backgroundHeight, leftX + backgroundWidth, maxY);
                background.setBackgroundColor(this.backgroundColor);
                canvas2.rectangle(background);
            }
        }
        if (this.percentageWidth == null) {
            this.contentWidth = 0.0f;
        }
        if (this.percentageHeight == null) {
            this.contentHeight = 0.0f;
        }
        minY += this.paddingBottom;
        leftX += this.paddingLeft;
        rightX -= this.paddingRight;
        yLine -= this.paddingTop;
        int status = 1;
        if (!this.content.isEmpty()) {
            ArrayList<Element> floatingElements;
            FloatLayout floatLayout = null;
            if (this.floatLayout == null) {
                floatingElements = new ArrayList<Element>();
                floatingElements.addAll(this.content);
                floatLayout = simulate ? new FloatLayout(floatingElements, useAscender) : (this.floatLayout = new FloatLayout(floatingElements, useAscender));
            } else if (simulate) {
                floatingElements = new ArrayList();
                floatingElements.addAll(this.floatLayout.content);
                floatLayout = new FloatLayout(floatingElements, useAscender);
            } else {
                floatLayout = this.floatLayout;
            }
            floatLayout.setSimpleColumn(leftX, minY, rightX, yLine);
            status = floatLayout.layout(canvas2, simulate);
            yLine = floatLayout.getYLine();
            if (this.percentageWidth == null && this.contentWidth < floatLayout.getFilledWidth()) {
                this.contentWidth = floatLayout.getFilledWidth();
            }
        }
        if (!simulate && this.position == PositionType.RELATIVE) {
            canvas2.restoreState();
        }
        yLine -= this.paddingBottom;
        if (this.percentageHeight == null) {
            this.contentHeight = maxY - yLine;
        }
        if (this.percentageWidth == null) {
            this.contentWidth += this.paddingLeft + this.paddingRight;
        }
        return contentCutByFixedHeight ? 1 : status;
    }

    @Override
    public PdfObject getAccessibleAttribute(PdfName key2) {
        if (this.accessibleAttributes != null) {
            return this.accessibleAttributes.get(key2);
        }
        return null;
    }

    @Override
    public void setAccessibleAttribute(PdfName key2, PdfObject value) {
        if (this.accessibleAttributes == null) {
            this.accessibleAttributes = new HashMap();
        }
        this.accessibleAttributes.put(key2, value);
    }

    @Override
    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        return this.accessibleAttributes;
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PositionType {
        STATIC,
        ABSOLUTE,
        FIXED,
        RELATIVE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FloatType {
        NONE,
        LEFT,
        RIGHT;

    }
}

