/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPHeaderCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.HashMap;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfPRow
implements IAccessibleElement {
    private final Logger LOGGER = LoggerFactory.getLogger(PdfPRow.class);
    public boolean mayNotBreak = false;
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    public static final float RIGHT_LIMIT = 20000.0f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float[] extraHeights;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;
    protected PdfName role = PdfName.TR;
    protected HashMap<PdfName, PdfObject> accessibleAttributes = null;
    protected UUID id = UUID.randomUUID();

    public PdfPRow(PdfPCell[] cells) {
        this(cells, null);
    }

    public PdfPRow(PdfPCell[] cells, PdfPRow source2) {
        this.cells = cells;
        this.widths = new float[cells.length];
        this.initExtraHeights();
        if (source2 != null) {
            this.id = source2.id;
            this.role = source2.role;
            if (source2.accessibleAttributes != null) {
                this.accessibleAttributes = new HashMap<PdfName, PdfObject>(source2.accessibleAttributes);
            }
        }
    }

    public PdfPRow(PdfPRow row2) {
        this.mayNotBreak = row2.mayNotBreak;
        this.maxHeight = row2.maxHeight;
        this.calculated = row2.calculated;
        this.cells = new PdfPCell[row2.cells.length];
        for (int k = 0; k < this.cells.length; ++k) {
            if (row2.cells[k] == null) continue;
            this.cells[k] = row2.cells[k] instanceof PdfPHeaderCell ? new PdfPHeaderCell((PdfPHeaderCell)row2.cells[k]) : new PdfPCell(row2.cells[k]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(row2.widths, 0, this.widths, 0, this.cells.length);
        this.initExtraHeights();
        this.id = row2.id;
        this.role = row2.role;
        if (row2.accessibleAttributes != null) {
            this.accessibleAttributes = new HashMap<PdfName, PdfObject>(row2.accessibleAttributes);
        }
    }

    public boolean setWidths(float[] widths) {
        if (widths.length != this.cells.length) {
            return false;
        }
        System.arraycopy(widths, 0, this.widths, 0, this.cells.length);
        float total = 0.0f;
        this.calculated = false;
        for (int k = 0; k < widths.length; ++k) {
            PdfPCell cell = this.cells[k];
            if (cell == null) {
                total += widths[k];
                continue;
            }
            cell.setLeft(total);
            int last = k + cell.getColspan();
            while (k < last) {
                total += widths[k];
                ++k;
            }
            --k;
            cell.setRight(total);
            cell.setTop(0.0f);
        }
        return true;
    }

    protected void initExtraHeights() {
        this.extraHeights = new float[this.cells.length];
        for (int i2 = 0; i2 < this.extraHeights.length; ++i2) {
            this.extraHeights[i2] = 0.0f;
        }
    }

    public void setExtraHeight(int cell, float height) {
        if (cell < 0 || cell >= this.cells.length) {
            return;
        }
        this.extraHeights[cell] = height;
    }

    protected void calculateHeights() {
        this.maxHeight = 0.0f;
        for (int k = 0; k < this.cells.length; ++k) {
            PdfPCell cell = this.cells[k];
            float height = 0.0f;
            if (cell == null || !((height = cell.getMaxHeight()) > this.maxHeight) || cell.getRowspan() != 1) continue;
            this.maxHeight = height;
        }
        this.calculated = true;
    }

    public void setMayNotBreak(boolean mayNotBreak) {
        this.mayNotBreak = mayNotBreak;
    }

    public boolean isMayNotBreak() {
        return this.mayNotBreak;
    }

    public void writeBorderAndBackground(float xPos, float yPos, float currentMaxHeight, PdfPCell cell, PdfContentByte[] canvases) {
        BaseColor background = cell.getBackgroundColor();
        if (background != null || cell.hasBorders()) {
            float right2 = cell.getRight() + xPos;
            float top2 = cell.getTop() + yPos;
            float left2 = cell.getLeft() + xPos;
            float bottom2 = top2 - currentMaxHeight;
            if (background != null) {
                PdfContentByte backgr = canvases[1];
                backgr.setColorFill(background);
                backgr.rectangle(left2, bottom2, right2 - left2, top2 - bottom2);
                backgr.fill();
            }
            if (cell.hasBorders()) {
                Rectangle newRect = new Rectangle(left2, bottom2, right2, top2);
                newRect.cloneNonPositionParameters(cell);
                newRect.setBackgroundColor(null);
                PdfContentByte lineCanvas = canvases[2];
                lineCanvas.rectangle(newRect);
            }
        }
    }

    protected void saveAndRotateCanvases(PdfContentByte[] canvases, float a, float b, float c, float d, float e, float f) {
        int last = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[last * 2];
        }
        for (int k = 0; k < last; ++k) {
            ByteBuffer bb = canvases[k].getInternalBuffer();
            this.canvasesPos[k * 2] = bb.size();
            canvases[k].saveState();
            canvases[k].concatCTM(a, b, c, d, e, f);
            this.canvasesPos[k * 2 + 1] = bb.size();
        }
    }

    protected void restoreCanvases(PdfContentByte[] canvases) {
        int last = 4;
        for (int k = 0; k < last; ++k) {
            ByteBuffer bb = canvases[k].getInternalBuffer();
            int p1 = bb.size();
            canvases[k].restoreState();
            if (p1 != this.canvasesPos[k * 2 + 1]) continue;
            bb.setSize(this.canvasesPos[k * 2]);
        }
    }

    public static float setColumn(ColumnText ct, float left2, float bottom2, float right2, float top2) {
        if (left2 > right2) {
            right2 = left2;
        }
        if (bottom2 > top2) {
            top2 = bottom2;
        }
        ct.setSimpleColumn(left2, bottom2, right2, top2);
        return top2;
    }

    /*
     * Unable to fully structure code
     */
    public void writeCells(int colStart, int colEnd, float xPos, float yPos, PdfContentByte[] canvases, boolean reusable) {
        if (!this.calculated) {
            this.calculateHeights();
        }
        colEnd = colEnd < 0 ? this.cells.length : Math.min(colEnd, this.cells.length);
        if (colStart < 0) {
            colStart = 0;
        }
        if (colStart >= colEnd) {
            return;
        }
        for (newStart = colStart; newStart >= 0 && this.cells[newStart] == null; --newStart) {
            if (newStart <= 0) continue;
            xPos -= this.widths[newStart - 1];
        }
        if (newStart < 0) {
            newStart = 0;
        }
        if (this.cells[newStart] != null) {
            xPos -= this.cells[newStart].getLeft();
        }
        if (PdfPRow.isTagged(canvases[3])) {
            canvases[3].openMCBlock(this);
        }
        for (k = newStart; k < colEnd; ++k) {
            cell = this.cells[k];
            if (cell == null) continue;
            if (PdfPRow.isTagged(canvases[3])) {
                canvases[3].openMCBlock(cell);
            }
            currentMaxHeight = this.maxHeight + this.extraHeights[k];
            this.writeBorderAndBackground(xPos, yPos, currentMaxHeight, cell, canvases);
            img = cell.getImage();
            tly = cell.getTop() + yPos - cell.getEffectivePaddingTop();
            if (cell.getHeight() <= currentMaxHeight) {
                switch (cell.getVerticalAlignment()) {
                    case 6: {
                        tly = cell.getTop() + yPos - currentMaxHeight + cell.getHeight() - cell.getEffectivePaddingTop();
                        break;
                    }
                    case 5: {
                        tly = cell.getTop() + yPos + (cell.getHeight() - currentMaxHeight) / 2.0f - cell.getEffectivePaddingTop();
                        break;
                    }
                }
            }
            if (img != null) {
                if (cell.getRotation() != 0) {
                    img = Image.getInstance(img);
                    img.setRotation(img.getImageRotation() + (float)((double)cell.getRotation() * 3.141592653589793 / 180.0));
                }
                vf = false;
                if (cell.getHeight() > currentMaxHeight) {
                    if (!img.isScaleToFitHeight()) continue;
                    img.scalePercent(100.0f);
                    scale = (currentMaxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom()) / img.getScaledHeight();
                    img.scalePercent(scale * 100.0f);
                    vf = true;
                }
                left = cell.getLeft() + xPos + cell.getEffectivePaddingLeft();
                if (vf) {
                    switch (cell.getHorizontalAlignment()) {
                        case 1: {
                            left = xPos + (cell.getLeft() + cell.getEffectivePaddingLeft() + cell.getRight() - cell.getEffectivePaddingRight() - img.getScaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            left = xPos + cell.getRight() - cell.getEffectivePaddingRight() - img.getScaledWidth();
                            break;
                        }
                    }
                    tly = cell.getTop() + yPos - cell.getEffectivePaddingTop();
                }
                img.setAbsolutePosition(left, tly - img.getScaledHeight());
                try {
                    if (PdfPRow.isTagged(canvases[3])) {
                        canvases[3].openMCBlock(img);
                    }
                    canvases[3].addImage(img);
                    if (!PdfPRow.isTagged(canvases[3])) ** GOTO lbl163
                    canvases[3].closeMCBlock(img);
                }
                catch (DocumentException e) {
                    throw new ExceptionConverter(e);
                }
            } else if (cell.getRotation() == 90 || cell.getRotation() == 270) {
                netWidth = currentMaxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom();
                netHeight = cell.getWidth() - cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight();
                ct = ColumnText.duplicate(cell.getColumn());
                ct.setCanvases(canvases);
                ct.setSimpleColumn(0.0f, 0.0f, netWidth + 0.001f, -netHeight);
                try {
                    ct.go(true);
                }
                catch (DocumentException e) {
                    throw new ExceptionConverter(e);
                }
                calcHeight = -ct.getYLine();
                if (netWidth <= 0.0f || netHeight <= 0.0f) {
                    calcHeight = 0.0f;
                }
                if (calcHeight > 0.0f) {
                    if (cell.isUseDescender()) {
                        calcHeight -= ct.getDescender();
                    }
                    ct = reusable != false ? ColumnText.duplicate(cell.getColumn()) : cell.getColumn();
                    ct.setCanvases(canvases);
                    ct.setSimpleColumn(-0.003f, -0.001f, netWidth + 0.003f, calcHeight);
                    if (cell.getRotation() == 90) {
                        pivotY = cell.getTop() + yPos - currentMaxHeight + cell.getEffectivePaddingBottom();
                        switch (cell.getVerticalAlignment()) {
                            case 6: {
                                pivotX = cell.getLeft() + xPos + cell.getWidth() - cell.getEffectivePaddingRight();
                                break;
                            }
                            case 5: {
                                pivotX = cell.getLeft() + xPos + (cell.getWidth() + cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight() + calcHeight) / 2.0f;
                                break;
                            }
                            default: {
                                pivotX = cell.getLeft() + xPos + cell.getEffectivePaddingLeft() + calcHeight;
                            }
                        }
                        this.saveAndRotateCanvases(canvases, 0.0f, 1.0f, -1.0f, 0.0f, pivotX, pivotY);
                    } else {
                        pivotY = cell.getTop() + yPos - cell.getEffectivePaddingTop();
                        switch (cell.getVerticalAlignment()) {
                            case 6: {
                                pivotX = cell.getLeft() + xPos + cell.getEffectivePaddingLeft();
                                break;
                            }
                            case 5: {
                                pivotX = cell.getLeft() + xPos + (cell.getWidth() + cell.getEffectivePaddingLeft() - cell.getEffectivePaddingRight() - calcHeight) / 2.0f;
                                break;
                            }
                            default: {
                                pivotX = cell.getLeft() + xPos + cell.getWidth() - cell.getEffectivePaddingRight() - calcHeight;
                            }
                        }
                        this.saveAndRotateCanvases(canvases, 0.0f, -1.0f, 1.0f, 0.0f, pivotX, pivotY);
                    }
                    try {
                        ct.go();
                    }
                    catch (DocumentException e) {
                        throw new ExceptionConverter(e);
                    }
                    finally {
                        this.restoreCanvases(canvases);
                    }
                }
            } else {
                fixedHeight = cell.getFixedHeight();
                rightLimit = cell.getRight() + xPos - cell.getEffectivePaddingRight();
                leftLimit = cell.getLeft() + xPos + cell.getEffectivePaddingLeft();
                if (cell.isNoWrap()) {
                    switch (cell.getHorizontalAlignment()) {
                        case 1: {
                            rightLimit += 10000.0f;
                            leftLimit -= 10000.0f;
                            break;
                        }
                        case 2: {
                            if (cell.getRotation() == 180) {
                                rightLimit += 20000.0f;
                                break;
                            }
                            leftLimit -= 20000.0f;
                            break;
                        }
                        default: {
                            if (cell.getRotation() == 180) {
                                leftLimit -= 20000.0f;
                                break;
                            }
                            rightLimit += 20000.0f;
                        }
                    }
                }
                ct = reusable != false ? ColumnText.duplicate(cell.getColumn()) : cell.getColumn();
                ct.setCanvases(canvases);
                bry = tly - (currentMaxHeight - cell.getEffectivePaddingTop() - cell.getEffectivePaddingBottom());
                if (fixedHeight > 0.0f && cell.getHeight() > currentMaxHeight) {
                    tly = cell.getTop() + yPos - cell.getEffectivePaddingTop();
                    bry = cell.getTop() + yPos - currentMaxHeight + cell.getEffectivePaddingBottom();
                }
                if ((tly > bry || ct.zeroHeightElement()) && leftLimit < rightLimit) {
                    ct.setSimpleColumn(leftLimit, bry - 0.001f, rightLimit, tly);
                    if (cell.getRotation() == 180) {
                        shx = leftLimit + rightLimit;
                        shy = yPos + yPos - currentMaxHeight + cell.getEffectivePaddingBottom() - cell.getEffectivePaddingTop();
                        this.saveAndRotateCanvases(canvases, -1.0f, 0.0f, 0.0f, -1.0f, shx, shy);
                    }
                    try {
                        ct.go();
                    }
                    catch (DocumentException e) {
                        throw new ExceptionConverter(e);
                    }
                    finally {
                        if (cell.getRotation() == 180) {
                            this.restoreCanvases(canvases);
                        }
                    }
                }
            }
            if ((evt = cell.getCellEvent()) != null) {
                rect = new Rectangle(cell.getLeft() + xPos, cell.getTop() + yPos - currentMaxHeight, cell.getRight() + xPos, cell.getTop() + yPos);
                evt.cellLayout(cell, rect, canvases);
            }
            if (!PdfPRow.isTagged(canvases[3])) continue;
            canvases[3].closeMCBlock(cell);
        }
        if (PdfPRow.isTagged(canvases[3])) {
            canvases[3].closeMCBlock(this);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (!this.calculated) {
            this.calculateHeights();
        }
        return this.maxHeight;
    }

    public void setMaxHeights(float maxHeight) {
        this.maxHeight = maxHeight;
    }

    float[] getEventWidth(float xPos, float[] absoluteWidths) {
        int n = 1;
        int k = 0;
        while (k < this.cells.length) {
            if (this.cells[k] != null) {
                ++n;
                k += this.cells[k].getColspan();
                continue;
            }
            while (k < this.cells.length && this.cells[k] == null) {
                ++n;
                ++k;
            }
        }
        float[] width = new float[n];
        width[0] = xPos;
        n = 1;
        int k2 = 0;
        while (k2 < this.cells.length && n < width.length) {
            if (this.cells[k2] != null) {
                int colspan = this.cells[k2].getColspan();
                width[n] = width[n - 1];
                for (int i2 = 0; i2 < colspan && k2 < absoluteWidths.length; ++i2) {
                    int n2 = n;
                    width[n2] = width[n2] + absoluteWidths[k2++];
                }
                ++n;
                continue;
            }
            width[n] = width[n - 1];
            while (k2 < this.cells.length && this.cells[k2] == null) {
                int n3 = n;
                width[n3] = width[n3] + absoluteWidths[k2++];
            }
            ++n;
        }
        return width;
    }

    public void copyRowContent(PdfPTable table, int idx) {
        if (table == null) {
            return;
        }
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            int lastRow = idx;
            PdfPCell copy2 = table.getRow(lastRow).getCells()[i2];
            while (copy2 == null && lastRow > 0) {
                copy2 = table.getRow(--lastRow).getCells()[i2];
            }
            if (this.cells[i2] == null || copy2 == null) continue;
            this.cells[i2].setColumn(copy2.getColumn());
            this.calculated = false;
        }
    }

    public PdfPRow splitRow(PdfPTable table, int rowIndex, float new_height) {
        int k;
        this.LOGGER.info("Splitting " + rowIndex + " " + new_height);
        PdfPCell[] newCells = new PdfPCell[this.cells.length];
        float[] fixHs = new float[this.cells.length];
        float[] minHs = new float[this.cells.length];
        boolean allEmpty = true;
        for (k = 0; k < this.cells.length; ++k) {
            float newHeight = new_height;
            PdfPCell cell = this.cells[k];
            if (cell == null) {
                int index = rowIndex;
                if (!table.rowSpanAbove(index, k)) continue;
                while (table.rowSpanAbove(--index, k)) {
                    newHeight += table.getRow(index).getMaxHeights();
                }
                PdfPRow row2 = table.getRow(index);
                if (row2 == null || row2.getCells()[k] == null) continue;
                newCells[k] = new PdfPCell(row2.getCells()[k]);
                newCells[k].setColumn(null);
                newCells[k].setRowspan(row2.getCells()[k].getRowspan() - rowIndex + index);
                allEmpty = false;
                continue;
            }
            fixHs[k] = cell.getFixedHeight();
            minHs[k] = cell.getMinimumHeight();
            Image img2 = cell.getImage();
            PdfPCell newCell = new PdfPCell(cell);
            if (img2 != null) {
                float padding = cell.getEffectivePaddingBottom() + cell.getEffectivePaddingTop() + 2.0f;
                if ((img2.isScaleToFitHeight() || img2.getScaledHeight() + padding < newHeight) && newHeight > padding) {
                    newCell.setPhrase(null);
                    allEmpty = false;
                }
            } else {
                boolean thisEmpty;
                int status;
                float y;
                ColumnText ct = ColumnText.duplicate(cell.getColumn());
                float left2 = cell.getLeft() + cell.getEffectivePaddingLeft();
                float bottom2 = cell.getTop() + cell.getEffectivePaddingBottom() - newHeight;
                float right2 = cell.getRight() - cell.getEffectivePaddingRight();
                float top2 = cell.getTop() - cell.getEffectivePaddingTop();
                switch (cell.getRotation()) {
                    case 90: 
                    case 270: {
                        y = PdfPRow.setColumn(ct, bottom2, left2, top2, right2);
                        break;
                    }
                    default: {
                        y = PdfPRow.setColumn(ct, left2, bottom2 + 1.0E-5f, cell.isNoWrap() ? 20000.0f : right2, top2);
                    }
                }
                try {
                    status = ct.go(true);
                }
                catch (DocumentException e) {
                    throw new ExceptionConverter(e);
                }
                boolean bl = thisEmpty = ct.getYLine() == y;
                if (thisEmpty) {
                    newCell.setColumn(ColumnText.duplicate(cell.getColumn()));
                    ct.setFilledWidth(0.0f);
                } else if ((status & 1) == 0) {
                    newCell.setColumn(ct);
                    ct.setFilledWidth(0.0f);
                } else {
                    newCell.setPhrase(null);
                }
                allEmpty = allEmpty && thisEmpty;
            }
            newCells[k] = newCell;
            cell.setFixedHeight(newHeight);
        }
        if (allEmpty) {
            for (k = 0; k < this.cells.length; ++k) {
                PdfPCell cell = this.cells[k];
                if (cell == null) continue;
                if (fixHs[k] > 0.0f) {
                    cell.setFixedHeight(fixHs[k]);
                    continue;
                }
                cell.setMinimumHeight(minHs[k]);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow split = new PdfPRow(newCells, this);
        split.widths = (float[])this.widths.clone();
        return split;
    }

    public PdfPCell[] getCells() {
        return this.cells;
    }

    public boolean hasRowspan() {
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null || this.cells[i2].getRowspan() <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public PdfObject getAccessibleAttribute(PdfName key2) {
        if (this.accessibleAttributes != null) {
            return this.accessibleAttributes.get(key2);
        }
        return null;
    }

    @Override
    public void setAccessibleAttribute(PdfName key2, PdfObject value) {
        if (this.accessibleAttributes == null) {
            this.accessibleAttributes = new HashMap();
        }
        this.accessibleAttributes.put(key2, value);
    }

    @Override
    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        return this.accessibleAttributes;
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    private static boolean isTagged(PdfContentByte canvas2) {
        return canvas2 != null && canvas2.writer != null && canvas2.writer.isTagged();
    }
}

