/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Image;
import com.itextpdf.text.LargeElement;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.api.Spaceable;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPHeaderCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTableBody;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.text.pdf.PdfPTableFooter;
import com.itextpdf.text.pdf.PdfPTableHeader;
import com.itextpdf.text.pdf.events.PdfPTableEventForwarder;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfPTable
implements LargeElement,
Spaceable,
IAccessibleElement {
    private final Logger LOGGER = LoggerFactory.getLogger(PdfPTable.class);
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    protected ArrayList<PdfPRow> rows = new ArrayList();
    protected float totalHeight = 0.0f;
    protected PdfPCell[] currentRow;
    protected int currentColIdx = 0;
    protected PdfPCell defaultCell = new PdfPCell((Phrase)null);
    protected float totalWidth = 0.0f;
    protected float[] relativeWidths;
    protected float[] absoluteWidths;
    protected PdfPTableEvent tableEvent;
    protected int headerRows;
    protected float widthPercentage = 80.0f;
    private int horizontalAlignment = 1;
    private boolean skipFirstHeader = false;
    private boolean skipLastFooter = false;
    protected boolean isColspan = false;
    protected int runDirection = 0;
    private boolean lockedWidth = false;
    private boolean splitRows = true;
    protected float spacingBefore;
    protected float spacingAfter;
    private boolean[] extendLastRow = new boolean[]{false, false};
    private boolean headersInEvent;
    private boolean splitLate = true;
    private boolean keepTogether;
    protected boolean complete = true;
    private int footerRows;
    protected boolean rowCompleted = true;
    protected boolean loopCheck = true;
    protected PdfName role = PdfName.TABLE;
    protected HashMap<PdfName, PdfObject> accessibleAttributes = null;
    protected UUID id = UUID.randomUUID();
    private PdfPTableHeader header = null;
    private PdfPTableBody body = null;
    private PdfPTableFooter footer = null;

    protected PdfPTable() {
    }

    public PdfPTable(float[] relativeWidths) {
        if (relativeWidths == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("the.widths.array.in.pdfptable.constructor.can.not.be.null", new Object[0]));
        }
        if (relativeWidths.length == 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.widths.array.in.pdfptable.constructor.can.not.have.zero.length", new Object[0]));
        }
        this.relativeWidths = new float[relativeWidths.length];
        System.arraycopy(relativeWidths, 0, this.relativeWidths, 0, relativeWidths.length);
        this.absoluteWidths = new float[relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.keepTogether = false;
    }

    public PdfPTable(int numColumns) {
        if (numColumns <= 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.number.of.columns.in.pdfptable.constructor.must.be.greater.than.zero", new Object[0]));
        }
        this.relativeWidths = new float[numColumns];
        for (int k = 0; k < numColumns; ++k) {
            this.relativeWidths[k] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.keepTogether = false;
    }

    public PdfPTable(PdfPTable table) {
        int k;
        this.copyFormat(table);
        for (k = 0; k < this.currentRow.length && table.currentRow[k] != null; ++k) {
            this.currentRow[k] = new PdfPCell(table.currentRow[k]);
        }
        for (k = 0; k < table.rows.size(); ++k) {
            PdfPRow row2 = table.rows.get(k);
            if (row2 != null) {
                row2 = new PdfPRow(row2);
            }
            this.rows.add(row2);
        }
    }

    public static PdfPTable shallowCopy(PdfPTable table) {
        PdfPTable nt = new PdfPTable();
        nt.copyFormat(table);
        return nt;
    }

    protected void copyFormat(PdfPTable sourceTable) {
        this.relativeWidths = new float[sourceTable.getNumberOfColumns()];
        this.absoluteWidths = new float[sourceTable.getNumberOfColumns()];
        System.arraycopy(sourceTable.relativeWidths, 0, this.relativeWidths, 0, this.getNumberOfColumns());
        System.arraycopy(sourceTable.absoluteWidths, 0, this.absoluteWidths, 0, this.getNumberOfColumns());
        this.totalWidth = sourceTable.totalWidth;
        this.totalHeight = sourceTable.totalHeight;
        this.currentColIdx = 0;
        this.tableEvent = sourceTable.tableEvent;
        this.runDirection = sourceTable.runDirection;
        this.defaultCell = sourceTable.defaultCell instanceof PdfPHeaderCell ? new PdfPHeaderCell((PdfPHeaderCell)sourceTable.defaultCell) : new PdfPCell(sourceTable.defaultCell);
        this.currentRow = new PdfPCell[sourceTable.currentRow.length];
        this.isColspan = sourceTable.isColspan;
        this.splitRows = sourceTable.splitRows;
        this.spacingAfter = sourceTable.spacingAfter;
        this.spacingBefore = sourceTable.spacingBefore;
        this.headerRows = sourceTable.headerRows;
        this.footerRows = sourceTable.footerRows;
        this.lockedWidth = sourceTable.lockedWidth;
        this.extendLastRow = sourceTable.extendLastRow;
        this.headersInEvent = sourceTable.headersInEvent;
        this.widthPercentage = sourceTable.widthPercentage;
        this.splitLate = sourceTable.splitLate;
        this.skipFirstHeader = sourceTable.skipFirstHeader;
        this.skipLastFooter = sourceTable.skipLastFooter;
        this.horizontalAlignment = sourceTable.horizontalAlignment;
        this.keepTogether = sourceTable.keepTogether;
        this.complete = sourceTable.complete;
        this.loopCheck = sourceTable.loopCheck;
        this.id = sourceTable.id;
        this.role = sourceTable.role;
        if (sourceTable.accessibleAttributes != null) {
            this.accessibleAttributes = new HashMap<PdfName, PdfObject>(sourceTable.accessibleAttributes);
        }
        this.header = sourceTable.getHeader();
        this.body = sourceTable.getBody();
        this.footer = sourceTable.getFooter();
    }

    public void setWidths(float[] relativeWidths) throws DocumentException {
        if (relativeWidths.length != this.getNumberOfColumns()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns", new Object[0]));
        }
        this.relativeWidths = new float[relativeWidths.length];
        System.arraycopy(relativeWidths, 0, this.relativeWidths, 0, relativeWidths.length);
        this.absoluteWidths = new float[relativeWidths.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public void setWidths(int[] relativeWidths) throws DocumentException {
        float[] tb = new float[relativeWidths.length];
        for (int k = 0; k < relativeWidths.length; ++k) {
            tb[k] = relativeWidths[k];
        }
        this.setWidths(tb);
    }

    protected void calculateWidths() {
        int k;
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float total = 0.0f;
        int numCols = this.getNumberOfColumns();
        for (k = 0; k < numCols; ++k) {
            total += this.relativeWidths[k];
        }
        for (k = 0; k < numCols; ++k) {
            this.absoluteWidths[k] = this.totalWidth * this.relativeWidths[k] / total;
        }
    }

    public void setTotalWidth(float totalWidth) {
        if (this.totalWidth == totalWidth) {
            return;
        }
        this.totalWidth = totalWidth;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public void setTotalWidth(float[] columnWidth) throws DocumentException {
        if (columnWidth.length != this.getNumberOfColumns()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns", new Object[0]));
        }
        this.totalWidth = 0.0f;
        for (int k = 0; k < columnWidth.length; ++k) {
            this.totalWidth += columnWidth[k];
        }
        this.setWidths(columnWidth);
    }

    public void setWidthPercentage(float[] columnWidth, Rectangle pageSize) throws DocumentException {
        if (columnWidth.length != this.getNumberOfColumns()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns", new Object[0]));
        }
        float totalWidth = 0.0f;
        for (int k = 0; k < columnWidth.length; ++k) {
            totalWidth += columnWidth[k];
        }
        this.widthPercentage = totalWidth / (pageSize.getRight() - pageSize.getLeft()) * 100.0f;
        this.setWidths(columnWidth);
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    public float calculateHeights() {
        if (this.totalWidth <= 0.0f) {
            return 0.0f;
        }
        this.totalHeight = 0.0f;
        for (int k = 0; k < this.rows.size(); ++k) {
            this.totalHeight += this.getRowHeight(k, true);
        }
        return this.totalHeight;
    }

    public void resetColumnCount(int newColCount) {
        if (newColCount <= 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.number.of.columns.in.pdfptable.constructor.must.be.greater.than.zero", new Object[0]));
        }
        this.relativeWidths = new float[newColCount];
        for (int k = 0; k < newColCount; ++k) {
            this.relativeWidths[k] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.totalHeight = 0.0f;
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public PdfPCell addCell(PdfPCell cell) {
        int rdir;
        this.rowCompleted = false;
        PdfPCell ncell = cell instanceof PdfPHeaderCell ? new PdfPHeaderCell((PdfPHeaderCell)cell) : new PdfPCell(cell);
        int colspan = ncell.getColspan();
        colspan = Math.max(colspan, 1);
        colspan = Math.min(colspan, this.currentRow.length - this.currentColIdx);
        ncell.setColspan(colspan);
        if (colspan != 1) {
            this.isColspan = true;
        }
        if ((rdir = ncell.getRunDirection()) == 0) {
            ncell.setRunDirection(this.runDirection);
        }
        this.skipColsWithRowspanAbove();
        boolean cellAdded = false;
        if (this.currentColIdx < this.currentRow.length) {
            this.currentRow[this.currentColIdx] = ncell;
            this.currentColIdx += colspan;
            cellAdded = true;
        }
        this.skipColsWithRowspanAbove();
        while (this.currentColIdx >= this.currentRow.length) {
            int numCols = this.getNumberOfColumns();
            if (this.runDirection == 3) {
                PdfPCell[] rtlRow = new PdfPCell[numCols];
                int rev = this.currentRow.length;
                for (int k = 0; k < this.currentRow.length; ++k) {
                    PdfPCell rcell = this.currentRow[k];
                    int cspan = rcell.getColspan();
                    rtlRow[rev -= cspan] = rcell;
                    k += cspan - 1;
                }
                this.currentRow = rtlRow;
            }
            PdfPRow row2 = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                row2.setWidths(this.absoluteWidths);
                this.totalHeight += row2.getMaxHeights();
            }
            this.rows.add(row2);
            this.currentRow = new PdfPCell[numCols];
            this.currentColIdx = 0;
            this.skipColsWithRowspanAbove();
            this.rowCompleted = true;
        }
        if (!cellAdded) {
            this.currentRow[this.currentColIdx] = ncell;
            this.currentColIdx += colspan;
        }
        return ncell;
    }

    private void skipColsWithRowspanAbove() {
        int direction = 1;
        if (this.runDirection == 3) {
            direction = -1;
        }
        while (this.rowSpanAbove(this.rows.size(), this.currentColIdx)) {
            this.currentColIdx += direction;
        }
    }

    PdfPCell cellAt(int row2, int col) {
        PdfPCell[] cells = this.rows.get(row2).getCells();
        for (int i2 = 0; i2 < cells.length; ++i2) {
            if (cells[i2] == null || col < i2 || col >= i2 + cells[i2].getColspan()) continue;
            return cells[i2];
        }
        return null;
    }

    boolean rowSpanAbove(int currRow, int currCol) {
        if (currCol >= this.getNumberOfColumns() || currCol < 0 || currRow < 1) {
            return false;
        }
        int row2 = currRow - 1;
        PdfPRow aboveRow = this.rows.get(row2);
        if (aboveRow == null) {
            return false;
        }
        PdfPCell aboveCell = this.cellAt(row2, currCol);
        while (aboveCell == null && row2 > 0) {
            if ((aboveRow = this.rows.get(--row2)) == null) {
                return false;
            }
            aboveCell = this.cellAt(row2, currCol);
        }
        int distance = currRow - row2;
        if (aboveCell.getRowspan() == 1 && distance > 1) {
            int col = currCol - 1;
            aboveRow = this.rows.get(row2 + 1);
            --distance;
            aboveCell = aboveRow.getCells()[col];
            while (aboveCell == null && col > 0) {
                aboveCell = aboveRow.getCells()[--col];
            }
        }
        return aboveCell != null && aboveCell.getRowspan() > distance;
    }

    public void addCell(String text2) {
        this.addCell(new Phrase(text2));
    }

    public void addCell(PdfPTable table) {
        this.defaultCell.setTable(table);
        PdfPCell newCell = this.addCell(this.defaultCell);
        newCell.id = UUID.randomUUID();
        this.defaultCell.setTable(null);
    }

    public void addCell(Image image) {
        this.defaultCell.setImage(image);
        PdfPCell newCell = this.addCell(this.defaultCell);
        newCell.id = UUID.randomUUID();
        this.defaultCell.setImage(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        PdfPCell newCell = this.addCell(this.defaultCell);
        newCell.id = UUID.randomUUID();
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte[] canvases) {
        return this.writeSelectedRows(0, -1, rowStart, rowEnd, xPos, yPos, canvases);
    }

    public float writeSelectedRows(int colStart, int colEnd, int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte[] canvases) {
        return this.writeSelectedRows(colStart, colEnd, rowStart, rowEnd, xPos, yPos, canvases, true);
    }

    public float writeSelectedRows(int colStart, int colEnd, int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte[] canvases, boolean reusable) {
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("the.table.width.must.be.greater.than.zero", new Object[0]));
        }
        int totalRows = this.rows.size();
        if (rowStart < 0) {
            rowStart = 0;
        }
        if (rowStart >= (rowEnd = rowEnd < 0 ? totalRows : Math.min(rowEnd, totalRows))) {
            return yPos;
        }
        int totalCols = this.getNumberOfColumns();
        colStart = colStart < 0 ? 0 : Math.min(colStart, totalCols);
        colEnd = colEnd < 0 ? totalCols : Math.min(colEnd, totalCols);
        this.LOGGER.info(String.format("Writing row %s to %s; column %s to %s", rowStart, rowEnd, colStart, colEnd));
        float yPosStart = yPos;
        PdfPTableBody currentBlock = null;
        for (int k = rowStart; k < rowEnd; ++k) {
            PdfPRow row2 = this.rows.get(k);
            if (this.getHeader().rows != null && this.getHeader().rows.contains(row2) && currentBlock == null) {
                currentBlock = this.openTableBlock(this.getHeader(), canvases[3]);
            } else if (this.getBody().rows != null && this.getBody().rows.contains(row2) && currentBlock == null) {
                currentBlock = this.openTableBlock(this.getBody(), canvases[3]);
            } else if (this.getFooter().rows != null && this.getFooter().rows.contains(row2) && currentBlock == null) {
                currentBlock = this.openTableBlock(this.getFooter(), canvases[3]);
            }
            if (row2 != null) {
                row2.writeCells(colStart, colEnd, xPos, yPos, canvases, reusable);
                yPos -= row2.getMaxHeights();
            }
            if (this.getHeader().rows != null && this.getHeader().rows.contains(row2) && (k == rowEnd - 1 || !this.getHeader().rows.contains(this.rows.get(k + 1)))) {
                currentBlock = this.closeTableBlock(this.getHeader(), canvases[3]);
                continue;
            }
            if (this.getBody().rows != null && this.getBody().rows.contains(row2) && (k == rowEnd - 1 || !this.getBody().rows.contains(this.rows.get(k + 1)))) {
                currentBlock = this.closeTableBlock(this.getBody(), canvases[3]);
                continue;
            }
            if (this.getFooter().rows == null || !this.getFooter().rows.contains(row2) || k != rowEnd - 1 && this.getFooter().rows.contains(this.rows.get(k + 1))) continue;
            currentBlock = this.closeTableBlock(this.getFooter(), canvases[3]);
        }
        if (this.tableEvent != null && colStart == 0 && colEnd == totalCols) {
            float[] heights = new float[rowEnd - rowStart + 1];
            heights[0] = yPosStart;
            for (int k = rowStart; k < rowEnd; ++k) {
                PdfPRow row3 = this.rows.get(k);
                float hr = 0.0f;
                if (row3 != null) {
                    hr = row3.getMaxHeights();
                }
                heights[k - rowStart + 1] = heights[k - rowStart] - hr;
            }
            this.tableEvent.tableLayout(this, this.getEventWidths(xPos, rowStart, rowEnd, this.headersInEvent), heights, this.headersInEvent ? this.headerRows : 0, rowStart, canvases);
        }
        return yPos;
    }

    private PdfPTableBody openTableBlock(PdfPTableBody block, PdfContentByte canvas2) {
        canvas2.openMCBlock(block);
        return block;
    }

    private PdfPTableBody closeTableBlock(PdfPTableBody block, PdfContentByte canvas2) {
        canvas2.closeMCBlock(block);
        return null;
    }

    public float writeSelectedRows(int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas2) {
        return this.writeSelectedRows(0, -1, rowStart, rowEnd, xPos, yPos, canvas2);
    }

    public float writeSelectedRows(int colStart, int colEnd, int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas2) {
        return this.writeSelectedRows(colStart, colEnd, rowStart, rowEnd, xPos, yPos, canvas2, true);
    }

    public float writeSelectedRows(int colStart, int colEnd, int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas2, boolean reusable) {
        boolean clip;
        int totalCols = this.getNumberOfColumns();
        colStart = colStart < 0 ? 0 : Math.min(colStart, totalCols);
        colEnd = colEnd < 0 ? totalCols : Math.min(colEnd, totalCols);
        boolean bl = clip = colStart != 0 || colEnd != totalCols;
        if (clip) {
            float w = 0.0f;
            for (int k = colStart; k < colEnd; ++k) {
                w += this.absoluteWidths[k];
            }
            canvas2.saveState();
            float lx = colStart == 0 ? 10000.0f : 0.0f;
            float rx = colEnd == totalCols ? 10000.0f : 0.0f;
            canvas2.rectangle(xPos - lx, -10000.0f, w + lx + rx, 20000.0f);
            canvas2.clip();
            canvas2.newPath();
        }
        PdfContentByte[] canvases = PdfPTable.beginWritingRows(canvas2);
        float y = this.writeSelectedRows(colStart, colEnd, rowStart, rowEnd, xPos, yPos, canvases, reusable);
        PdfPTable.endWritingRows(canvases);
        if (clip) {
            canvas2.restoreState();
        }
        return y;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte canvas2) {
        return new PdfContentByte[]{canvas2, canvas2.getDuplicate(), canvas2.getDuplicate(), canvas2.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] canvases) {
        PdfContentByte canvas2 = canvases[0];
        canvas2.saveState();
        canvas2.add(canvases[1]);
        canvas2.restoreState();
        canvas2.saveState();
        canvas2.setLineCap(2);
        canvas2.resetRGBColorStroke();
        canvas2.add(canvases[2]);
        canvas2.restoreState();
        canvas2.add(canvases[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int idx) {
        return this.getRowHeight(idx, false);
    }

    protected float getRowHeight(int idx, boolean firsttime) {
        if (this.totalWidth <= 0.0f || idx < 0 || idx >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow row2 = this.rows.get(idx);
        if (row2 == null) {
            return 0.0f;
        }
        if (firsttime) {
            row2.setWidths(this.absoluteWidths);
        }
        float height = row2.getMaxHeights();
        for (int i2 = 0; i2 < this.relativeWidths.length; ++i2) {
            if (!this.rowSpanAbove(idx, i2)) continue;
            int rs = 1;
            while (this.rowSpanAbove(idx - rs, i2)) {
                ++rs;
            }
            PdfPRow tmprow = this.rows.get(idx - rs);
            PdfPCell cell = tmprow.getCells()[i2];
            float tmp = 0.0f;
            if (cell != null && cell.getRowspan() == rs + 1) {
                tmp = cell.getMaxHeight();
                while (rs > 0) {
                    tmp -= this.getRowHeight(idx - rs);
                    --rs;
                }
            }
            if (!(tmp > height)) continue;
            height = tmp;
        }
        row2.setMaxHeights(height);
        return height;
    }

    public float getRowspanHeight(int rowIndex, int cellIndex) {
        if (this.totalWidth <= 0.0f || rowIndex < 0 || rowIndex >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow row2 = this.rows.get(rowIndex);
        if (row2 == null || cellIndex >= row2.getCells().length) {
            return 0.0f;
        }
        PdfPCell cell = row2.getCells()[cellIndex];
        if (cell == null) {
            return 0.0f;
        }
        float rowspanHeight = 0.0f;
        for (int j = 0; j < cell.getRowspan(); ++j) {
            rowspanHeight += this.getRowHeight(rowIndex + j);
        }
        return rowspanHeight;
    }

    public boolean hasRowspan(int rowIdx) {
        PdfPRow previousRow;
        if (rowIdx < this.rows.size() && this.getRow(rowIdx).hasRowspan()) {
            return true;
        }
        PdfPRow pdfPRow = previousRow = rowIdx > 0 ? this.getRow(rowIdx - 1) : null;
        if (previousRow != null && previousRow.hasRowspan()) {
            return true;
        }
        for (int i2 = 0; i2 < this.getNumberOfColumns(); ++i2) {
            if (!this.rowSpanAbove(rowIdx - 1, i2)) continue;
            return true;
        }
        return false;
    }

    public void normalizeHeadersFooters() {
        if (this.footerRows > this.headerRows) {
            this.footerRows = this.headerRows;
        }
    }

    public float getHeaderHeight() {
        float total = 0.0f;
        int size = Math.min(this.rows.size(), this.headerRows);
        for (int k = 0; k < size; ++k) {
            PdfPRow row2 = this.rows.get(k);
            if (row2 == null) continue;
            total += row2.getMaxHeights();
        }
        return total;
    }

    public float getFooterHeight() {
        float total = 0.0f;
        int start2 = Math.max(0, this.headerRows - this.footerRows);
        int size = Math.min(this.rows.size(), this.headerRows);
        for (int k = start2; k < size; ++k) {
            PdfPRow row2 = this.rows.get(k);
            if (row2 == null) continue;
            total += row2.getMaxHeights();
        }
        return total;
    }

    public boolean deleteRow(int rowNumber) {
        PdfPRow row2;
        if (rowNumber < 0 || rowNumber >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f && (row2 = this.rows.get(rowNumber)) != null) {
            this.totalHeight -= row2.getMaxHeights();
        }
        this.rows.remove(rowNumber);
        if (rowNumber < this.headerRows) {
            --this.headerRows;
            if (rowNumber >= this.headerRows - this.footerRows) {
                --this.footerRows;
            }
        }
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public void deleteBodyRows() {
        ArrayList<PdfPRow> rows2 = new ArrayList<PdfPRow>();
        for (int k = 0; k < this.headerRows; ++k) {
            rows2.add(this.rows.get(k));
        }
        this.rows = rows2;
        this.totalHeight = 0.0f;
        if (this.totalWidth > 0.0f) {
            this.totalHeight = this.getHeaderHeight();
        }
    }

    public int getNumberOfColumns() {
        return this.relativeWidths.length;
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int headerRows) {
        if (headerRows < 0) {
            headerRows = 0;
        }
        this.headerRows = headerRows;
    }

    @Override
    public List<Chunk> getChunks() {
        return new ArrayList<Chunk>();
    }

    @Override
    public int type() {
        return 23;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    @Override
    public boolean process(ElementListener listener2) {
        try {
            return listener2.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float widthPercentage) {
        this.widthPercentage = widthPercentage;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public PdfPRow getRow(int idx) {
        return this.rows.get(idx);
    }

    public ArrayList<PdfPRow> getRows() {
        return this.rows;
    }

    public int getLastCompletedRowIndex() {
        return this.rows.size() - 1;
    }

    public void setBreakPoints(int ... breakPoints) {
        int i2;
        for (i2 = 0; i2 < this.rows.size(); ++i2) {
            this.getRow(i2).setMayNotBreak(true);
        }
        for (i2 = 0; i2 < breakPoints.length; ++i2) {
            this.getRow(breakPoints[i2]).setMayNotBreak(false);
        }
    }

    public void keepRowsTogether(int[] rows) {
        for (int i2 = 0; i2 < rows.length; ++i2) {
            this.getRow(rows[i2]).setMayNotBreak(true);
        }
    }

    public void keepRowsTogether(int start2, int end) {
        if (start2 < end) {
            while (start2 < end) {
                this.getRow(start2).setMayNotBreak(true);
                ++start2;
            }
        }
    }

    public void keepRowsTogether(int start2) {
        if (start2 < this.rows.size()) {
            for (int i2 = start2; i2 < this.rows.size(); ++i2) {
                this.getRow(i2).setMayNotBreak(true);
            }
        }
    }

    public ArrayList<PdfPRow> getRows(int start2, int end) {
        ArrayList<PdfPRow> list2 = new ArrayList<PdfPRow>();
        if (start2 < 0 || end > this.size()) {
            return list2;
        }
        for (int i2 = start2; i2 < end; ++i2) {
            list2.add(this.adjustCellsInRow(i2, end));
        }
        return list2;
    }

    protected PdfPRow adjustCellsInRow(int start2, int end) {
        PdfPRow row2 = new PdfPRow(this.getRow(start2));
        PdfPCell[] cells = row2.getCells();
        for (int i2 = 0; i2 < cells.length; ++i2) {
            PdfPCell cell = cells[i2];
            if (cell == null || cell.getRowspan() == 1) continue;
            int stop2 = Math.min(end, start2 + cell.getRowspan());
            float extra = 0.0f;
            for (int k = start2 + 1; k < stop2; ++k) {
                extra += this.getRow(k).getMaxHeights();
            }
            row2.setExtraHeight(i2, extra);
        }
        return row2;
    }

    public void setTableEvent(PdfPTableEvent event) {
        if (event == null) {
            this.tableEvent = null;
        } else if (this.tableEvent == null) {
            this.tableEvent = event;
        } else if (this.tableEvent instanceof PdfPTableEventForwarder) {
            ((PdfPTableEventForwarder)this.tableEvent).addTableEvent(event);
        } else {
            PdfPTableEventForwarder forward = new PdfPTableEventForwarder();
            forward.addTableEvent(this.tableEvent);
            forward.addTableEvent(event);
            this.tableEvent = forward;
        }
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    float[][] getEventWidths(float xPos, int firstRow, int lastRow, boolean includeHeaders) {
        if (includeHeaders) {
            firstRow = Math.max(firstRow, this.headerRows);
            lastRow = Math.max(lastRow, this.headerRows);
        }
        float[][] widths = new float[(includeHeaders ? this.headerRows : 0) + lastRow - firstRow][];
        if (this.isColspan) {
            int n = 0;
            if (includeHeaders) {
                for (int k = 0; k < this.headerRows; ++k) {
                    PdfPRow row2 = this.rows.get(k);
                    if (row2 == null) {
                        ++n;
                        continue;
                    }
                    widths[n++] = row2.getEventWidth(xPos, this.absoluteWidths);
                }
            }
            while (firstRow < lastRow) {
                PdfPRow row3 = this.rows.get(firstRow);
                if (row3 == null) {
                    ++n;
                } else {
                    widths[n++] = row3.getEventWidth(xPos, this.absoluteWidths);
                }
                ++firstRow;
            }
        } else {
            int k;
            int numCols = this.getNumberOfColumns();
            float[] width = new float[numCols + 1];
            width[0] = xPos;
            for (k = 0; k < numCols; ++k) {
                width[k + 1] = width[k] + this.absoluteWidths[k];
            }
            for (k = 0; k < widths.length; ++k) {
                widths[k] = width;
            }
        }
        return widths;
    }

    public boolean isSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public boolean isSkipLastFooter() {
        return this.skipLastFooter;
    }

    public void setSkipFirstHeader(boolean skipFirstHeader) {
        this.skipFirstHeader = skipFirstHeader;
    }

    public void setSkipLastFooter(boolean skipLastFooter) {
        this.skipLastFooter = skipLastFooter;
    }

    public void setRunDirection(int runDirection) {
        switch (runDirection) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.runDirection = runDirection;
                break;
            }
            default: {
                throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.run.direction.1", runDirection));
            }
        }
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public boolean isLockedWidth() {
        return this.lockedWidth;
    }

    public void setLockedWidth(boolean lockedWidth) {
        this.lockedWidth = lockedWidth;
    }

    public boolean isSplitRows() {
        return this.splitRows;
    }

    public void setSplitRows(boolean splitRows) {
        this.splitRows = splitRows;
    }

    @Override
    public void setSpacingBefore(float spacing) {
        this.spacingBefore = spacing;
    }

    @Override
    public void setSpacingAfter(float spacing) {
        this.spacingAfter = spacing;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public boolean isExtendLastRow() {
        return this.extendLastRow[0];
    }

    public void setExtendLastRow(boolean extendLastRows) {
        this.extendLastRow[0] = extendLastRows;
        this.extendLastRow[1] = extendLastRows;
    }

    public void setExtendLastRow(boolean extendLastRows, boolean extendFinalRow) {
        this.extendLastRow[0] = extendLastRows;
        this.extendLastRow[1] = extendFinalRow;
    }

    public boolean isExtendLastRow(boolean newPageFollows) {
        if (newPageFollows) {
            return this.extendLastRow[0];
        }
        return this.extendLastRow[1];
    }

    public boolean isHeadersInEvent() {
        return this.headersInEvent;
    }

    public void setHeadersInEvent(boolean headersInEvent) {
        this.headersInEvent = headersInEvent;
    }

    public boolean isSplitLate() {
        return this.splitLate;
    }

    public void setSplitLate(boolean splitLate) {
        this.splitLate = splitLate;
    }

    public void setKeepTogether(boolean keepTogether) {
        this.keepTogether = keepTogether;
    }

    public boolean getKeepTogether() {
        return this.keepTogether;
    }

    public int getFooterRows() {
        return this.footerRows;
    }

    public void setFooterRows(int footerRows) {
        if (footerRows < 0) {
            footerRows = 0;
        }
        this.footerRows = footerRows;
    }

    public void completeRow() {
        while (!this.rowCompleted) {
            this.addCell(this.defaultCell);
        }
    }

    @Override
    public void flushContent() {
        this.deleteBodyRows();
        this.setSkipFirstHeader(true);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    @Override
    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public boolean isLoopCheck() {
        return this.loopCheck;
    }

    public void setLoopCheck(boolean loopCheck) {
        this.loopCheck = loopCheck;
    }

    @Override
    public PdfObject getAccessibleAttribute(PdfName key2) {
        if (this.accessibleAttributes != null) {
            return this.accessibleAttributes.get(key2);
        }
        return null;
    }

    @Override
    public void setAccessibleAttribute(PdfName key2, PdfObject value) {
        if (this.accessibleAttributes == null) {
            this.accessibleAttributes = new HashMap();
        }
        this.accessibleAttributes.put(key2, value);
    }

    @Override
    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        return this.accessibleAttributes;
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public PdfPTableHeader getHeader() {
        if (this.header == null) {
            this.header = new PdfPTableHeader();
        }
        return this.header;
    }

    public PdfPTableBody getBody() {
        if (this.body == null) {
            this.body = new PdfPTableBody();
        }
        return this.body;
    }

    public PdfPTableFooter getFooter() {
        if (this.footer == null) {
            this.footer = new PdfPTableFooter();
        }
        return this.footer;
    }
}

