/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.factories.RomanAlphabetFactory;
import com.itextpdf.text.factories.RomanNumberFactory;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfNumberTree;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PdfPageLabels {
    public static final int DECIMAL_ARABIC_NUMERALS = 0;
    public static final int UPPERCASE_ROMAN_NUMERALS = 1;
    public static final int LOWERCASE_ROMAN_NUMERALS = 2;
    public static final int UPPERCASE_LETTERS = 3;
    public static final int LOWERCASE_LETTERS = 4;
    public static final int EMPTY = 5;
    static PdfName[] numberingStyle = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    private HashMap<Integer, PdfDictionary> map = new HashMap();

    public PdfPageLabels() {
        this.addPageLabel(1, 0, null, 1);
    }

    public void addPageLabel(int page, int numberStyle, String text2, int firstPage) {
        if (page < 1 || firstPage < 1) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("in.a.page.label.the.page.numbers.must.be.greater.or.equal.to.1", new Object[0]));
        }
        PdfDictionary dic = new PdfDictionary();
        if (numberStyle >= 0 && numberStyle < numberingStyle.length) {
            dic.put(PdfName.S, numberingStyle[numberStyle]);
        }
        if (text2 != null) {
            dic.put(PdfName.P, new PdfString(text2, "UnicodeBig"));
        }
        if (firstPage != 1) {
            dic.put(PdfName.ST, new PdfNumber(firstPage));
        }
        this.map.put(page - 1, dic);
    }

    public void addPageLabel(int page, int numberStyle, String text2) {
        this.addPageLabel(page, numberStyle, text2, 1);
    }

    public void addPageLabel(int page, int numberStyle) {
        this.addPageLabel(page, numberStyle, null, 1);
    }

    public void addPageLabel(PdfPageLabelFormat format) {
        this.addPageLabel(format.physicalPage, format.numberStyle, format.prefix, format.logicalPage);
    }

    public void removePageLabel(int page) {
        if (page <= 1) {
            return;
        }
        this.map.remove(page - 1);
    }

    public PdfDictionary getDictionary(PdfWriter writer) {
        try {
            return PdfNumberTree.writeTree(this.map, writer);
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    public static String[] getPageLabels(PdfReader reader) {
        int n = reader.getNumberOfPages();
        PdfDictionary dict = reader.getCatalog();
        PdfDictionary labels = (PdfDictionary)PdfReader.getPdfObjectRelease(dict.get(PdfName.PAGELABELS));
        if (labels == null) {
            return null;
        }
        String[] labelstrings = new String[n];
        HashMap<Integer, PdfObject> numberTree = PdfNumberTree.readTree(labels);
        int pagecount = 1;
        String prefix = "";
        int type2 = 68;
        for (int i2 = 0; i2 < n; ++i2) {
            Integer current = i2;
            if (numberTree.containsKey(current)) {
                PdfDictionary d = (PdfDictionary)PdfReader.getPdfObjectRelease(numberTree.get(current));
                pagecount = d.contains(PdfName.ST) ? ((PdfNumber)d.get(PdfName.ST)).intValue() : 1;
                if (d.contains(PdfName.P)) {
                    prefix = ((PdfString)d.get(PdfName.P)).toUnicodeString();
                }
                type2 = d.contains(PdfName.S) ? (int)((PdfName)d.get(PdfName.S)).toString().charAt(1) : 101;
            }
            switch (type2) {
                default: {
                    labelstrings[i2] = prefix + pagecount;
                    break;
                }
                case 82: {
                    labelstrings[i2] = prefix + RomanNumberFactory.getUpperCaseString(pagecount);
                    break;
                }
                case 114: {
                    labelstrings[i2] = prefix + RomanNumberFactory.getLowerCaseString(pagecount);
                    break;
                }
                case 65: {
                    labelstrings[i2] = prefix + RomanAlphabetFactory.getUpperCaseString(pagecount);
                    break;
                }
                case 97: {
                    labelstrings[i2] = prefix + RomanAlphabetFactory.getLowerCaseString(pagecount);
                    break;
                }
                case 101: {
                    labelstrings[i2] = prefix;
                }
            }
            ++pagecount;
        }
        return labelstrings;
    }

    public static PdfPageLabelFormat[] getPageLabelFormats(PdfReader reader) {
        PdfDictionary dict = reader.getCatalog();
        PdfDictionary labels = (PdfDictionary)PdfReader.getPdfObjectRelease(dict.get(PdfName.PAGELABELS));
        if (labels == null) {
            return null;
        }
        HashMap<Integer, PdfObject> numberTree = PdfNumberTree.readTree(labels);
        Object[] numbers = new Integer[numberTree.size()];
        numbers = numberTree.keySet().toArray(numbers);
        Arrays.sort(numbers);
        PdfPageLabelFormat[] formats = new PdfPageLabelFormat[numberTree.size()];
        for (int k = 0; k < numbers.length; ++k) {
            int numberStyle;
            Object key2 = numbers[k];
            PdfDictionary d = (PdfDictionary)PdfReader.getPdfObjectRelease(numberTree.get(key2));
            int pagecount = d.contains(PdfName.ST) ? ((PdfNumber)d.get(PdfName.ST)).intValue() : 1;
            String prefix = d.contains(PdfName.P) ? ((PdfString)d.get(PdfName.P)).toUnicodeString() : "";
            if (d.contains(PdfName.S)) {
                char type2 = ((PdfName)d.get(PdfName.S)).toString().charAt(1);
                switch (type2) {
                    case 'R': {
                        numberStyle = 1;
                        break;
                    }
                    case 'r': {
                        numberStyle = 2;
                        break;
                    }
                    case 'A': {
                        numberStyle = 3;
                        break;
                    }
                    case 'a': {
                        numberStyle = 4;
                        break;
                    }
                    default: {
                        numberStyle = 0;
                        break;
                    }
                }
            } else {
                numberStyle = 5;
            }
            formats[k] = new PdfPageLabelFormat((Integer)key2 + 1, numberStyle, prefix, pagecount);
        }
        return formats;
    }

    public static class PdfPageLabelFormat {
        public int physicalPage;
        public int numberStyle;
        public String prefix;
        public int logicalPage;

        public PdfPageLabelFormat(int physicalPage, int numberStyle, String prefix, int logicalPage) {
            this.physicalPage = physicalPage;
            this.numberStyle = numberStyle;
            this.prefix = prefix;
            this.logicalPage = logicalPage;
        }
    }
}

