/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfStructureTreeRoot;
import java.io.IOException;
import java.util.Map;

public class PdfStructTreeController {
    private PdfDictionary structTreeRoot;
    private PdfCopy writer;
    private PdfStructureTreeRoot structureTreeRoot;
    private PdfDictionary parentTree;
    protected PdfReader reader;
    private PdfDictionary roleMap = null;
    private PdfDictionary sourceRoleMap = null;
    private PdfDictionary sourceClassMap = null;
    public static final PdfName[] standardTypes = new PdfName[]{PdfName.P, PdfName.H, PdfName.H1, PdfName.H2, PdfName.H3, PdfName.H4, PdfName.H5, PdfName.H6, PdfName.L, PdfName.LBL, PdfName.LI, PdfName.LBODY, PdfName.TABLE, PdfName.TABLEROW, PdfName.TH, PdfName.TD, PdfName.THEAD, PdfName.TBODY, PdfName.TFOOT, PdfName.SPAN, PdfName.QUOTE, PdfName.NOTE, PdfName.REFERENCE, PdfName.BIBENTRY, PdfName.CODE, PdfName.LINK, PdfName.ANNOT, PdfName.RUBY, PdfName.WARICHU};

    protected PdfStructTreeController(PdfReader reader, PdfCopy writer) throws BadPdfFormatException {
        if (!writer.isTagged()) {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("no.structtreeroot.found", new Object[0]));
        }
        this.writer = writer;
        this.structureTreeRoot = writer.getStructureTreeRoot();
        this.structureTreeRoot.put(PdfName.PARENTTREE, new PdfDictionary(PdfName.STRUCTELEM));
        this.setReader(reader);
    }

    protected void setReader(PdfReader reader) throws BadPdfFormatException {
        this.reader = reader;
        PdfObject obj = reader.getCatalog().get(PdfName.STRUCTTREEROOT);
        if ((obj = PdfStructTreeController.getDirectObject(obj)) == null || !obj.isDictionary()) {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("no.structtreeroot.found", new Object[0]));
        }
        this.structTreeRoot = (PdfDictionary)obj;
        obj = PdfStructTreeController.getDirectObject(this.structTreeRoot.get(PdfName.PARENTTREE));
        if (!obj.isDictionary()) {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("the.document.does.not.contain.parenttree", new Object[0]));
        }
        this.parentTree = (PdfDictionary)obj;
        this.sourceRoleMap = null;
        this.sourceClassMap = null;
    }

    public static PdfObject getDirectObject(PdfObject object) {
        if (object == null) {
            return null;
        }
        while (object.isIndirect()) {
            object = PdfReader.getPdfObjectRelease(object);
        }
        return object;
    }

    public void copyStructTreeForPage(PdfNumber sourceArrayNumber, int newArrayNumber) throws BadPdfFormatException, IOException {
        if (this.copyPageMarks(this.parentTree, sourceArrayNumber, newArrayNumber) == returnType.NOTFOUND) {
            throw new BadPdfFormatException(MessageLocalization.getComposedMessage("invalid.structparent", new Object[0]));
        }
    }

    private returnType copyPageMarks(PdfDictionary parentTree, PdfNumber arrayNumber, int newArrayNumber) throws BadPdfFormatException, IOException {
        PdfArray pages = (PdfArray)PdfStructTreeController.getDirectObject(parentTree.get(PdfName.NUMS));
        if (pages == null) {
            PdfArray kids = (PdfArray)PdfStructTreeController.getDirectObject(parentTree.get(PdfName.KIDS));
            if (kids == null) {
                return returnType.NOTFOUND;
            }
            int cur = kids.size() / 2;
            int begin = 0;
            block5: while (true) {
                PdfDictionary kidTree = (PdfDictionary)PdfStructTreeController.getDirectObject(kids.getPdfObject(cur + begin));
                switch (this.copyPageMarks(kidTree, arrayNumber, newArrayNumber)) {
                    case FOUND: {
                        return returnType.FOUND;
                    }
                    case ABOVE: {
                        begin += cur;
                        if ((cur /= 2) == 0) {
                            cur = 1;
                        }
                        if (cur + begin != kids.size()) continue block5;
                        return returnType.ABOVE;
                    }
                    case BELOW: {
                        if (cur + begin == 0) {
                            return returnType.BELOW;
                        }
                        if (cur == 0) {
                            return returnType.NOTFOUND;
                        }
                        cur /= 2;
                        continue block5;
                    }
                }
                break;
            }
            return returnType.NOTFOUND;
        }
        if (pages.size() == 0) {
            return returnType.NOTFOUND;
        }
        return this.findAndCopyMarks(pages, arrayNumber.intValue(), newArrayNumber);
    }

    private returnType findAndCopyMarks(PdfArray pages, int arrayNumber, int newArrayNumber) throws BadPdfFormatException, IOException {
        if (pages.getAsNumber(0).intValue() > arrayNumber) {
            return returnType.BELOW;
        }
        if (pages.getAsNumber(pages.size() - 2).intValue() < arrayNumber) {
            return returnType.ABOVE;
        }
        int cur = pages.size() / 4;
        int begin = 0;
        while (true) {
            int curNumber;
            if ((curNumber = pages.getAsNumber((begin + cur) * 2).intValue()) == arrayNumber) {
                PdfObject obj = pages.getPdfObject((begin + cur) * 2 + 1);
                while (obj.isIndirect()) {
                    obj = PdfReader.getPdfObjectRelease(obj);
                }
                if (!obj.isArray()) {
                    return returnType.NOTFOUND;
                }
                PdfObject firstNotNullKid = null;
                for (PdfObject numObj : (PdfArray)obj) {
                    if (numObj.isNull()) continue;
                    PdfObject res = this.writer.copyObject(numObj, true, false);
                    if (firstNotNullKid == null) {
                        firstNotNullKid = res;
                    }
                    this.structureTreeRoot.setPageMark(newArrayNumber, (PdfIndirectReference)res);
                }
                PdfObject structKids = this.structTreeRoot.get(PdfName.K);
                if (structKids == null || !structKids.isArray() && !structKids.isIndirect()) {
                    this.addKid(this.structureTreeRoot, firstNotNullKid);
                } else if (structKids.isIndirect()) {
                    this.addKid(structKids);
                } else {
                    for (PdfObject kid : (PdfArray)structKids) {
                        this.addKid(kid);
                    }
                }
                return returnType.FOUND;
            }
            if (curNumber < arrayNumber) {
                begin += cur;
                if ((cur /= 2) == 0) {
                    cur = 1;
                }
                if (cur + begin != pages.size()) continue;
                return returnType.NOTFOUND;
            }
            if (cur + begin == 0) {
                return returnType.BELOW;
            }
            if (cur == 0) {
                return returnType.NOTFOUND;
            }
            cur /= 2;
        }
    }

    private void addKid(PdfObject obj) throws IOException, BadPdfFormatException {
        if (!obj.isIndirect()) {
            return;
        }
        PRIndirectReference currRef = (PRIndirectReference)obj;
        PdfCopy.RefKey key2 = new PdfCopy.RefKey(currRef);
        if (!this.writer.indirects.containsKey(key2)) {
            this.writer.copyIndirect(currRef, true, false);
        }
        PdfIndirectReference newKid = this.writer.indirects.get(key2).getRef();
        if (this.writer.updateRootKids) {
            this.addKid(this.structureTreeRoot, newKid);
        }
    }

    private static PdfArray getDirectArray(PdfArray in) {
        PdfArray out = new PdfArray();
        for (int i2 = 0; i2 < in.size(); ++i2) {
            PdfObject value = PdfStructTreeController.getDirectObject(in.getPdfObject(i2));
            if (value == null) continue;
            if (value.isArray()) {
                out.add(PdfStructTreeController.getDirectArray((PdfArray)value));
                continue;
            }
            if (value.isDictionary()) {
                out.add(PdfStructTreeController.getDirectDict((PdfDictionary)value));
                continue;
            }
            out.add(value);
        }
        return out;
    }

    private static PdfDictionary getDirectDict(PdfDictionary in) {
        PdfDictionary out = new PdfDictionary();
        for (Map.Entry<PdfName, PdfObject> entry : in.hashMap.entrySet()) {
            PdfObject value = PdfStructTreeController.getDirectObject(entry.getValue());
            if (value == null) continue;
            if (value.isArray()) {
                out.put(entry.getKey(), PdfStructTreeController.getDirectArray((PdfArray)value));
                continue;
            }
            if (value.isDictionary()) {
                out.put(entry.getKey(), PdfStructTreeController.getDirectDict((PdfDictionary)value));
                continue;
            }
            out.put(entry.getKey(), value);
        }
        return out;
    }

    public static boolean compareObjects(PdfObject value1, PdfObject value2) {
        if ((value2 = PdfStructTreeController.getDirectObject(value2)) == null) {
            return false;
        }
        if (value1.type() != value2.type()) {
            return false;
        }
        if (value1.isBoolean()) {
            if (value1 == value2) {
                return true;
            }
            if (value2 instanceof PdfBoolean) {
                return ((PdfBoolean)value1).booleanValue() == ((PdfBoolean)value2).booleanValue();
            }
            return false;
        }
        if (value1.isName()) {
            return value1.equals(value2);
        }
        if (value1.isNumber()) {
            if (value1 == value2) {
                return true;
            }
            if (value2 instanceof PdfNumber) {
                return ((PdfNumber)value1).doubleValue() == ((PdfNumber)value2).doubleValue();
            }
            return false;
        }
        if (value1.isNull()) {
            if (value1 == value2) {
                return true;
            }
            return value2 instanceof PdfNull;
        }
        if (value1.isString()) {
            if (value1 == value2) {
                return true;
            }
            if (value2 instanceof PdfString) {
                return ((PdfString)value2).value == null && ((PdfString)value1).value == null || ((PdfString)value1).value != null && ((PdfString)value1).value.equals(((PdfString)value2).value);
            }
            return false;
        }
        if (value1.isArray()) {
            PdfArray array1 = (PdfArray)value1;
            PdfArray array2 = (PdfArray)value2;
            if (array1.size() != array2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < array1.size(); ++i2) {
                if (PdfStructTreeController.compareObjects(array1.getPdfObject(i2), array2.getPdfObject(i2))) continue;
                return false;
            }
            return true;
        }
        if (value1.isDictionary()) {
            PdfDictionary first = (PdfDictionary)value1;
            PdfDictionary second = (PdfDictionary)value2;
            if (first.size() != second.size()) {
                return false;
            }
            for (PdfName name : first.hashMap.keySet()) {
                if (PdfStructTreeController.compareObjects(first.get(name), second.get(name))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void addClass(PdfObject object) throws BadPdfFormatException {
        if ((object = PdfStructTreeController.getDirectObject(object)).isDictionary()) {
            PdfObject curClass = ((PdfDictionary)object).get(PdfName.C);
            if (curClass == null) {
                return;
            }
            if (curClass.isArray()) {
                PdfArray array = (PdfArray)curClass;
                for (int i2 = 0; i2 < array.size(); ++i2) {
                    this.addClass(array.getPdfObject(i2));
                }
            } else if (curClass.isName()) {
                this.addClass(curClass);
            }
        } else if (object.isName()) {
            PdfName name = (PdfName)object;
            if (this.sourceClassMap == null) {
                object = PdfStructTreeController.getDirectObject(this.structTreeRoot.get(PdfName.CLASSMAP));
                if (object == null || !object.isDictionary()) {
                    return;
                }
                this.sourceClassMap = (PdfDictionary)object;
            }
            if ((object = PdfStructTreeController.getDirectObject(this.sourceClassMap.get(name))) == null) {
                return;
            }
            PdfObject put2 = this.structureTreeRoot.getMappedClass(name);
            if (put2 != null) {
                if (!PdfStructTreeController.compareObjects(put2, object)) {
                    throw new BadPdfFormatException(MessageLocalization.getComposedMessage("conflict.in.classmap", name));
                }
            } else if (object.isDictionary()) {
                this.structureTreeRoot.mapClass(name, PdfStructTreeController.getDirectDict((PdfDictionary)object));
            } else if (object.isArray()) {
                this.structureTreeRoot.mapClass(name, PdfStructTreeController.getDirectArray((PdfArray)object));
            }
        }
    }

    protected void addRole(PdfName structType) throws BadPdfFormatException {
        PdfObject object;
        if (structType == null) {
            return;
        }
        for (PdfName name : standardTypes) {
            if (!name.equals(structType)) continue;
            return;
        }
        if (this.sourceRoleMap == null) {
            object = PdfStructTreeController.getDirectObject(this.structTreeRoot.get(PdfName.ROLEMAP));
            if (object == null || !object.isDictionary()) {
                return;
            }
            this.sourceRoleMap = (PdfDictionary)object;
        }
        if ((object = this.sourceRoleMap.get(structType)) == null || !object.isName()) {
            return;
        }
        if (this.roleMap == null) {
            this.roleMap = new PdfDictionary();
            this.structureTreeRoot.put(PdfName.ROLEMAP, this.roleMap);
            this.roleMap.put(structType, object);
        } else {
            PdfObject currentRole = this.roleMap.get(structType);
            if (currentRole != null) {
                if (!currentRole.equals(object)) {
                    throw new BadPdfFormatException(MessageLocalization.getComposedMessage("conflict.in.rolemap", object));
                }
            } else {
                this.roleMap.put(structType, object);
            }
        }
    }

    protected void addKid(PdfDictionary parent, PdfObject kid) {
        PdfArray kids;
        PdfObject kidObj = parent.get(PdfName.K);
        if (kidObj instanceof PdfArray) {
            kids = (PdfArray)kidObj;
        } else {
            kids = new PdfArray();
            if (kidObj != null) {
                kids.add(kidObj);
            }
        }
        kids.add(kid);
        parent.put(PdfName.K, kids);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum returnType {
        BELOW,
        FOUND,
        ABOVE,
        NOTFOUND;

    }
}

