/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.draw;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.draw.VerticalPositionMark;

public class LineSeparator
extends VerticalPositionMark {
    protected float lineWidth = 1.0f;
    protected float percentage = 100.0f;
    protected BaseColor lineColor;
    protected int alignment = 1;

    public LineSeparator(float lineWidth, float percentage, BaseColor lineColor, int align, float offset) {
        this.lineWidth = lineWidth;
        this.percentage = percentage;
        this.lineColor = lineColor;
        this.alignment = align;
        this.offset = offset;
    }

    public LineSeparator() {
    }

    public void draw(PdfContentByte canvas2, float llx, float lly, float urx, float ury, float y) {
        canvas2.saveState();
        this.drawLine(canvas2, llx, urx, y);
        canvas2.restoreState();
    }

    public void drawLine(PdfContentByte canvas2, float leftX, float rightX, float y) {
        float s;
        float w = this.getPercentage() < 0.0f ? -this.getPercentage() : (rightX - leftX) * this.getPercentage() / 100.0f;
        switch (this.getAlignment()) {
            case 0: {
                s = 0.0f;
                break;
            }
            case 2: {
                s = rightX - leftX - w;
                break;
            }
            default: {
                s = (rightX - leftX - w) / 2.0f;
            }
        }
        canvas2.setLineWidth(this.getLineWidth());
        if (this.getLineColor() != null) {
            canvas2.setColorStroke(this.getLineColor());
        }
        canvas2.moveTo(s + leftX, y + this.offset);
        canvas2.lineTo(s + w + leftX, y + this.offset);
        canvas2.stroke();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

    public BaseColor getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(BaseColor color) {
        this.lineColor = color;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }
}

