/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.fonts.cmaps;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.fonts.cmaps.AbstractCMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMapToUnicode
extends AbstractCMap {
    private Map<Integer, String> singleByteMappings = new HashMap<Integer, String>();
    private Map<Integer, String> doubleByteMappings = new HashMap<Integer, String>();

    public boolean hasOneByteMappings() {
        return !this.singleByteMappings.isEmpty();
    }

    public boolean hasTwoByteMappings() {
        return !this.doubleByteMappings.isEmpty();
    }

    public String lookup(byte[] code, int offset, int length) {
        String result2 = null;
        Integer key2 = null;
        if (length == 1) {
            key2 = code[offset] & 0xFF;
            result2 = this.singleByteMappings.get(key2);
        } else if (length == 2) {
            int intKey = code[offset] & 0xFF;
            intKey <<= 8;
            key2 = intKey += code[offset + 1] & 0xFF;
            result2 = this.doubleByteMappings.get(key2);
        }
        return result2;
    }

    public Map<Integer, Integer> createReverseMapping() throws IOException {
        HashMap<Integer, Integer> result2 = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, String> entry : this.singleByteMappings.entrySet()) {
            result2.put(this.convertToInt(entry.getValue()), entry.getKey());
        }
        for (Map.Entry<Integer, String> entry : this.doubleByteMappings.entrySet()) {
            result2.put(this.convertToInt(entry.getValue()), entry.getKey());
        }
        return result2;
    }

    public Map<Integer, Integer> createDirectMapping() throws IOException {
        HashMap<Integer, Integer> result2 = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, String> entry : this.singleByteMappings.entrySet()) {
            result2.put(entry.getKey(), this.convertToInt(entry.getValue()));
        }
        for (Map.Entry<Integer, String> entry : this.doubleByteMappings.entrySet()) {
            result2.put(entry.getKey(), this.convertToInt(entry.getValue()));
        }
        return result2;
    }

    private int convertToInt(String s) throws IOException {
        byte[] b = s.getBytes("UTF-16BE");
        int value = 0;
        for (int i2 = 0; i2 < b.length - 1; ++i2) {
            value += b[i2] & 0xFF;
            value <<= 8;
        }
        return value += b[b.length - 1] & 0xFF;
    }

    void addChar(int cid, String uni) {
        this.doubleByteMappings.put(cid, uni);
    }

    @Override
    void addChar(PdfString mark, PdfObject code) {
        block4: {
            try {
                byte[] src = mark.getBytes();
                String dest = this.createStringFromBytes(code.getBytes());
                if (src.length == 1) {
                    this.singleByteMappings.put(src[0] & 0xFF, dest);
                    break block4;
                }
                if (src.length == 2) {
                    int intSrc = src[0] & 0xFF;
                    intSrc <<= 8;
                    this.doubleByteMappings.put(intSrc |= src[1] & 0xFF, dest);
                    break block4;
                }
                throw new IOException(MessageLocalization.getComposedMessage("mapping.code.should.be.1.or.two.bytes.and.not.1", src.length));
            }
            catch (Exception ex) {
                throw new ExceptionConverter(ex);
            }
        }
    }

    private String createStringFromBytes(byte[] bytes) throws IOException {
        String retval = null;
        retval = bytes.length == 1 ? new String(bytes) : new String(bytes, "UTF-16BE");
        return retval;
    }
}

