/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.CMapAwareDocumentFont;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.LineSegment;
import com.itextpdf.text.pdf.parser.MarkedContentInfo;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.Vector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRenderInfo {
    private final String text;
    private final Matrix textToUserSpaceTransformMatrix;
    private final GraphicsState gs;
    private final Collection<MarkedContentInfo> markedContentInfos;

    TextRenderInfo(String text2, GraphicsState gs, Matrix textMatrix, Collection<MarkedContentInfo> markedContentInfo) {
        this.text = text2;
        this.textToUserSpaceTransformMatrix = textMatrix.multiply(gs.ctm);
        this.gs = gs;
        this.markedContentInfos = new ArrayList<MarkedContentInfo>(markedContentInfo);
    }

    private TextRenderInfo(TextRenderInfo parent, int charIndex, float horizontalOffset) {
        this.text = parent.text.substring(charIndex, charIndex + 1);
        this.textToUserSpaceTransformMatrix = new Matrix(horizontalOffset, 0.0f).multiply(parent.textToUserSpaceTransformMatrix);
        this.gs = parent.gs;
        this.markedContentInfos = parent.markedContentInfos;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasMcid(int mcid) {
        return this.hasMcid(mcid, false);
    }

    public boolean hasMcid(int mcid, boolean checkTheTopmostLevelOnly) {
        if (checkTheTopmostLevelOnly) {
            if (this.markedContentInfos instanceof ArrayList) {
                ArrayList mci = (ArrayList)this.markedContentInfos;
                return mci.size() > 0 && ((MarkedContentInfo)mci.get(mci.size() - 1)).getMcid() == mcid;
            }
        } else {
            for (MarkedContentInfo info : this.markedContentInfos) {
                if (!info.hasMcid() || info.getMcid() != mcid) continue;
                return true;
            }
        }
        return false;
    }

    float getUnscaledWidth() {
        return this.getStringWidth(this.text);
    }

    public LineSegment getBaseline() {
        return this.getUnscaledBaselineWithOffset(0.0f + this.gs.rise).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public LineSegment getAscentLine() {
        float ascent = this.gs.getFont().getFontDescriptor(1, this.gs.getFontSize());
        return this.getUnscaledBaselineWithOffset(ascent + this.gs.rise).transformBy(this.textToUserSpaceTransformMatrix);
    }

    public LineSegment getDescentLine() {
        float descent = this.gs.getFont().getFontDescriptor(3, this.gs.getFontSize());
        return this.getUnscaledBaselineWithOffset(descent + this.gs.rise).transformBy(this.textToUserSpaceTransformMatrix);
    }

    private LineSegment getUnscaledBaselineWithOffset(float yOffset) {
        float correctedUnscaledWidth = this.getUnscaledWidth() - this.gs.characterSpacing * this.gs.horizontalScaling;
        return new LineSegment(new Vector(0.0f, yOffset, 1.0f), new Vector(correctedUnscaledWidth, yOffset, 1.0f));
    }

    public DocumentFont getFont() {
        return this.gs.getFont();
    }

    public float getRise() {
        if (this.gs.rise == 0.0f) {
            return 0.0f;
        }
        return this.convertHeightFromTextSpaceToUserSpace(this.gs.rise);
    }

    private float convertWidthFromTextSpaceToUserSpace(float width) {
        LineSegment textSpace = new LineSegment(new Vector(0.0f, 0.0f, 1.0f), new Vector(width, 0.0f, 1.0f));
        LineSegment userSpace = textSpace.transformBy(this.textToUserSpaceTransformMatrix);
        return userSpace.getLength();
    }

    private float convertHeightFromTextSpaceToUserSpace(float height) {
        LineSegment textSpace = new LineSegment(new Vector(0.0f, 0.0f, 1.0f), new Vector(0.0f, height, 1.0f));
        LineSegment userSpace = textSpace.transformBy(this.textToUserSpaceTransformMatrix);
        return userSpace.getLength();
    }

    public float getSingleSpaceWidth() {
        return this.convertWidthFromTextSpaceToUserSpace(this.getUnscaledFontSpaceWidth());
    }

    public int getTextRenderMode() {
        return this.gs.renderMode;
    }

    private float getUnscaledFontSpaceWidth() {
        char charToUse = ' ';
        if (this.gs.font.getWidth(charToUse) == 0) {
            charToUse = '\u00a0';
        }
        return this.getStringWidth(String.valueOf(charToUse));
    }

    private float getStringWidth(String string2) {
        CMapAwareDocumentFont font = this.gs.font;
        char[] chars = string2.toCharArray();
        float totalWidth = 0.0f;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            float w = (float)((DocumentFont)font).getWidth(chars[i2]) / 1000.0f;
            float wordSpacing = chars[i2] == ' ' ? this.gs.wordSpacing : 0.0f;
            totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing + wordSpacing) * this.gs.horizontalScaling;
        }
        return totalWidth;
    }

    public List<TextRenderInfo> getCharacterRenderInfos() {
        ArrayList<TextRenderInfo> rslt = new ArrayList<TextRenderInfo>(this.text.length());
        CMapAwareDocumentFont font = this.gs.font;
        char[] chars = this.text.toCharArray();
        float totalWidth = 0.0f;
        for (int i2 = 0; i2 < chars.length; ++i2) {
            float w = (float)((DocumentFont)font).getWidth(chars[i2]) / 1000.0f;
            float wordSpacing = chars[i2] == ' ' ? this.gs.wordSpacing : 0.0f;
            TextRenderInfo subInfo = new TextRenderInfo(this, i2, totalWidth);
            rslt.add(subInfo);
            totalWidth += (w * this.gs.fontSize + this.gs.characterSpacing + wordSpacing) * this.gs.horizontalScaling;
        }
        return rslt;
    }
}

