/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.security;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.XmlSignatureAppearance;
import com.itextpdf.text.pdf.security.ExternalSignature;
import com.itextpdf.text.pdf.security.XmlLocator;
import com.itextpdf.text.pdf.security.XpathConstructor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import org.apache.jcp.xml.dsig.internal.dom.DOMKeyInfoFactory;
import org.apache.jcp.xml.dsig.internal.dom.DOMReference;
import org.apache.jcp.xml.dsig.internal.dom.DOMSignedInfo;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.apache.jcp.xml.dsig.internal.dom.DOMXMLSignature;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MakeXmlSignature {
    public static void signXmlDSig(XmlSignatureAppearance sap, ExternalSignature externalSignature, KeyInfo keyInfo) throws GeneralSecurityException, IOException, DocumentException {
        String signatureMethod;
        XmlLocator xmlLocator = sap.getXmlLocator();
        if (xmlLocator == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("xmllocator.cannot.be.null", new Object[0]));
        }
        if (!externalSignature.getHashAlgorithm().equals("SHA1")) {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("support.only.sha1.hash.algorithm", new Object[0]));
        }
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
        DigestMethod digestMethodSHA1 = fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Document doc = xmlLocator.getDocument();
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        transforms.add(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null));
        XpathConstructor xpathConstructor = sap.getXpathConstructor();
        if (xpathConstructor != null && xpathConstructor.getXpathExpression().length() > 0) {
            XPathFilter2ParameterSpec xpath2Spec = new XPathFilter2ParameterSpec(Collections.singletonList(new XPathType(xpathConstructor.getXpathExpression(), XPathType.Filter.INTERSECT)));
            transforms.add(fac.newTransform("http://www.w3.org/2002/06/xmldsig-filter2", xpath2Spec));
        }
        DOMReference reference = (DOMReference)fac.newReference("", digestMethodSHA1, transforms, null, null);
        if (externalSignature.getEncryptionAlgorithm().equals("RSA")) {
            signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else if (externalSignature.getEncryptionAlgorithm().equals("DSA")) {
            signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("support.only.rsa.and.dsa.algorithms", new Object[0]));
        }
        DOMSignedInfo signedInfo = (DOMSignedInfo)fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod(signatureMethod, null), Collections.singletonList(reference));
        DOMSignContext domSignContext = new DOMSignContext(EmptyKey.getInstance(), (Node)doc.getDocumentElement());
        DOMXMLSignature signature2 = (DOMXMLSignature)fac.newXMLSignature((SignedInfo)signedInfo, keyInfo);
        ByteArrayOutputStream byteRange = new ByteArrayOutputStream();
        try {
            signature2.marshal(domSignContext.getParent(), domSignContext.getNextSibling(), DOMUtils.getSignaturePrefix((XMLCryptoContext)domSignContext), (DOMCryptoContext)domSignContext);
            reference.digest((XMLSignContext)domSignContext);
            signedInfo.canonicalize((XMLCryptoContext)domSignContext, byteRange);
            Element signElement = MakeXmlSignature.findElement(doc.getDocumentElement().getChildNodes(), "Signature");
            Element signValue = MakeXmlSignature.findElement(signElement.getChildNodes(), "SignatureValue");
            String valueBase64 = Base64.encode((byte[])externalSignature.sign(byteRange.toByteArray()));
            signValue.appendChild(doc.createTextNode(valueBase64));
            xmlLocator.setDocument(doc);
        }
        catch (Exception e) {
            throw new DocumentException(e);
        }
        sap.close();
    }

    public static void signXmlDSig(XmlSignatureAppearance sap, ExternalSignature externalSignature, Certificate[] chain) throws DocumentException, GeneralSecurityException, IOException {
        Certificate certificate = chain[0];
        sap.setCertificate(certificate);
        DOMKeyInfoFactory kif = new DOMKeyInfoFactory();
        X509Data x509d = kif.newX509Data(Collections.singletonList(certificate));
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(x509d));
        MakeXmlSignature.signXmlDSig(sap, externalSignature, ki);
    }

    public static void signXmlDSig(XmlSignatureAppearance sap, ExternalSignature externalSignature, PublicKey publicKey) throws GeneralSecurityException, DocumentException, IOException {
        DOMKeyInfoFactory kif = new DOMKeyInfoFactory();
        KeyValue kv = kif.newKeyValue(publicKey);
        MakeXmlSignature.signXmlDSig(sap, externalSignature, kif.newKeyInfo(Collections.singletonList(kv)));
    }

    private static Element findElement(NodeList nodes, String localName) {
        for (int i2 = nodes.getLength() - 1; i2 >= 0; --i2) {
            Node currNode = nodes.item(i2);
            if (currNode.getNodeType() != 1 || !currNode.getLocalName().equals(localName)) continue;
            return (Element)currNode;
        }
        return null;
    }

    private static class EmptyKey
    implements Key {
        private static EmptyKey instance = new EmptyKey();

        private EmptyKey() {
        }

        public static EmptyKey getInstance() {
            return instance;
        }

        public String getAlgorithm() {
            return null;
        }

        public String getFormat() {
            return null;
        }

        public byte[] getEncoded() {
            return new byte[0];
        }
    }
}

